<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche le prefixe, le nom de la grille et la note de la grille
 * 
 * @package presentiel
 */
  class guiFoPresentielContenuGrilleLibelle extends PageComponent{
 	/**
 	 * Affiche le prefixe, le nom de la grille et la note de la grille
 	 * 
 	 * @param string[] Tableau contenant l'ensemble des notes presentielles d'un individu pour une grille 
 	 * @param string Le libelle de la grille
 	 * @param integer L'identifiant de la grille
 	 * @param integer L'identifiant d'individu
 	 * @param integer L'identifiant de formation
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoPresentielContenuGrilleLibelle($tab,$libelle_grille,$grille,$individu,$formation,$module_root=null,$templates=null){
		global $chemin_fo,$MSG_226; 		
 		parent::PageComponent($module_root,$templates);

 		//Recupere le nombre de date pour effectuer un colspan dynamique.
 		$resdate=get_formation_evenements_presentiels($formation);
		$nbdate=pg_num_rows($resdate);
 		$nbcolonne = $nbdate + 1;//On ajoute 1 car il faut compte la cellule ou est place le libelle "Date".
 		
 		//On calcul l'ensemble des notes.
		$notegrille=note_globale_grille($formation,$individu,$grille,$tab);
		$notegrille *=100;
		$notegrille=round($notegrille);
		$notegrille /=100;
		
		//On injecte dans les variables tpl.
		$val['NOMBRE_COLONNE']=$nbcolonne;
		$val['LIBELLE_GRILLE']=$MSG_226 .":". get_fo_libelle($libelle_grille);
		$val['NOTE_GRILLE']=" ($notegrille / 20)";
		
		parent::set_var($val);
 	}
 }
?>