<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit l'affichage des titres capacits ainsi que leurs contenu
 * 
 * @package presentiel
 */
  class guiFoPresentielContenuGrilleTitreCapacite extends PageComponent{
 	/**
 	 * Affichage des titres capacits et leur contenu
 	 * 
 	 * @param string[] $tab Tableau comportant l'ensembles des notes presentielles d'un individu pour une grille.
 	 * @param integer $nbdate Le nombre de date de capacit
 	 * @param integer[] $resdate L'ensemble des donnes retourner par la fonction et_formation_evenements_presentiels($formation)
 	 * @param integer $num_titre L'identifiant du titre de capacit
 	 * @param string $libelle_titre Le libelle du titre de capacit
 	 * @param string $notetitrecapacite La note (moyenne) de titre capacit
 	 * @param integer $formation L'identifant de formation
 	 * @param integer $individu L'identifant d'individu
 	 * @param integer $grille L'identifiant de la grille
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoPresentielContenuGrilleTitreCapacite($tab,$nbdate,$resdate,$num_titre,$libelle_titre,$notetitrecapacite,$formation,$individu,$grille,$module_root=null,$templates=null){
		global $chemin_fo ; 		
 		parent::PageComponent($module_root,$templates);
		
		//Recupere le nombre de date pour effectuer un colspan dynamique.
 		$resdate=get_formation_evenements_presentiels($formation);
		$nbdate=pg_num_rows($resdate);
 		$nbcolonne = $nbdate + 1;//On ajoute 1 car il faut compte la cellule ou est place le libelle "Date".
 		
 		//On recupere les titres de capacits.
 		$rescapa=get_titrecapacite_capacites($num_titre);
		$nbcapa=pg_numrows($rescapa);
 		
 		//On injecte dans les variables tpl.
 		$val['NOMBRE_COLONNE']=$nbcolonne;
 		$val['LIBELLE_TITRE_CAPACITE']=get_fo_libelle($libelle_titre);
 		$val['CAPACITES_NUM']="($notetitrecapacite/20)";

 		//Ici on boucle sur les capacites 
 		parent::set_block('block_line_titre_capacites','block','bloc_capacite');
 		 for($c=0;$c<$nbcapa;$c++){
	        $rowcapa=pg_fetch_row($rescapa,$c);
 			$presentiel_contenu_grille_capacites = new guiFoPresentielContenuGrilleCapacites($nbdate,$resdate,$num_titre,$rowcapa[0],$rowcapa[1],$formation,$individu,$grille,$module_root,array('block_line'=>'gui_fo_presentiel_contenu_grille_capacites.tpl'));
 			$this->setComponent('block_line',$presentiel_contenu_grille_capacites,true,'block','bloc_capacite');
// 			$this->setComponent('block_line',$presentiel_contenu_grille_capacites,true,'block','bloc_capacite');
// 			$this->setComponent('block_line',$presentiel_contenu_grille_capacites,true,'block','bloc_capacite');
// 			$this->setComponent('block_line',$presentiel_contenu_grille_capacites,true,'block','bloc_capacite');
// 			$this->setComponent('block_line',$presentiel_contenu_grille_capacites,true,'block','bloc_capacite');
// 			$this->setComponent('block_line',$presentiel_contenu_grille_capacites,true,'block','bloc_capacite');
 		 }
 		parent::set_var($val);
 	}
 }
?>