<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class contient le PresentielModuleDebut qui affiche une lgende et un texte, ainsi que le PresentielModuleContenu
 * qui affiche la ou les grilles de presentiels d'un individu, avec un select qui permet de switcher entre les differentes grille 
 * qu'il peut y avoir.
 *
 *  @package presentiel
 */
  class guiFoPresentielModule extends PageComponent{
 	/**
 	 * Obtenir l'affichage de Grille Prsentiel
 	 * 
 	 * @param integer $formation L'identifant de la formation
 	 * @param integer $individu L'identifant d'individu
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoPresentielModule($formation,$individu,$grille,$module_root=null,$templates=null){
		global $chemin_fo; 		
 		parent::PageComponent($module_root,$templates);
 		
 		$debut = new guiFoPresentielModuleDebut("$chemin_fo/presentiel/templates/tpl",array('debut_module'=>'gui_fo_presentiel_module_debut.tpl'));
 		$this->setComponent('debut_module',$debut);
 		
 		$contenu = new guiFoPresentielModuleContenu($formation,$individu,$grille,"$chemin_fo/presentiel/templates/tpl",array('contenu_module'=>'gui_fo_presentiel_module_contenu.tpl'));
 		$this->setComponent('contenu_module',$contenu);
 	}
 }
?>