<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit le PresentielModuleContenu, 
 * elle contient : 
 * Le debut du tableau qui est compos des information de l'individu.
 * Le contenu du tableau qui est compos de l'ensemble des donnes de la grille Prsentiel.
 * La fin du tableau qui est compos du select.
 * 
 * @package presentiel
 */
 class guiFoPresentielModuleContenu extends PageComponent{
 	/**
 	 * @param integer $formation L'identifant de formation
 	 * @param integer $individu L'identifant d'individu
 	 * @param integer $grille L'identifiant de la grille
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoPresentielModuleContenu($formation,$individu,$grille,$module_root=null,$templates=null){
		global $chemin_fo; 		
 		parent::PageComponent($module_root,$templates);
 		
 		//Si il n y a pas d'identifiant de grille, on rcupre toutes les grilles de la formations
		if(empty($grille)){
			$resgrille=get_formation_grilles($formation);
			$nbgrille=pg_num_rows($resgrille);
			//echo "nb=$nbgrille<br>";
			if($nbgrille){
				$rowgrille=pg_fetch_row($resgrille,0);
				$grille=$rowgrille[0];
			}
 		}
		else{
		    $resgrille=get_grille($grille);
        	$rowgrille=pg_fetch_row($resgrille,0);
        	$nbgrille=1;
		}
 		
 		//On recupere les notes presentielles d'un individu pour une grille
 		if($nbgrille){
 			$res=get_presentiel_resultats_individu_grille($formation,$individu,$grille);
			$nb=pg_num_rows($res);
 		
		
			// On met les resultats en tableau
			$tab=array();
			while($row=pg_fetch_row($res)){
				$tab[]=$row;
			}
 		}
 		
 		//Affichage du nom du Stagiaire
 		$presentiel_contenu_debut = new guiFoPresentielContenuDebut($formation,$individu,"$chemin_fo/presentiel/templates/tpl",array('debut_contenu'=>'gui_fo_presentiel_contenu_debut.tpl'));
 		$this->setComponent('debut_contenu',$presentiel_contenu_debut);
 		
 		//Affichage des dates qui contiennent les titres, qui contiennent les capacite qui on leurs cartons
 		if($nbgrille){
 			$presentiel_contenu_grille = new guiFoPresentielContenuGrille('contenu_grille',$tab,$rowgrille[1],$grille,$individu,$formation,"$chemin_fo/presentiel/templates/tpl",array('contenu_grille'=>'gui_fo_presentiel_contenu_grille.tpl'));
 			$this->setComponent('contenu_grille',$presentiel_contenu_grille);
 			//Affichage du Formulaire <select> des grilles
 		$presentiel_contenu_fin = new guiFoPresentielContenuFin($formation,$resgrille,$nbgrille,$grille,"$chemin_fo/presentiel/templates/tpl",array('fin_contenu'=>'gui_fo_presentiel_contenu_fin.tpl'));
 		$this->setComponent('fin_contenu',$presentiel_contenu_fin);
 		}
 		else{
 			$presentiel_contenu_grille = new guiFoPresentielContenuNoGrille('contenu_grille',"$chemin_fo/presentiel/templates/tpl",array('contenu_grille'=>'gui_fo_presentiel_contenu_no_grille.tpl'));
 			$this->setComponent('contenu_grille',$presentiel_contenu_grille);	
 		}
 		
 		$this->set_var('DEFILEMENT_LABEL',MSG_2709);
 	}
 }
?>