<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on Apr 9, 2008
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 /**
  * Class qui construit le contenu tpl pour une correction �valuation qsrc
  * 
  * @author Ladjani said
  * @version 
  * @package qsrc
  */
 class guiFoListeCorrectionQsrc extends PageComponent{
  	/**
	 * Constructeur
	 * 
	 * @param object[] objet evaluation
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */
	 function guiFoListeCorrectionQsrc($block_target,$obj_evaluation_correction,$module_root,$templates){
	 	parent::PageComponent($module_root,$templates);
//	 	print_rr($templates);
	 	global $chemin_fo;
	 	
	 	//print_rr($obj_evaluation);
	 	// l'objet evaluation
	 	$obj_evaluation=$obj_evaluation_correction->getEvaluation();
	 	/* PREPARATION DES DONNEES */
	 	// recup la question commune
	 	$question_commune=get_fo_libelle($obj_evaluation->getQuestionCommune());
	 	// nombre de reponses
	 	$nb_reponse=$obj_evaluation->getNbReponses();
	 	// nombre de questions
	 	$nb_question=$obj_evaluation->getNbQuestions();
	 	//echo "nb_quest=$nb_question<br>";

	 	
	 	
	 	/* QUESTION COMMUNE */
	 	$module_root=$chemin_fo."/question_reponse_element/templates/tpl";
	 	$component=new guiFoEvaluationQuestionReponseElementTexte('evaluation_serie',$question_commune,$module_root,array('evaluation_serie'=>'evaluation_question_reponse_element_texte.tpl'));
	 	$this->setComponent('evaluation_serie',$component);
	 	
	 	
	 	/* LES REPONSES */
	 	$this->set_block($block_target,'do_reponses','do_rep');
	 	for($i=0;$i<$nb_reponse;$i++){
	 		// recup l'objet reponse courant
	 		$indice=$i+1;
	 		$obj_reponse=$obj_evaluation->getObjReponses($indice);
	 		//print_rr($obj_reponse);
	 		$component=new guiFoEvaluationQuestionReponseElement('reponse_do_reponse',$obj_reponse,$chemin_fo."/question_reponse_element/templates/tpl",array('reponse_do_reponse'=>'gui_fo_evaluation_question_reponse_element.tpl'));
	 		$this->setComponent('reponse_do_reponse',$component,true,'do_reponses','do_rep');	
	 	}
	 	
	 	
	 	
	 	/* LES QUESTIONS */
	 	$this->set_block($block_target,'do_question','do_quest');
	 	for($i=0;$i<$nb_question;$i++){
	 		$indice=$i+1;
	 		$obj_question=$obj_evaluation->getObjQuestions($indice);
	 		//print_rr($obj_question);
	 		$id_question=$obj_question->getId();
	 		//echo "ici id_q=$id_question<br>";	
//	 		print_rr($obj_EvaluationCorrection);
	 		$component=new guiFoQuestionReponseCorrectionQuestionReponseElement('question_do_question',$indice,$obj_question,$id_question,$this->tab_reponses_cochees[$indice],$obj_evaluation_correction,$chemin_fo."/question_reponse/templates/tpl",array('question_do_question'=>'gui_fo_question_reponse_correction_question_reponse_element.tpl'),false);
	 		$this->setComponent('question_do_question',$component,true,'do_question','do_quest');	
	 			
	 	}
		
	 }
  	
  	
  	
  	
  	
  	
 }  
?>
