<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit l'affichage du titre de l'espace et le ou les sections
 */
  class guiFoEspaceGlossaireSections extends PageComponent{
 	/**
 	 * Construit l'ensemble des elements necessaire a l'affichage du libelle titre espace et des sections
 	 * 
 	 * @param string $lien_url_ressource Le lien qui va permettre une redirection pour l'affichage des ressources.
 	 * @param integer $num_espace L'identifiant de l'espace.
 	 * @param string $espace_titre Le libelle du titre de l'espace
 	 * @param mixed[] $tab_section L'ensemble des donn�es d'information pour une section
 	 * @param integer $formation L'identifiant de la formation
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoEspaceGlossaireSections($block_target,$obj_DoEtape,$num_espace,$espace_titre,$tab_ressource,$module_root=null,$templates=null){
		parent::PageComponent($module_root,$templates);
		$glossaire= new FichierGlossaire($tab_ressource[0]);
		$tab_words=$glossaire->getWords();
		$nbsections=count($tab_words);
		$sections=array_keys($tab_words);

		//on boucle sur les sections	
		$this->set_block($block_target,'block','bloc_section');
		for($i=0;$i<$nbsections; $i++){
			$section_key=$sections[$i];
			$gui_fo_section = new guiFoSectionGlossaire($obj_DoEtape,$num_espace,$section_key,$glossaire,$module_root,array('block_line'=>'gui_fo_section_glossaire.tpl'));
			$this->setComponent('block_line',$gui_fo_section,true,'block','bloc_section');
		}
	}
 }
?>