<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit l'affichage du titre de l'espace et le ou les sections
 */
  class guiFoEspaceSections extends PageComponent{
 	/**
 	 * Construit l'ensemble des elements necessaire a l'affichage du libelle titre espace et des sections
 	 * 
 	 * @param string $lien_url_ressource Le lien qui va permettre une redirection pour l'affichage des ressources.
 	 * @param integer $num_espace L'identifiant de l'espace.
 	 * @param string $espace_titre Le libelle du titre de l'espace
 	 * @param mixed[] $tab_section L'ensemble des donn�es d'information pour une section
 	 * @param integer $formation L'identifiant de la formation
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoEspaceSections($block_target,$obj_DoEtape,$num_espace,$espace_titre,$tab_sections,$formation,$module_root=null,$templates=null){
		parent::PageComponent($module_root,$templates);
		$old_section ="";
		$nbsections=count($tab_sections);

		//creation d'un tableau vide pour le test des doublons sur les sections
		$test_section = array();	
		
		//on boucle sur les sections	
		$this->set_block($block_target,'block','bloc_section');
		for($i=0;$i<$nbsections; $i++){
			//on recupere les numeros d'espaces
			$section_num_espace= $tab_sections[$i][2];//Modification de $tab_sections[$i][0]
			//on recupere le numero des sections
			$section_num = $tab_sections[$i][4];//Modification de $tab_sections[$i][4]
			//on recupere les titres des sections
			$section_titre = $tab_sections[$i][5];//Modification de $tab_sections[$i][5]
			$debut=$tab_sections[$i][10];

			//on compare l'egalite pour verifier que le numero d'espace de cette boucle est egal au numero d espace de la boucle precedente
			if($section_num_espace == $num_espace){
				if(!in_array($tab_sections[$i][4],$test_section)){//Modification de $tab_sections[$i][2]
					$test_section[] = $tab_sections[$i][4];//Modification de $tab_sections[$i][2]	
					
					if($tab_sections[$i][8]!=TYPE_FICHIER_GLOSSAIRE){
						$gui_fo_section = new guiFoSection($obj_DoEtape,$section_num_espace,$section_num,$section_titre,$formation,$tab_sections,$module_root,array('block_line'=>'gui_fo_section.tpl'));
					}else{
						$glossaire= new FichierGlossaire($tab_sections[$i][0]);
						$tab_words=$glossaire->getWords();
						$sections=array_keys($tab_words);
						$section_key=$sections[$i];
						
						$gui_fo_section = new guiFoSectionGlossaire($obj_DoEtape,$section_num_espace,$section_key,$glossaire,$module_root,array('block_line'=>'gui_fo_section.tpl'));
					}
					$this->setComponent('block_line',$gui_fo_section,true,'block','bloc_section');
				}
			}			
		}
	}
 }
?>