<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit l'affichage des espaces et des sections
 */
 class guiFoEspaces extends PageComponent{
 	/**
 	 * Construction des Espaces et des sections
 	 * 
 	 * @param string $lien_url_ressource Le lien qui va permettre une redirection pour l'affichage des ressources.
 	 * @param string $block_target Le nom de la variable qui contiendra la boucle dans le tpl.
 	 * @param integer $num_espace L'identifiant de l'espace.
 	 * @param integer $formation L'identifiant de la formation
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoEspaces($obj_DoEtape,$block_target,$num_espace,$formation,$module_root=null, $templates=null){
 		global $chemin_fo,$MSG_2552,$auth;
 		parent::PageComponent($module_root,$templates);

 		if(!empty($num_espace)){
 			$ressections = get_formation_espace_sections($formation,$num_espace);
 			$nbsections=pg_num_rows($ressections);
			$tab_sections = pg_super_fetch_array($ressections);
 		}
 		else{
 			// test si fusion ressources
 			$res_formation=get_formation($formation);
 			$fusion_ressource=pg_fetch_result($res_formation,0,6);

 			if(!sql2Bool($fusion_ressource))
 				$ressections = get_formation_ressources($formation,bool2Sql(false));
 			else{
 				// recup des ressources de la formation + etapes ressources faites par l'individu
 				$individu=$auth->auth['user_id'];
 				
 				$ressections = get_formation_all_ressources_individu($formation,bool2Sql(false),$individu);
 			}
			$nbsections=pg_num_rows($ressections);
			$tab_sections = pg_super_fetch_array($ressections);
 		}
 		$old_espace=null;

 		//on boucle sur les espaces
 		if($nbsections>0){
	 		parent::set_block($block_target,'block','bloc_espace');
	 		for($i=0;$i<$nbsections; $i++){
	 			$num_espace = $tab_sections[$i][2];
	 			
	 			if($old_espace != $num_espace){
	 				$espace_titre = $tab_sections[$i][3];
					$gui_fo_espace = new guiFoEspace(new Espace($num_espace),$module_root,array('espace'=>'gui_fo_espace.tpl'));
					$this->setComponent('espace',$gui_fo_espace,true,'block','bloc_espace');	

					if($tab_sections[$i][8]==TYPE_FICHIER_GLOSSAIRE){
						$contenu = new guiFoEspaceGlossaireSections('espace_sections',$obj_DoEtape,$num_espace,$espace_titre,$tab_sections[$i],"$chemin_fo/ressource/templates/tpl",array('espace_sections'=>'gui_fo_espace_glossaire_sections.tpl'));
					}else{
		 				$contenu = new guiFoEspaceSections('espace_sections',$obj_DoEtape,$num_espace,$espace_titre,$tab_sections,$formation,"$chemin_fo/ressource/templates/tpl",array('espace_sections'=>'gui_fo_espace_sections.tpl'));
					}
					$this->setComponent('espace_sections',$contenu,true,'block','bloc_espace');
					$old_espace = $num_espace;	
	 			}
	 		}
 		}
 		else{
 			if(!empty($num_espace)){
	 			$gui_fo_espace = new guiFoEspace(new Espace($num_espace),$module_root,array('espace'=>'gui_fo_espace.tpl'));
				$this->setComponent('espace',$gui_fo_espace);	
 			}
 			$this->set_var('ESPACE_SECTIONS', $MSG_2552);
 			
 		}
 	}
 }
?>