<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Composant graphique pour l'affichage d'une ressource texte de glossaire
 * 
 * @package glossaire
 * @author revz (Remi Cocquet)
 */
class guiFoGlossaireRessource extends PageComponent{
	/**
	 * Affichage d'une ressource texte de glossaire
	 * 
	 * @param  integer $num_fichier L'identifiant du fichier
	 * @param  string $libelle_ressource Le libelle de la ressource
	 * @param  string $datedeb La date de debut de la ressource 
	 * @param  string $datefin La date de fin de la ressource 
	 * @param  integer $num_ressource L'identifiant de la ressource
	 * @param  integer $numero_espace L'identifiant de l'espace
	 * @param  integer $numero_section L'identifiant de la section
	 * @param  integer $formation L'identifiant de la formation
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoGlossaireRessource($id_fichier,$libelle_ressource,$datedeb,$datefin,$numero_espace,$numero_section,$formation,$module_root=null,$templates=null){
		parent::PageComponent($module_root,$templates);

		$res_fichier=get_fichier_texte($id_fichier) ;
		$row=pg_fetch_row($res_fichier);
		
		$val ['RESSOURCE_ID'] =$row[0];
		$val ['RESSOURCE_LIBELLE'] =get_fo_libelle($row[1]);
		
		if($datedeb && $datefin)
			$val ['RESSOURCE_DESCRIPTION'] ="(".MSG_2539."  $datedeb ".MSG_2540." $datefin)";
		else
			$val ['RESSOURCE_DESCRIPTION'] ="";	
			
		$val ['RESSOURCE_TEXTE'] =get_fo_libelle($row[7]);
		$this->set_var($val);	
	}
}
?>