<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche le lien retour qui ce trouve sur les pages ressources.
 * Attention cette class est importante car elle gere aussi le lien retour a partir
 * des ressource etape.
 * 
 * @package ressource
 */
 class guiFoLienRetour extends PageComponent{
 	/**
 	 * Affichage du lien retour
 	 * 
 	 * @param object[] $obj_DoEtape L'ensemble des information d'une etape
 	 * @param integer $numetape L'identifiant d'une etape
 	 * @param integer $formation L'identifiant de la formation
 	 * @param integer $section L'identifiant de la section
 	 * @param integer $espace L'identifiant de l'espace
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoLienRetour($obj_DoEtape,$module_root=null, $templates=null){
 		global $MSG_37;
 		parent::PageComponent($module_root, $templates);
 		
		//On passe l objet serialize dans le lien url pour un retour efficace sur la bonne etape			
		$val['LIEN_URL']="../parcours/parcours_action.php?force_no_end=$force_no_end&action_target=../ressource/ressource.php?sz_obj_doetape=".urlencode(exportObjet($obj_DoEtape));
 		$val['LIBELLE_BOUTON_RETOUR']=$MSG_37;
 		parent::set_var($val);
 	}
 }
?>