<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class contient le RessourceModuleDebut qui construit le texte et le moteur de recherche de la page ressource, 
 * ainsi que le guiFoEspaces qui affiche le contenu principal de la page qui est les espaces et les sections.
 * Attention la page ressource est divis en deux partis, ressource.php qui affichera les espaces et leur section et
 * ressource.php3 qui affichera les ressources des sections.
 * 
 * @package ressource
 */
 class guiFoModuleRessource extends PageComponent{
 	/**
 	 * Construit l'affichage de la page ressource
 	 *
 	 * @param integer $num_espace L'identifiant de l'espace.
 	 * @param string $lien_url_ressource Le lien qui va permettre une redirection pour l'affichage des ressources.
 	 * @param integer $formation L'identifiant de la formation   	 
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoModuleRessource($num_espace,$lien_url_ressource,$formation,$module_root=null, $templates=null){
	global $chemin_fo; 		
 		parent::PageComponent($module_root,$templates);
 
 		$debut = new guiFoModuleRessourceDebut("$chemin_fo/ressource/templates/tpl",array('debut_module'=>'gui_fo_module_ressource_debut.tpl'));
 		$this->setComponent('debut_module',$debut);
 		
 		$contenu = new guiFoEspaces($lien_url_ressource,'contenu_module',$num_espace,$formation,"$chemin_fo/ressource/templates/tpl",array('contenu_module'=>'gui_fo_espaces.tpl'));
 		$this->setComponent('contenu_module',$contenu);
 	}
 }
?>