<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class va permetre de construire l'affichage du debut de la page ressource, qui comporte 
 * un texte explicatif ainsi qu'un moteur de recherche pour les ressources
 * 
 * @package ressource 
 */ 
class guiFoModuleRessourceDebut extends PageComponent{
	/**
	 * Construit les objets necessaire � l'affichage du debut de la page ressource
	 * 
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoModuleRessourceDebut($module_root=null,$templates=null){
		global $chemin_fo;
		parent::PageComponent($module_root,$templates);
		
		
		$ressource_module_presentation = new RessourceModulePresentation($module_root,array('debut_presentation' => 'ressource_module_presentation.tpl'));
		$this->setComponent('debut_presentation',$ressource_module_presentation);
		
		//TODO moteur de recherche à implémenter
//		$ressource_module_barre_recherche = new RessourceModuleBarreRecherche($module_root,array('debut_recherche'=>'ressource_module_barre_recherche.tpl'));
//		$this->setComponent('debut_recherche',$ressource_module_barre_recherche);
		
	}
}
?>