<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit l'affichage de la ressource adequat � l'identifiant du type selectionn�
 *
 *@package ressource
 **/
class guiFoRessourceFactory {
	/**
	 * Cr�e et retourne une Ressource.
	 * Note:construit une Ressource selon le type selectionn� et stocke dans une varible $ressource et la retourne
	 * 
	 * @param  string $target_component  Le nom de la variable qui contiendra la boucle dans le tpl.
	 * @param  string $module_root Le chemin du dossier contenant les tpl requis
	 * @param  integer $type L'identifiant de la constante utilis�
	 * @param  integer $num_fichier L'identifiant du fichier
	 * @param  string $libelle_ressource Le libelle de la ressource
	 * @param  string $datedeb La date de debut de la ressource 
	 * @param  string $datefin La date de fin de la ressource 
	 * @param  integer $num_ressource L'identifiant de la ressource
	 * @param  integer $numero_espace L'identifiant de l'espace
	 * @param  integer $numero_section L'identifiant de la section
	 * @param  integer $formation L'identifiant de la formation
	 * 
	 * @return PageComponent $ressource
	 */
	function createGuiFoRessource($target_component,$module_root,$type, $num_fichier,$libelle_ressource,$datedeb,$datefin,$numero_espace,$numero_section,$formation){
		global $chemin_fo;

		switch($type){
			case TYPE_FICHIER_RESSOURCE_TEXTE:
				$ressource=new guiFoRessourceTexte($num_fichier,$libelle_ressource,$datedeb,$datefin,$numero_espace,$numero_section,$formation,$module_root,array($target_component => 'gui_fo_ressource_texte.tpl'));
				break;
			case TYPE_FICHIER_RESSOURCE:
				$ressource=new guiFoRessource($num_fichier,$libelle_ressource,$datedeb,$datefin,$numero_espace,$numero_section,$formation,$module_root,array($target_component => 'gui_fo_ressource.tpl'));
				break;
			case TYPE_FICHIER_SCENARIO:
				$ressource=new guiFoRessourceScenario($num_fichier,$libelle_ressource,$datedeb,$datefin,$numero_espace,$numero_section,$formation,$module_root,array($target_component => 'gui_fo_ressource_scenario.tpl'));
				break;
			case TYPE_FICHIER_SCENARIO_DYNAMIQUE :
				$ressource=new guiFoRessourceScenarioDynamique($num_fichier,$libelle_ressource,$datedeb,$datefin,$numero_espace,$numero_section,$formation,$module_root,array($target_component => 'gui_fo_ressource_scenario_dynamique.tpl'));
				break;
			default:
				die("Erreur guiFoRessourceFactory: Le type '$type' n'a d'objet associ�.");	
		}
		
		return $ressource;	
	}
}
?>