<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche la ressource scenario.
 * 
 * @package ressource
 */
class guiFoRessourceScenario extends PageComponent{
	/**
	 * Affichage de ressource scenario
	 * 
	 * @param  integer $num_fichier L'identifiant du fichier
	 * @param  string $libelle_ressource Le libelle de la ressource
	 * @param  string $datedeb La date de debut de la ressource 
	 * @param  string $datefin La date de fin de la ressource 
	 * @param  integer $num_ressource L'identifiant de la ressource
	 * @param  integer $numero_espace L'identifiant de l'espace
	 * @param  integer $numero_section L'identifiant de la section
	 * @param  integer $formation L'identifiant de la formation
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoRessourceScenario($num_fichier,$libelle_ressource,$datedeb,$datefin,$numero_espace,$numero_section,$formation,$module_root=null,$templates=null){
		
		global $chemin_fo;	
		
		parent::PageComponent($module_root,$templates);
			
			$fichier_theme = get_categorie_element_themes(TYPE_CATEGORIE_RESSOURCE_SCENARIO, $num_fichier) ;
			$row = pg_fetch_row($fichier_theme);
			$num_theme = $row[0];
			
			$chemin_fichier=get_fichier_chemin_relatif($num_fichier,$num_theme,TYPE_CATEGORIE_RESSOURCE_SCENARIO);
			$resfic=get_fichier($num_fichier);
			$nomfic=pg_fetch_result($resfic,0,1);
			$extension = $nomfic;
			$extension = substr($nomfic, $pos, strlen($nomfic));
			
			$res_ressource = pg_fetch_result(get_formation_ressource_nouveaute($formation, $numero_espace, $numero_section,$num_fichier),0) ;
			
			if(sql2Bool($res_ressource)){
				$val['RESSOURCE_NEW']="_new";
			}else{
				$val['RESSOURCE_NEW']="";
			}
			
			$val['LIEN_URL']= "$path./..$chemin_fichier";
			$val['RESSOURCE_ID']= $num_fichier;
			$val['LIBELLE_RESSOURCE']=get_fo_libelle($libelle_ressource);
			if($datedeb && $datefin){
				$dtdeb=explode("-",$datedeb);
				$dtfin=explode("-",$datefin);
				$val['RESSOURCE_DESCRIPTION']=" ($extension - " . sprintf("%01.2f", (filesize($chemin_fo.$chemin_fichier) / 1024)) . " Ko-  ".MSG_2539."  ".formater_date($dtdeb,$s_langue)." ".MSG_2540." ".formater_date($dtfin,$s_langue);
			}
			else
				$val['RESSOURCE_DESCRIPTION']=" ($extension - " . sprintf("%01.2f", (filesize($chemin_fo.$chemin_fichier) / 1024)) . " Ko)";
		
		 
			parent::set_var($val);
	}
}
?>