<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cr�ation d' un Espace et ses ressources
 * 
 * @package ressource
 */
class guiFoRessources extends PageComponent{
	/**
	 * Construit l'emsemble des objets necessaire � l'affichage des ressources
	 * 
	 * @param string $block_target Le nom de la variable qui contiendra la boucle dans le tpl.
	 * @param object[] $guiFoRessourceFactory C'est l'objet qui permet de creer une ressource selon un type pr�d�fini.
	 * @param integer $espace L'identifiant de l'espace
	 * @param integer $section L'identifiant de la section
	 * @param integer $ressource L'identifiant de la ressource 
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoRessources($block_target,$guiFoRessourceFactory,$espace, $section,$ressource_fusion,$module_root=null,$templates=null){
		
		global $chemin_fo,$obj_DoFormation,$sess;	
		parent::PageComponent($module_root,$templates);
		
		$formation=$obj_DoFormation->getFormation();
		$individu=$obj_DoFormation->getIndividu();
		// test si fusion ressources
		//TODO est-ce manquant ou inutile?
// 		$res_formation=get_formation($formation);
// 		$fusion_ressource=pg_fetch_result($res_formation,0,6);
 		
		if(!empty($section)){
			$obj_section=new Section($section);

			// l'image
			$gui_fo_sections_image =new guiFoSectionsImage($obj_section->getIcone(),$obj_section->getLibelle(),"$chemin_fo/ressource/templates/tpl",array('infos_sections'=>'gui_fo_sections_image.tpl'));
			$this->setComponent('infos_sections', $gui_fo_sections_image);
	 		
			if($ressource_fusion)
				$resressource=get_formation_espace_section_all_ressources_individu($formation, $espace, $section,$individu) ;
			else
				$resressource=get_formation_espace_section_ressources($formation, $espace, $section) ;
				
			$nbressource=pg_num_rows($resressource);

			//on boucle sur les ressources de la section	
			$this->set_block($block_target,'block','bloc_ressource');
			for($i=0;$i<$nbressource;$i++){
				$row=pg_fetch_row($resressource,$i);

				//Creation de la ressource 		
				$ressource= $guiFoRessourceFactory->createguiFoRessource('block_line',"$chemin_fo/ressource/templates/tpl",$row[8],$row[1],$row[6],$row[10],$row[11],$row[2],$row[4],$formation);
				$this->setComponent('block_line', $ressource,true,'block','bloc_ressource');
			}
		}
		
		//Creation de l'objet guiFoEspace contenant le libelle espace
		$gui_fo_espace = new guiFoEspace(new Espace($espace),$module_root,array('titre_espace'=>'gui_fo_espace.tpl'));
		$this->setComponent('titre_espace',$gui_fo_espace);	
			
	}
}
?>