<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class guiFoRessourcesGlossaire extends PageComponent{
	
	/**
	 * Construit l'emsemble des objets necessaire a l'affichage des ressources d'un glossaire ( définitions )
	 * 
	 * @param string $block_target Le nom de la variable qui contiendra la boucle dans le tpl.
	 * @param object[] $guiFoRessourceFactory C'est l'objet qui permet de creer une ressource selon un type pr�d�fini.
	 * @param integer $espace L'identifiant de l'espace
	 * @param integer $section L'identifiant de la section
	 * @param integer $ressource L'identifiant de la ressource 
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoRessourcesGlossaire($block_target,$espace, $section_key, $glossaire,$module_root=null,$templates=null){
		global $chemin_fo,$obj_DoFormation,$sess;	
		parent::PageComponent($module_root,$templates);
		
		$glossaire= new FichierGlossaire($glossaire);
		
		//Creation de l'objet guiFoEspace contenant le libelle espace
		$gui_fo_espace = new guiFoEspace(new Espace($espace),$module_root,array('titre_espace'=>'gui_fo_espace.tpl'));
		$this->setComponent('titre_espace',$gui_fo_espace);	
		
		//affichage section
		$val ['TITRE_SECTION'] =$section_key;
			
		
		$tab_words=$glossaire->getWords();
		$words=$tab_words[$section_key];
 		$nb_words=count($words);
 		
		//on boucle sur les mots du glossaire	
		$this->set_block($block_target,'block','bloc_ressource');
		for($i=0;$i<$nb_words;$i++){
			$word=$words[$i];

			//Creation de la ressource 	
			$ressource= new guiFoGlossaireRessource($word[0],get_fo_libelle($word[1]),null,null,$espace,$section_key,$obj_DoFormation->getFormation(),"$chemin_fo/ressource/templates/tpl",array('block_line' => 'gui_fo_glossaire_ressource.tpl'));
			$this->setComponent('block_line', $ressource,true,'block','bloc_ressource');
		}
		$this->set_var($val);	
	}
}
?>