<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche l'icone, le libelle du lien, la definition du nombre de ressource et de ressource nouvelle.
 * 
 * @package ressource
 */
 class guiFoSection extends PageComponent{
 	/**
 	 * Affichage de l'ensemble visuelle d' une section
 	 * 
 	 * @param string $lien_url_ressource Le lien qui va permettre une redirection pour l'affichage des ressources.
 	 * @param integer $section_num_espace L'identifiant de l'espace
 	 * @param integer $section_num L'identifiant de la section
 	 * @param string $section_titre Le libelle lien de la section
 	 * @param integer $formation L'identifiant de la formation
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoSection($obj_DoEtape,$section_num_espace,$section_num,$section_titre,$formation,$tab_ressources,$module_root=null,$templates=null){
		global $chemin_fo,$serverfront;
		global $s_langue;
		parent::PageComponent($module_root,$templates);
		
		$path= "..";
		//affiche que le libell� section
		$res_section=get_section($section_num);
		$row_section=pg_fetch_row($res_section);
		
		// test si fusion ressources
 		$res_formation=get_formation($formation);
 		$fusion_ressource=pg_fetch_result($res_formation,0,6);
		
		//On recupere le nombre de ressource 
		$res_ressource = get_formation_espace_section_ressources($formation, $section_num_espace, $section_num) ;
		$nb_ressource = pg_num_rows($res_ressource);
		
		//Initialisation du nombre de nouvelle ressource en front
		$nb_new_ressource = "0";

		//initialisation de $i pour la boucle
		$i=0;
		// on boucle sur le tableau $tab_ressource et on filtre avec l'espace et la section
		// Note : les ressources sans date (debut et fin) ni nouveaute proviennent d'etape ressource
		$nb_ressources=sizeof($tab_ressources);
		$nb_section_ressources=0;
		$nb_new_ressource = "0";
		$ressource_etape=0;
		for($i=0;$i<$nb_ressources;$i++){
			if($tab_ressources[$i][2]==$section_num_espace && $tab_ressources[$i][4]==$section_num){
				$nb_section_ressources ++;
				if($tab_ressources[$i][10] && $tab_ressources[$i][11] && $tab_ressources[$i][12]){
					// teste la nouveaut� a suivre...
					$nb_new_ressource ++;		
				}
				else{
					$nb_new_ressource=1;
					$ressource_etape=1;
				}
			}
		}
		
		$lien_url="../ressource/section_ressources.php?espace=$section_num_espace&section=$section_num&ressource_etape=$ressource_etape&sz_obj_doetape=".exportObject($obj_DoEtape);
		
		if(!empty($row_section[2])){
			//print_rr($row_section);
			$chemin_fichier_relatif=get_fo_fichier_icone_chemin_relatif($row_section[2]);
			if(!empty($chemin_fichier_relatif)){
				$chemin_fichier_absolu=$chemin_fo."/".$chemin_fichier_relatif;
				$val ['SECTION_IMG'] ="<img src=\"$path$chemin_fichier_relatif\">";
			}
			else
				$val ['SECTION_IMG'] ="<img src=\"http://$serverfront/fo/".UPLOAD_RESSOURCE_ICONE_DIR."default.gif\">";
			
		}
		else{
			$val ['SECTION_IMG'] ="<img src=\"http://$serverfront/fo/".UPLOAD_RESSOURCE_ICONE_DIR."default.gif\">";
		}
		$val ['LIEN_URL'] = $lien_url;
		$val ['SECTION_LIBELLE'] =get_fo_libelle($section_titre);
		$val ['SECTION_TEXTE']=$nb_section_ressources." ".MSG_2541." ".$nb_new_ressource." ".MSG_2542;		
		parent::set_var($val);	
	}
 }
?>