<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche l'icone, le libelle du lien, la definition du nombre de ressource et de ressource nouvelle.
 * 
 * @package ressource
 */
 class guiFoSectionGlossaire extends PageComponent{
 	/**
 	 * Affichage de l'ensemble visuelle d' une section
 	 * 
 	 * @param string $lien_url_ressource Le lien qui va permettre une redirection pour l'affichage des ressources.
 	 * @param integer $section_num_espace L'identifiant de l'espace
 	 * @param integer $section_num L'identifiant de la section
 	 * @param string $section_titre Le libelle lien de la section
 	 * @param integer $formation L'identifiant de la formation
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoSectionGlossaire($obj_DoEtape,$espace_id,$section_key,$glossaire, $module_root,$templates){
		global $chemin_fo,$serverfront;
		parent::PageComponent($module_root,$templates);
		
		$tab_words=$glossaire->getWords();
		$section_nb_words=count($tab_words[$section_key]);
		if(!empty($section_key)){
			$val ['SECTION_IMG'] ="<h1 id=\"titre_section_glossaire\">$section_key</h1>";
			$val ['SECTION_LIBELLE'] =$section_key;
			$val ['LIEN_URL'] = "../ressource/espace_glossaire.php?espace=$espace_id&glossaire=".$glossaire->getId()."&section=$section_key&sz_obj_doetape=".exportObject($obj_DoEtape);
		}
		else{
			$val ['SECTION_IMG'] ="<img src=\"http://$serverfront/fo/".UPLOAD_RESSOURCE_ICONE_DIR."default.gif\"";
			$val ['SECTION_LIBELLE'] ="Glossaire vide";
			$val ['LIEN_URL'] = "#";
		}
		$val ['SECTION_TEXTE']="Glossaire: ".get_fo_libelle($glossaire_libelle)." ($section_nb_words mot(s))";		
		$this->set_var($val);	
	}
 }
?>