 <?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche l'icone correspondant � la section ainsi que le libelle de la section.
 * 
 * @package ressource
 */ 
 class guiFoSectionsImage extends PageComponent{
 	/**
 	 * Affichage de l'icone et du libelle de la section
 	 * 
 	 * @param integer $numero_icone L'identifiant de l'icone
 	 * @param string $libelle_section Le libelle de la section
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoSectionsImage($numero_icone,$libelle_section,$module_root=null, $templates=null){
 		global $serverfront;
 		parent::PageComponent($module_root, $templates);
 		
 		$path= "..";
 		if(empty($numero_icone)){
 			$val ['IMG_SECTION'] ="<img src=\"http://$serverfront/fo/".UPLOAD_RESSOURCE_ICONE_DIR."/default.gif\">";	
 		}
 		else{
 			$chemin_fichier=get_fo_fichier_icone_chemin_relatif($numero_icone);
 			$val['IMG_SECTION']="<img src=\"$path$chemin_fichier\">";	
 		}
 		
		$val['LIBELLE_SECTION']=get_fo_libelle($libelle_section);
 		parent::set_var($val);
 	}
 }
?>