<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affichage scenario avec ses fleches de navigations.
 * 
 * @package scenario
 */
class guiFoScenario extends PageComponent{
	/**
	 * @var object[] $debut Objet graphique qui contient l'affichage des fleches de navigations de scenario.
	 */
	var $debut;
	/**
	 * @var object[] $contenu Objet graphique qui contient l'affichage du scenario.
	 */
	var $contenu;
	/**
	 * @var object[] $fin Objet graphique qui contient l'affichage des fleches de navigations de scenario.
	 */
	var $fin;
	
	var $obj_etape;
	/**
	 * Constructeur
	 * 
	 * @param boolean $force_no_end Force  ne pas finir l'tape.
	 * @param boolean $obligatoire Oblige  reussir l'etape pour passer  l'tape suivante.
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.
	 * @param stri$obj_etape= $obj_DoEtape->getObjEtape();ng $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoScenario($force_no_end,$obligatoire,$obj_DoFormation,$obj_DoEtape, $module_root=null,$templates=null){
		global $chemin_fo;	
		parent::PageComponent($module_root,$templates);
		//print_rr($obj_DoEtape);
		$this->debut=new NavigateurEtapes($force_no_end,$obligatoire,$obj_DoEtape,$obj_DoFormation,"$chemin_fo/etape/templates/tpl",array('etape_debut' => 'navigateur_etape.tpl'));
		$this->fin=new NavigateurEtapes($force_no_end,$obligatoire,$obj_DoEtape,$obj_DoFormation,"$chemin_fo/etape/templates/tpl",array('etape_fin' => 'navigateur_etape.tpl'));
		
		$this->setComponent('etape_debut', $this->debut);
		$this->setComponent('etape_fin', $this->fin);
		
		$this->obj_etape= $obj_DoEtape->getObjEtape();
		
		$this->initContenu();
		$this->setComponent('etape_contenu', $this->contenu);
	}
	
	function initContenu(){
		global $chemin_fo;	
		$extension_fichier=$this->obj_etape->getFichierExtension();
		switch($extension_fichier){
			case 'html':
			case 'htm':
				$this->contenu=new guiFoScenarioContenu($this->obj_etape, "$chemin_fo/scenario/templates/tpl",array('etape_contenu' => 'gui_fo_scenario_contenu.tpl'));
			break;
			case 'swf':
				$this->contenu=new guiFoScenarioContenuFlash($this->obj_etape, "$chemin_fo/scenario/templates/tpl",array('etape_contenu' => 'gui_fo_scenario_contenu_flash.tpl'));
			break;
			default:
				$this->contenu=new guiFoScenarioContenuNoExtension($this->obj_etape, "$chemin_fo/scenario/templates/tpl",array('etape_contenu' => 'gui_fo_scenario_contenu_no_extension.tpl'));		
		}
	}
}
?>