<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le scenario flash.
 * 
 * @package scenario.
 */
class guiFoScenarioContenuFlash extends PageComponent{
	/**
	 * Affichage du scenario.
	 * 
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une �tape.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoScenarioContenuFlash($obj_etape, $module_root=null,$templates=null){
		parent::PageComponent($module_root,$templates);
		global $s_langue,$serverfront;
		
		$obj_scenario=new Scenario($obj_etape->getId());
		$id_theme=pg_fetch_result(get_categorie_element_themes(TYPE_CATEGORIE_FICHIER_SCENARIO,$obj_scenario->getFichier()),0,0);
		$val['SCENARIO_CONTENU_CONTENU_FLASH']="http://".$serverfront."/fo/data/contenus/$id_theme/".TYPE_CATEGORIE_FICHIER_SCENARIO."/".$s_langue."/".$obj_scenario->getFichierDiskName();
		$this->set_var($val);
	}
}
?>