<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche la presentation d'une srie en fonction de son contenu
 *Diffrents cas possibles :
 * 1) la srie contient des questions de type diffrent (qcm,blanc,glisser-dposer...)
 *      si oui alors $serie_multi=1 et $serie_mono=1
 *  2) la srie ne contient que des question du mme type (qcm ou blanc ou ...)
 *      si oui alors $serie_multi=0 et $serie_mono=1
 * 3) La srie est bloquante
 *      si oui alors $serie_bloquante=1;
 * 4) Cette page est configure pour un affichage dynamique
 *      si oui alors $configuration_affichage=1;
 * 
 * @param $id integer Identifiant de la srie.
 * @package serie
 */
//----------------------------------------------------------------------
// 					INITIALISATIONS
//----------------------------------------------------------------------

$obj_correction_etape=importObject($sz_obj_correction_etape);
//print_rr($obj_correction_etape);
//print_rr($obj_DoFormation);
$NIVEAU_DEBUG=0;
// recup de l'objet Etape
$obj_Etape=$obj_correction_etape->getEtape($obj_DoFormation->obj_DoNodeFactory->obj_NodeFactory);
$etape=$obj_Etape->getId();
// recup type serie

$type_serie=$obj_Etape->getType();
//echo get_class($obj_Etape);

// serie aleatoire ?
//$aleatoire=$obj_Etape->isAleatoire();
//echo "aleatoire=$aleatoire<br>";

//$individu=$obj_Etape->getIndividu();
// recup de l'objet DoEtape
$obj_DoEtape=$obj_CorrectionEtape->getDoEtape();
//$individu=$obj_DoFormation->getIndividu();
$individu=$obj_DoEtape->getIndividu();

// serie bloquante ?
$bloquante=$obj_Etape->isBloquante($formation, $parcours);

// recup du booleen nouvelle_tentative
$tentative=$obj_DoEtape->isNouvelleTentative();

//evaluations de la serie
$res_evaluations=$obj_Etape->getEvaluations();
$nb_evaluations=pg_num_rows($res_evaluations);
//echo "nb eval=$nb_evaluations<br>";

// recup id_resultat
$resres=get_resultat_etape($formation,$individu,$parcours,$etape);
$rowres=pg_fetch_row($resres,0);
$id_resultat=$rowres[0]; 

//notes obtenues aux evaluations
// si serie bloquante et nouvelle_tentative ok
if($bloquante && $tentative==1){
	//echo "bloquante et tentative=$tentative et form=$formation et parc=$parcours et stag=$individu et etape=$etape<br>";
	// recup id_resultat de la derniere tentative
	$res_resultat_tentative=get_resultat_tentative($formation,$individu,$parcours,$etape,0);
	$row_resultat_tentative=pg_fetch_row($res_resultat_tentative,0);
	//print_rr($row_resultat);
	$id_resultat_tentative=$row_resultat_tentative[0];
	//echo "id_resultat=$id_resultat_tentative<br>";
	$res_evaluations_notes=get_resultat_serie_evaluations_scores_tentative($id_resultat_tentative);
	$nb_evaluations_notes=pg_num_rows($res_evaluations);
	//echo "nb=$nb_evaluations_notes<br>";
	// score_total
	$score_total=get_resultat_serie_score_tentative($id_resultat_tentative);
}
else{
	//echo "coucou<br>";
	$res_evaluations_notes=$obj_CorrectionEtape->getEvaluationsScores();
	$nb_evaluations_notes=pg_num_rows($res_evaluations);
	//echo "coucou et nb_evaluation_notes=$nb_evaluations_notes<br>";
	// score_total
	$score_total=$obj_CorrectionEtape->getScoreTotal();
	//echo "score=$score_total<br>";
}


//media
//$media=$obj_CorrectionEtape->getMedia();
//if(!empty($media)){
//	//TODO $obj_media= ne
//}

// Cette page est-elle configure pour un affichage dynamique ?
$configuration_affichage=affichage_dynamique($formation,$id,$tabconfiguration,$num_page);
                                  
//--------------------------------------------------------
// 					Types d'valuation de la srie'
//--------------------------------------------------------

$tabtyp=$obj_Etape->getEvaluationsTypes();

$nb_type_evaluations=pg_num_rows($tabtyp);
if($nb_type_evaluations>1){
    $multi=true;   // designe une srie multi-type
    $mono=false;    // designe une srie mono-type
}
else {
    $multi=false;
    $mono=true;
}
// test si resultat not
$resultat_note=0;
for($i=0;$i<$nb_type_evaluations;$i++){
	$row_typ=pg_fetch_row($tabtyp,$i);
	if($row_typ[0]==1 ||  $row_typ[0]==4   ||  $row_typ[0]==3){
		$resultat_note=1;
		break;
	}
}
//--------------------------------------------------------
// 					Serie bloquante
//--------------------------------------------------------
$resmode_bloquant=$obj_Etape->getBloquageConfiguration($formation, $parcours);
if($resmode_bloquant&&pg_numrows($resmode_bloquant)>0){
	$rowmode_bloquant=pg_fetch_row($resmode_bloquant);
	//print_rr($rowmode_bloquant);
	if(!empty($rowmode_bloquant[0]))$serie_bloquante=true;
	else $serie_bloquante=false;
}
//echo "tentative=$tentative<br>";
if($serie_bloquante ){
	 
	// recup du seuil  et nombre de tentatives
	//$rowmode_bloquant=pg_fetch_row($resmode_bloquant);
	//print_rr($rowmode_bloquant);
	$seuil=$rowmode_bloquant[3];
	$nbtentative=$rowmode_bloquant[5];
	$correction_autorisee=$rowmode_bloquant[6];
	/*
	if($correction_autorisee=='t')
		echo "correction<br>";
	else
		echo "pas de correction<br>";
	*/
	//echo "seuil=$seuil et nbtentative=$nbtentative<br>";
	
	// recup du nombre de resultats deja stock ds la table stockresultserie
//	$resresult=pg_exec($db,"select * from stockresultserie where num_user='$s_numstag' and num_serie='$id_serie' and num_cal='$s_numcal';");
//	$nbresult=pg_numrows($resresult);
	// recup du nombre de tentative deja faite
	if($tentative==1){
		$resessai=get_resultat_etape_tentative($id_resultat_tentative);
		$nb_essai=pg_num_rows($resessai);
		echo "nbtentative=$nbtentative et nb_essai=$nb_essai et id_resultat_tentative=$id_resultat_tentative<br>";
		$nb_essai_restant=$nbtentative - $nb_essai;
	}
	else
		$nb_essai_restant=0;
}

//--------------------------------------------------------
// 			Serie gnre par un positionnement 
//--------------------------------------------------------
// recup du n de test correspondant  la serie
if($aleatoire==1 && $mode_aleatoire==3){
    // recup de la liste (1 liste par parcours !!!)
    $sql="select num_c_q_e_d from gestparcours where g_num_parcours=$s_numparc and type_etape='L'";
    $resliste=pg_query($sql);
    $rowliste=pg_fetch_row($resliste,0);
    $num_liste=$rowliste[0];
    // debug
    //echo "num_liste=$num_liste<br>";
    $num_test=numero_test($id,$s_numparc,$num_liste);
    //echo "num_test=$num_test<br>";
    $obj_test=new Test($num_test);
    $obj_media=&$obj_test->getMedia();
}

//----------------------------------------------------------------------
// 							AFFICHAGE
//---------------------------------------------------------------------- 

// AFFICHAGE DU NOMBRE D'EVALUATIONS
print("
<table class=\"tableau_contenu\">
<tr>
<td class=\"barre_contenu_avant_serie\" colspan=6>
<table class=\"tableau_contenu_avant_serie\">
");

print("
<tr>
<td class=\"barre_titre_serie_avant_correction\" colspan=\"6\">
");
switch($configuration_affichage){
	case 0:
		print("
		<span class=\"texte_serie_avant_correction\">
		$MSG_1267 : 
		<span class=\"texte_titre_nom_serie_avant_correction\">".$obj_Etape->getLibelle()."</span>
		&nbsp;&nbsp;$MSG_650 : ".sql_timestamp_to_string($obj_CorrectionEtape->getDebut())."
		</span>
		");
    break;
    case 1: // test si on a choisi d'afficher le titre a suivre ..
		// test si on a choisi d'afficher le titre
        if(in_array(1,$tabconfiguration)){
			// //recup du titre dans la table titrepage
            print("
			<span class=\"texte_serie_avant_correction\">
			&nbsp;TITRE CONFIG PAGE
			</span>
			");
		}
        else{
			print("
		    <span class=\"texte_serie_avant_correction\">
		    $MSG_1267 : 
			<span class=\"texte_titre_nom_serie_avant_correction\">$nom_serie</span>
			&nbsp;&nbsp;$MSG_650 : ".$obj_CorrectionEtape->getDebut()." ($heure_serie)
			</span>
			");
		}
    break;
}

print("
</td>
</tr>
");

//DETAIL DES RESULTATS				
print("
<tr class=\"barre_detail_serie_avant_correction\">
<td class=\"texte_titre_detail_serie_avant_resultat\">
$MSG_2260:
");

print("
</td>
</tr>
");
				
if($configuration_affichage==0 || in_array(3,$tabconfiguration)){
	print("
	<tr>
	<td class=\"barre_detail_serie_avant_correction\">
	<span class=\"texte_detail_serie_avant_correction\">
	");

if($configuration_affichage==0){
    if($aleatoire==1 && $nb_type_evaluations==0){
        print("
		<img src=\"../images/insertion.gif\" class=\"img_insert_avant_serie\" />&nbsp; toto$msg
		");
    }
    else
        print("
		<img src=\"../images/insertion.gif\" class=\"img_insert_avant_serie\" />&nbsp; $MSG_625a : $nb_evaluations
		");
}

// AFFICHAGE DETAIL SERIE BLOQUANTE
if($serie_bloquante==true){
	print("
	<br/>
	<img src=\"../images/insertion.gif\" class=\"img_insert_avant_serie\" />&nbsp; $MSG_1481 $seuil/20
	<img src=\"../images/insertion.gif\" class=\"img_insert_avant_serie\" />&nbsp; $MSG_1482 $nb_essai_restant/$nbtentative ");
}

print("
&nbsp;<br/>
</span>
</td>
</tr>");
}

//CHRONO
if($configuration_affichage==0 || $configuration_affichage==1){
print("
				<tr>
					<td class=\"barre_temps_detail_serie_avant_correction\">
						<img src=\"../data/images/insertion.gif\" class=\"img_insert_serie_avant_correction\" />
						<span class=\"texte_detail_serie_avant_correction\">");
	if($obj_Etape->getChronoTotal()==-1){
		print("
							&nbsp;$MSG_1386");
	}
	elseif($obj_Etape->getChronoTotal()>-1){
		
        	print("
							&nbsp;$MSG_850 : ".($obj_Etape->getChronoTotalFormate())."  <i>($MSG_1388)</i><br/>");
		        
	}else{
            print("
							&nbsp;$MSG_850 : ".($obj_Etape->getChronoTotalFormate())."  <i>($MSG_1387)</i><br/>");
    }
    print("
						</span>
					</td>
				</tr>");
}

//DUREE
if($configuration_affichage==0 || in_array(6,$tabconfiguration)){
	print("
				<tr>
					<td class=\"barre_temps_detail_serie_avant_correction\">
						<img src=\"../data/images/insertion.gif\" class=\"img_insert_serie_avant_correction\" />
						<span class=\"texte_detail_serie_avant_correction\">
							&nbsp;$MSG_1131 : ".$obj_CorrectionEtape->getDureeFormate()."
						</span>
					</td>
				</tr>");
}

//DETAIL DES RESULTATS				
print("
				<tr class=\"barre_detail_serie_avant_correction\">
					<td class=\"texte_titre_detail_serie_avant_resultat\">
						$MSG_1130:");

print("
					</td>
				</tr>");

//RESULTATS PAR EXERCICES
if($configuration_affichage==0 || in_array(3,$tabconfiguration) || in_array(4,$tabconfiguration) || in_array(6,$tabconfiguration) || in_array(7,$tabconfiguration)){
echo "ici<br>";
if($tentative!=1){	 
	print("
				<tr class=\"barre_detail_serie_avant_correction\">
					<td class=\"texte_detail_serie_avant_correction\">");
	$cpt=1;	
    while($row=pg_fetch_row($res_evaluations_notes)){
		//print_rr($row);
        switch($row[3]){
		
            case TYPE_EVALUATION_SONDAGE :
            case TYPE_EVALUATION_SRC:
        		//libelle de type d'tape 
				$var='$etape_type_libelle_original='.pg_fetch_result(get_evaluation_type($row[3]),0,1).';';
				eval($var);
                print(" &nbsp;&nbsp;$MSG_603 $cpt: $etape_type_libelle_original <i>- $MSG_2259 -</i><br/>");
            break;
            case TYPE_EVALUATION_FTB :
            case TYPE_EVALUATION_QCM :
            case TYPE_EVALUATION_QRC : 
                print("&nbsp;&nbsp;$MSG_603 $cpt : $row[8] / $row[7]<br/>");
                $totalmaxi+=$row[7];
        		$totalscore+=$row[8];
            break;
        }
		$cpt++;
     }
      print("
					</td>
				</tr>");
}
}

//SCORE TOTAL
// test si resultat not
if($resultat_note)
if($configuration_affichage==0 || in_array(7,$tabconfiguration)){

// score_total

print ("
<tr>
<td class=\"barre_score_detail_serie_avant_correction\">
						<img src=\"../data/images/insertion.gif\" class=\"img_insert_serie_avant_correction\" />
						<span class=\"texte_detail_serie_avant_correction\">
							&nbsp;$MSG_1134 : $score_total / 20 <!--( $totalscore / $totalmaxi )-->
						</span>
					</td>
				</tr>");
}

//APPRECIATION
if($configuration_affichage==0 || in_array(9,$tabconfiguration)){
	$msg_com="appreciation toto";//appreciation();
	print("
				<tr>
					<td class=\"barre_appreciation_serie_avant_correction\" colspan=\"2\">
						<span class=\"texte_detail_serie_avant_correction\">
							$MSG_1079  <br/>$msg_com 
						</span>
					</td>
				</tr>");
}

//COMMENTAIRE
if(in_array(8,$tabconfiguration)){
     print("
				<tr>
				    <td class=\"barre_commentaire_serie_avant_correction\">
					    <img src=\"../data/images/insertion.gif\" class=\"img_insert_serie_avant_correction\" />
					    <span class=\"texte_detail_serie_avant_correction\">
					    	&nbsp;$MSG_157  : commentaire toto
						</span>
				    </td>
				</tr>");
}




print("
		</table>
	</td>
</tr>");

//--------------------------------------------------------
// 			affichage du bouton demarrer
//--------------------------------------------------------	
//echo "tentative=$tentative et cor=$correction_autorisee<br>";
if($correction_autorisee=='t' || $tentative!=1){					
	include("../liste/templates/obj/corrige_liste.php");
}
else{
	include("../liste/templates/obj/retour_liste.php");
}


///*----------------------------------------------------------------------------------------*/
////Affichage bouton correction  ?
///*----------------------------------------------------------------------------------------*/
//if(rechSondage($id_serie)==0)
//    $image_bouton="correction.gif";
//else
//    $image_bouton="resulats.gif";
//if($configuration_affichage==0 || in_array(10,$tabconfiguration)){
//    if($correction!='f')
//    if($nbex>0)
//    print("
//    <tr>
//    <td class=\"barre_choix_serie_avant_correction\" colspan=\"2\">
//    <br/>
//    <a href=\"corr_serie_test.php?id_serie=$id_serie\"><img src=\"../data/images/$image_bouton\" class=\"bouton_choix_serie_avant_correction\" /></a><br/>
//    <span class=\"texte_choix_serie_avant_correction\">$MOT_2<BR/>
//    $MSG_1128 </span><a href=\"../parcours.php3\"><span class=\"lien_choix_serie_avant_correction\">$MSG_1136</span></a><BR/>
//    <BR/>
//    </td>
//    </tr>
//
//    ");
//}
///*------------------------------------------------------------------------------------------------------------------*/
////  Fin du tableau
///*------------------------------------------------------------------------------------------------------------------*/
//print("
//</td>
//</tr>
//</table>
//
//");
//print("
//<tr>
//<td>
//<table class=\"tableau_basdepage_serie_avant_correction\">
//<tr>
//    <td class=\"coin_serie_avant_correction_basgauche\" ></td>
//    <td class=\"coin_serie_avant_correction_basdroite\" ></td>
//  </tr>
//</table>
//</td>
//</tr>
//");

?>