<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*------------------------------------------------------------------------------------------------*/
//  Fonctions pour l'excution d'une srie
/*------------------------------------------------------------------------------------------------*/
$typeexo["f"]='Remplir les blancs';
$start_balise='[:';
$end_balise=':]';

function ini_chrono($nb_sec){
    $tab=get_hms($nb_sec);
    return(add_zero($tab["heure"]).':'.add_zero($tab["minute"]).':'.add_zero($tab["seconde"]));
}
function ini_chrono_to_char($nb_sec){
    $tab=get_hms($nb_sec);
    if($tab["heure"]!=0){
        $msg_date=add_zero($tab["heure"])." heure(s)";
    }
    if($tab["minute"]!=0){
        $msg_date.=" ".add_zero($tab["minute"])." minute(s)";
    }
    if($tab["seconde"]!=0){
        $msg_date.=" ".add_zero($tab["seconde"])." seconde(s)";
    }
    return($msg_date);
}
function add_zero($entier){
    if($entier<10)
        return('0'.$entier);
    else
        return($entier);
}

//function set_serie_session($id_serie){
//    global $s_numstag,$s_numcal,$s_numuser;
////initialise les variables d'environnement necessaire  la srie
//    $sql="SELECT chrono,titre,bareme FROM serie_exo WHERE id=$id_serie";
//    $result=pg_query($sql);
//    $name='titre_'.$id_serie;
//    $_SESSION[$name]=pg_result($result,0,'titre');
//    $name='bareme_'.$id_serie;
//    $_SESSION[$name]=pg_result($result,0,'bareme');
//    $name='chrono_'.$id_serie;
//    if(pg_result($result,0,'chrono')>0)
//        $_SESSION[$name]=1;
//    else{
//        if((pg_result($result,0,'chrono')<-1) || (pg_result($result,0,'chrono')==0))
//             $_SESSION[$name]=0;
//        else
//            $_SESSION[$name]=pg_result($result,0,'chrono');
//    }
//    // prise en compte de l'alatoire
//    $aleatoire=test_serie_aleatoire($id_serie,$mode_aleatoire);
//    if($aleatoire==1 && $mode_aleatoire>0)
//        $sql="SELECT count(*) FROM asso_exo_serie_aleatoire WHERE id_serie='$id_serie' and num_user=$s_numstag and num_cal=$s_numcal";
//    else
//        $sql="SELECT count(*) FROM asso_exo_serie WHERE id_serie='$id_serie'";
//    $result=pg_query($sql);
//    $name='nb_etape_'.$id_serie;
//    $_SESSION[$name]=pg_result($result,0);
//}

function corrige($id_serie,$ordre_exo,$reponse){
    global $s_numstag,$s_numcal,$s_numuser;
     $aleatoire=test_serie_aleatoire($id_serie,$mode_aleatoire);
    // on rcupre le barme
    if($aleatoire==1)
         $sql="SELECT bareme,point FROM asso_exo_serie_aleatoire WHERE id_serie=$id_serie AND ordre=$ordre_exo and num_user=$s_numstag and num_cal=$s_numcal";
    else
        $sql="SELECT bareme,point FROM asso_exo_serie WHERE id_serie=$id_serie AND ordre=$ordre_exo";
    $result=pg_query($sql);
    $point=pg_result($result,0,'point');
    if($_SESSION["bareme_".$id_serie]==0){
        $id_bareme=pg_result($result,0,'bareme');
    }
    else{
        $id_bareme=$_SESSION["bareme_".$id_serie];
    }
    $sql="SELECT * FROM bareme WHERE num_bareme=$id_bareme";
    $result=pg_query($sql);
    $bon=pg_result($result,0,'repok');
    $faux=pg_result($result,0,'repnotok');
    $abs=pg_result($result,0,'pascoche');
    if($aleatoire==1)
         $sql="SELECT text FROM asso_exo_serie_aleatoire A, gest_ftb G WHERE A.id_exo=G.id AND id_serie=$id_serie AND ordre=$ordre_exo
                    and num_user=$s_numuser and num_cal=$s_numcal";
    else
        $sql="SELECT text FROM asso_exo_serie A, gest_ftb G WHERE A.id_exo=G.id AND id_serie=$id_serie AND ordre=$ordre_exo";
    $result=pg_query($sql);
    $score=0;
//TODO
    $tabmot=getBlanks(pg_result($result,0));
    //print_r($tabmots);
    for($i=0;$i<count($tabmot);$i++){
         $j=count($tabmot) - $i -1;
         // traitement liste de selection
         $tab=explode("~",$tabmot[$j]);
         if(sizeof($tab)>1)
            $mot=$tab[0];
         else
            $mot=$tabmot[$j];
        if($mot==$reponse[$i]){
            $score+=$bon;
        }
        elseif($reponse[$i]==''){
            $score-=$abs;
        }
        else{
            $score-=$faux;
        }
    }
    $tab[0]=$score;
    if($score<0)
        $tab[1]=0;
    else{
        @$tab[1]=($score/($bon*count($tabmot)))*$point;
        //$tab[1]=(round($tab[1]*2)/2);
    }
    return($tab);
}

function corrige_qcm($HTTP_POST_VARS, $id_serie, $id_ordre,$nbrows,&$stock_resul){
    global $s_numstag,$s_numcal;
    $aleatoire=test_serie_aleatoire($id_serie,$mode_aleatoire);
    //rcuperation du bareme
    if($aleatoire==1)
         $sql="SELECT bareme, point FROM asso_exo_serie_aleatoire WHERE id_serie=$id_serie AND ordre=$id_ordre and num_user=$s_numstag and num_cal=$s_numcal";
    else
        $sql="SELECT bareme, point FROM asso_exo_serie WHERE id_serie=$id_serie AND ordre=$id_ordre";
    $result=pg_query($sql);
    $point=pg_result($result,0,'point');
    if($_SESSION["bareme_".$id_serie]==0){
        $id_bareme=pg_result($result,0,'bareme');
    }
    else {
        $id_bareme=$_SESSION["bareme_".$id_serie];
    }
    $sql="SELECT * FROM bareme WHERE num_bareme=$id_bareme";
    $result=pg_query($sql);
    $bon=pg_result($result,0,'repok');
    $faux=pg_result($result,0,'repnotok');
    reset($HTTP_POST_VARS);
    //on parcours le tableau du formulaire
    $tout=0;
    $rien=0;
    $score=0;
    for($i=0;$i<$nbrows;$i++){
        $a=each($HTTP_POST_VARS);
        if($a[1]==t){
            $a=each($HTTP_POST_VARS);
            if(substr("$a[1]",0,3)==on){
                $stock_resul[$i]=1;        //indique OK
                $tout=$tout++;
                $score+=$bon;
            }
            else {
                $a=prev($HTTP_POST_VARS);
                $stock_resul[$i]=0;    //indique PAS COCHE
                $rien=$rien++;
            }
        }
        else{
            $a=each($HTTP_POST_VARS);
            if(substr("$a[1]",0,3)==on){
                $stock_resul[$i]=2;       //ERREUR
                $tout=$tout++;
                $score-=$faux;
            }
            else {
                $a=prev($HTTP_POST_VARS);
                $stock_resul[$i]=0;    //PAS COCHE
                $rien=$rien++;
            }
        }
    }
    if($tout==$nbrows || $rien==$nbrows)
        $score=0;
    if($aleatoire==1 && $mode_aleatoire>0)
         $req="SELECT * FROM   quest_rep,asso_exo_serie_aleatoire a WHERE id_serie=$id_serie AND  a.ordre=$id_ordre AND id_exo=qr_num_question AND juste='t' and num_user=$s_numstag and num_cal=$s_numcal";
    else
        $req="SELECT * FROM   quest_rep,asso_exo_serie a WHERE id_serie=$id_serie AND  a.ordre=$id_ordre AND id_exo=qr_num_question AND juste='t'";
    $result=pg_query($req);
    $nbok=pg_numrows($result);
    if($score<0)
        $score=0;
    else
        $score=(($score/($bon))*$point)/$nbok;
    return $score;
}

// fonction de correction d'un qrc (qcm  reponses communes)
function corrige_qrc($_POST,$id_serie,$id_ordre,$point,$reponse){
    global $obj_test;

    // N du test et nombre d'exo pour ce test
    $id_test=$obj_test->getId();
    $nb_exo=$obj_test->getNbExercices();

    // Le barme
    if($_SESSION["bareme_".$id_serie]==0){
        $sql="SELECT * FROM asso_exo_serie WHERE id_serie=$id_serie AND ordre=$id_ordre";
        $resb=pg_query($sql);
        $id_bareme=pg_result($resb,0,'bareme');
        //$id_bareme=$obj_test->getNumBareme();
    }
    else
        $id_bareme=$_SESSION["bareme_".$id_serie];
    $sql="select * from bareme where num_bareme=$id_bareme";
    // DEBUG
    //echo "id_bareme=$id_bareme<br>";
    $res=pg_query($sql);
    $bon=pg_result($res,0,'repok');
    $faux=pg_result($res,0,'repnotok');
    $abs=pg_result($res,0,'pascoche');

    // Initialisation
    $score=0;
    $reponse="";

    reset($_POST);
    list($qst,$rep)=each($_POST);

    for($i=0;$i<$nb_exo;$i++){
        //debug
        //echo "score=$score<br>";
        $obj_question=&$obj_test->getExercice($i);
        $exo=$obj_question->getId();
        if($exo==$qst){
            $sql="select juste from quest_rep where qr_num_question=$qst and qr_num_rep=$rep";
            $res=pg_query($sql);
            $row=pg_fetch_row($res,0);
            if($row[0]=='t'){
                $scoreq=1;
                $score +=$bon;
            }
            else{
                $scoreq=0;
                $score -=$faux;
            }
            $reponse .="$exo/$rep/$scoreq"; //scoreq pour faciliter la correction
            // on passe au suivant dans $_POST
            list($qst,$rep)=each($_POST);
        }
        else{
            // pas de reponse (pas coche)
            $score -=$abs;
            $reponse .="$exo/0/0";
        }
        if($i<$nb_exo -1)
            $reponse .=";";
    }
    if($score<0)
        $score=0;
    else
        $score=($score/($bon*$nb_exo))*$point;
    return $score;

}

/*
        STOCKAGE DES RESULTATS POUR QRC ET SRC
*/
function stockage_resultat($_POST,$id_serie,$id_ordre){
    global $obj_test;
    global $s_numstag,$s_numcal;

    function corrige_question_qrc(&$_POST,$point,$bon,$faux,$abs,$nb_reponse,$reponse){
        $nbok=0;
        $tout=0;
        $rien=0;
        $score=0;

        for($i=0;$i<$nb_reponse;$i++){
            $a=each($_POST);
            // debug
            //echo "i=$i et a[0]=$a[0] et a(1]=$a[1]<br>";
            if($a[1]==t){
                $nbok++;
                $a=each($_POST);
                if(substr("$a[1]",0,3)==on){
                    $reponse .="1";
                    $tout++;
                    $score +=$bon;
                }
                else {
                    $a=prev($_POST);
                    $reponse .="0";
                    $rien++;
                }
            }
            else {
                $a=each($_POST);
                if(substr("$a[1]",0,3)==on){
                    $reponse .="2";
                    $tout++;
                    $score -=$faux;
                }
                else {
                    $a=prev($_POST);
                    $reponse .="0";
                    $rien++;
                }
            }
        }
        if($tout==$nb_reponse || $rien==$nb_reponse)
            $score=0;
        if($score<0)
            $score=0;
        else
            $score=(($score/($bon))*$point)/$nbok;
        return $score;
    }

    //  INITIALISATION

    // Les paramtres de l'exo de la serie
    $sql="select bareme,point from asso_exo_serie where id_serie=$id_serie and ordre=$id_ordre";
    $result=pg_query($sql);
    $point=pg_result($result,0,'point');
    if($_SESSION["bareme_".$id_serie]==0)
        $id_bareme=pg_result($result,0,'bareme');
    else
        $id_bareme=$_SESSION["bareme_".$id_serie];
    $sql="select * from bareme where num_bareme=$id_bareme";
    $result=pg_query($sql);
    $bon=pg_result($result,0,'repok');
    $faux=pg_result($result,0,'repnotok');
    $abs=pg_result($result,0,'pascoche');

    // Les paramtres du QRC ou SRC
    $id_test=$obj_test->getID();
    $nb_question=$obj_test->getNbExercices();
    $nb_reponse=$obj_test->getNbReponses();
    $type=$obj_test->getType();
    $type_bouton=$obj_test->getType_reponse();
    if($type_bouton=='c')
        $checkbox=1;
    else
        $checkbox=0;

    // Score et reponse
    //if($type=='m'){
        $score=0;
        $reponse="";
        reset($_POST);
        // BOUCLE SUR LES QUESTIONS

            for($q=0;$q<$nb_question;$q++){
                $score +=corrige_question_qrc($_POST,$point,$bon,$faux,$abs,$nb_reponse,&$reponse);
                //debug
                //echo "score=$score<br>";
                if($q<$nb_question -1)
                    $reponse .=";";
            }
            $score=round(($score /=$nb_question),2);;
    //}
   //else{

   //}
    if($type=='o')
        $score=0;

    $sql="insert into res_serie_exo values($s_numstag,$s_numcal,$id_serie,$id_ordre,'$reponse',$score,'$type',0)";
    $ins=pg_query($sql);
}


//function getBlanks($string){
//    /* Fonction qui rcupre la liste des blancs contenus dans text et les renvoi sous forme de string */
//    global $start_balise,$end_balise,$separator;
//    $tempTab=explode($start_balise,$string);
//    for($i=count($tempTab);$i>0;$i--){
//        // echo $i;
//        if(is_integer(strpos($tempTab[$i],$end_balise))){
//            $temp2=explode($end_balise,$tempTab[$i]);
//            $liste[]=$temp2[0];
//        }
//    }
//    return($liste);
//}
/*
// fonction qui test si une srie est alatoire
// Retourne 1 si alatoire
function test_serie_aleatoire($serie,&$mode_aleatoire){
    global $s_numcal;
    $aleatoire=0;
    // 1 - test si serie existante en mode alatoire
    $sql="select * from gestserie where num_serie=$serie and num_cal=$s_numcal and aleatoire='t'";
    $res=pg_query($sql);
    if(pg_numrows($res)==1){
        $mode_aleatoire=0;
        return 1;
    }
    // 2 - test si serie aleatoire monotheme ou multitheme
    $sql="select distinct mode from serie_aleatoire where num_serie=$serie";
    $res=pg_query($sql);
        if(pg_numrows($res)==1){
            $row=pg_fetch_row($res,0);
            $mode_aleatoire=$row[0];
            return 1;
        }
    return 0;
}
*/
// Si statut==1 ==> mise  jour de la table asso_exo_serie_aleatoire en fonction du mode_aleatoire
// mode_aleatoire
//  - 0 : serie existante en mode alatoire (depend de la formation)
//  - 1 : serie aleatoire monotheme (ne dpend pas de la formation)
// - 2 : serie aleatoire multitheme (ne dpend pas de la formation)
function gestion_serie_aleatoire($serie,$mode_aleatoire){
    global $s_numstag,$s_numcal;
    // preparation des donnes pour la table asso_exo_serie_aleatoire en fonction du mode_aleatoire
    // nettoyage de la table de stockage (asso_exo_serie_aleatoire)
    $sql="delete from asso_exo_serie_aleatoire where num_user='$s_numstag' and id_serie='$serie' and num_cal=$s_numcal;";
    $del=pg_query($sql);

    if($mode_aleatoire==0){
        //on extrait  les questions aleatoirement de la table asso_exo_serie
        // l'alatoire
        srand((double)microtime()*100000);
        $sql="select id_exo,id_exo*0+random() as ordre,chrono,point,commentaire,bareme,type_exo from asso_exo_serie
                        where id_serie='$serie' order by ordre;";
        $resquestion=pg_query($sql);
        $nbqstion=pg_numrows($resquestion);
        // insertion ds la table asso_exo_serie_aleatoire
        for($qst=0;$qst<$nbqstion;$qst++){
            $numordre=$qst+1;
            $rowquestion=pg_fetch_row($resquestion,$qst);
            $rowquestion[4]=addslashes($rowquestion[4]);
            $sql="insert into asso_exo_serie_aleatoire values
                        ('$rowquestion[0]','$serie','$numordre','$rowquestion[4]','$rowquestion[5]','$rowquestion[2]',
                        '$rowquestion[3]','$rowquestion[6]','$s_numstag','$s_numcal');";
            $ins=pg_query($sql);
        }
    }
    else {
        //recup des infos pour cette serie aleatoire
        $sql="select * from serie_aleatoire where num_serie='$serie' ";
        $res=pg_query($sql);
        $nb=pg_numrows($res);
        //debug
        //echo "nb=$nb<br>";
        $num_ordre=1;
        $tabstock=array();
        $depart=0;
        // boucle sur les series
        for($cpt=0;$cpt<$nb;$cpt++){
            $row=pg_fetch_row($res,$cpt);
            if($mode_aleatoire==1)
                $serie_courante=$row[2];
            else
                $theme_courant=$row[1];
            $liste_exo=$row[3]; // ex de liste f:4,q:5,s:2
            //debug
            //echo "liste_
            $tabexo=array();
            $tabexo=explode(",",$liste_exo);
            $nbexo=sizeof($tabexo);
            //debug
            //echo "nbexo=$nbexo<br>";
            // boucle sur les exo
            for($e=0;$e<$nbexo;$e++){
                $tabval=explode(":",$tabexo[$e]); // ex : $tabval[0]='f' et $tabval
                //debug
                //echo "tabval[0]=$tabval[0] et tabval[1]=$tabval[1]<br>";
                // on extrait alatoirement les exo de type f de la table asso_exo_serie pour la serie courante
                srand((double)microtime()*100000);
                // debug
                //echo "mode=$mode_aleatoire<br>";
                if($mode_aleatoire==1){
                    $sql="select id_exo,id_exo*0+random() as ordre,point,commentaire from asso_exo_serie where
                                id_serie=$serie_courante  and type_exo='$tabval[0]' order by ordre limit $tabval[1]";
                }
                else
                    $sql="select id_exo,id_exo*0+random() as ordre,point,commentaire from asso_exo_serie where id_serie in
                                    (select id from serie_exo where theme=$theme_courant) and type_exo='$tabval[0]' order by ordre limit $tabval[1]";
                $ress=pg_query($sql);
                $nb1=pg_numrows($ress);
                // stockage ds un tablo
                for($s=0;$s<$nb1;$s++){
                    $rows=pg_fetch_row($ress,$s);
                    $tabstock[$depart][]=$rows[0]; // id_exo
                    $tabstock[$depart][]=$rows[2];    // point
                    $tabstock[$depart][]=$rows[3];    // commentaire
                    $tabstock[$depart][]=$tabval[0]; // type exo
                    $depart++;
                }
            }
        }
        // exploitation du tableau $tabstock
        //srand($time());
        srand((double)microtime()*100000);
        shuffle($tabstock);
        // balayage du tablo et insertion ds asso_exo_serie_aleatoire
        while(list($cle,$valeur)=each($tabstock)){
            $tab=array();
            while(list($cle2,$valeur2)=each($tabstock["$cle"])){
                $tab[]=$valeur2;
            }
            $tab[2]=addslashes($tab[2]);
            $sql="insert into asso_exo_serie_aleatoire values('$tab[0]','$serie','$num_ordre','$tab[2]','0','0','$tab[1]','$tab[3]','$s_numstag','$s_numcal')";
            $ins=pg_query($sql);
            $num_ordre++;
        }
    }
}
?>
