<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affiche de la prsentation de la serie.
 * 
 * @package serie
 */
 class guiFoDoSerieContenu extends PageComponent{
	/**
	 * @param string $block_target Variable du tpl pre ou sont stocks les lments pour l'affichage.
	 * @param object[] $obj_DoEtape Objet de base servant  gerer l'avancement des tapes d'un parcours.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet. 
	 */
	function guiFoDoSerieContenu($block_target,$obj_DoEtape,$module_root=null,$templates=null){
	global $MSG_625a, $MSG_850,$MSG_2255,$MSG_1485,$MSG_2254,$MSG_1386,$MSG_2170,$MSG_2553,$MSG_2333;
	global $MSG_263,$MSG_262,$MSG_261,$MOT_8;
		parent::PageComponent($module_root,$templates);
		
		//--------------------------------------------------------
		// 					Proprits srie
		//--------------------------------------------------------
		$obj_DoEvaluation = $obj_DoEtape->getCurrentDoEvaluation();
		$formation = $obj_DoEtape->getFormation();
		$individu =$obj_DoEtape->getIndividu();
		$parcours = $obj_DoEtape->getParcours();
		$id_serie = &$obj_DoEtape->getEtape();
		$obj_Serie = $obj_DoEtape->getObjEtape();
//		print_rr($obj_DoSerie);
		
		//--------------------------------------------------------
		// 					Types d'valuation de la srie
		//--------------------------------------------------------
		$tabtyp=$obj_Serie->getEvaluationsTypes();
		$nb_type_evaluations=pg_num_rows($tabtyp);
		
		//--------------------------------------------------------
		// 					Serie bloquante
		//--------------------------------------------------------
		// serie bloquante ?
		$bloquante=$obj_Serie->isBloquante($formation, $parcours);
		// recup configuration si serie bloquante
		if($bloquante){
			
			$serie_description_complement= new guiFoSerieBloquanteDescription($obj_DoEtape,$module_root,array('serie_description_complement'=>'gui_fo_serie_bloquante_description.tpl'));
  		    $this->setComponent('serie_description_complement',$serie_description_complement);
		}
		
		//--------------------------------------------------------
		// 					Chrono srie
		//--------------------------------------------------------
		//Affiche une phrase qui dit si il y a un chrono ou non sur la serie.		
		//print_rr($obj_Serie);
		$configuration_affichage = 0;//TODO A modifier , chercher comment on recupere la configuration d'affichage'
		if($configuration_affichage==0 || $confEtapeiguration_affichage==1){
			$chrono_serie=$obj_Serie->getChrono();
			//echo "chrono_serie=$chrono_serie<br>";
			$valchrono=$obj_Serie->getChronoTotal();
			//echo "\$valchrono=$valchrono";
			//pas de chrono
			if(is_null($valchrono)){
				$msg_type_chrono=MSG_1386;
			}
			else{
				
				//temps global
				//if($valchrono>=0){
				if($chrono_serie>0){
					
					$msg_type_chrono=MSG_1388.": ";
				}
				//temps individuel
				else{
					//$valchrono=-$valchrono;
					$msg_type_chrono="Somme des chrono individuels : ";
				}
				
				$time=sec_to_txt($valchrono);
		    }
		}
		
	
		
		//--------------------------------------------------------
		// 					Nombre dvaluations
		//--------------------------------------------------------
		$res_evaluations=$obj_Serie->getEvaluations();
		$nb_evaluations=pg_num_rows($res_evaluations);
		if($nb_evaluations>0){
			$msg_nb_evaluation=MSG_2679.": ";
		}else{
			$msg_nb_evaluation=MSG_2553;	
		}
		
		
		
		$val['SERIE_TYPES_LABEL']=MSG_2666;
		$val['SERIE_CHRONO_LIBELLE']=$msg_type_chrono;
		$val['SERIE_CHRONO']=$time;
		
		$val['SERIE_NB_EVALUATIONS_LIBELLE']=$msg_nb_evaluation;
		if($nb_evaluations>0)
		$val['SERIE_NB_EVALUATIONS'] =$nb_evaluations;
		$this->set_var($val);
			
		$this->set_block($block_target,'serie_types_evaluations','serie_types_evaluations_tmp');
		for($i=0;$i<$nb_type_evaluations;$i++){
			$row=pg_fetch_row($tabtyp,$i);
			$id_type_eval = $row[0];
			$libelle_type_eval = $row[1];
			
			$nb_type_eval = $row[3];
			$serie_type_evaluation= new guiFoSerieTypeEvaluation($id_type_eval,$libelle_type_eval,$nb_type_eval,$module_root,array('serie_type_evaluation'=>'gui_fo_serie_type_evaluation.tpl'));
  		    $this->setComponent('serie_type_evaluation',$serie_type_evaluation,true,'serie_types_evaluations','serie_types_evaluations_tmp');
        }
	}
}
?>