<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affichage d'une srie.
 * 
 * @package serie
 */
class guiFoSerie extends PageComponent{
	/**
	 * @var object $debut Objet contenant les lments necessaire  l'affichage du debut du module.
	 */
	var $debut;
	
	/**
	 * @var object $contenu Objet contenant les lments necessaire  l'affichage du contenu du module.
	 */
	var $contenu;
	
	/**
	 * @var object $fin Objet contenant les lments necessaire  l'affichage de la fin du module.
	 */
	var $fin;
	 /**
	 * Constructeur
	 * 
	 * @param object[] $obj_DoEtape Objet de base servant  gerer l'avancement des tapes d'un parcours.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet. 
	 */
	function guiFoSerie($obj_DoEtape, $module_root=null,$templates=null){
		global $chemin_fo;
		parent::PageComponent($module_root,$templates);

		$this->debut= new guiFoDoListeDebut($obj_DoEtape,"$chemin_fo/liste/templates/tpl",array('etape_debut'=>'gui_fo_do_liste_debut.tpl'));
		$this->contenu=new guiFoDoSerieContenu('etape_contenu',$obj_DoEtape,"$chemin_fo/serie/templates/tpl",array('etape_contenu' => 'gui_fo_do_serie_contenu.tpl'));
		$this->fin=new guiFoDoListeFin($obj_DoEtape,"$chemin_fo/liste/templates/tpl",array('etape_fin' => 'gui_fo_do_liste_fin.tpl'));
		
		$this->setComponent('etape_debut', $this->debut);
		$this->setComponent('etape_contenu', $this->contenu);
		$this->setComponent('etape_fin', $this->fin);
	}
}
?>
