<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche la description de la configuration en mode bloquant.
 * 
 * @package serie
 */
 class guiFoSerieBloquanteDescription extends PageComponent{
 	/**
 	 * @param object[] $obj_DoEtape Objet de base servant  gerer l'avancement des tapes d'un parcours.
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
 	function guiFoSerieBloquanteDescription ($obj_DoSerieBloquante,$module_root=null, $templates=null){
 		
 		//global $MSG_1489,$MSG_1497,$MSG_2554,$MSG_2555;
 		parent::PageComponent($module_root,$templates);
 		
 		$formation = $obj_DoSerieBloquante->getFormation();
		$individu =$obj_DoSerieBloquante->getIndividu();
		$parcours = $obj_DoSerieBloquante->getParcours();
		$serie = $obj_DoSerieBloquante->getObjEtape();
		
		// recup id_resultat
		$resres=get_resultat_etape($formation,$individu,$parcours,$serie->getId());
		$rowres=pg_fetch_row($resres,0);
		$id_resultat=$rowres[0];
		
 		$resmode_bloquant= get_serie_bloquante_configuration($serie->getId(),$formation,$parcours);
		if($resmode_bloquant && pg_num_rows($resmode_bloquant)>0){
			$rowmode_bloquant=pg_fetch_row($resmode_bloquant);
		    $seuil=$rowmode_bloquant[3];
			$nbtentative=$rowmode_bloquant[5];
		    // recup du nombre de tentatives deja faite
			$resessai=get_resultat_etape_tentative($id_resultat);
			$nb_essai=pg_num_rows($resessai);
			
			// nombre d'essai restant
			$nb_essai_restant=$nbtentative - $nb_essai;
		}else{
			$this->setPageMessage("Erreur lors de la rcupration de la configuration de la srie bloquante.",MSG_ERROR);
		}
				
 		$val['SERIE_BLOQUANTE_TEXTE'] =MSG_2554;
 		$val['SERIE_BLOQUANTE_NB_TENTATIVES_LIBELLE'] =MSG_1489." : ";
 		$val['SERIE_BLOQUANTE_NB_TENTATIVES'] =$nbtentative;
 		$val['SERIE_BLOQUANTE_SEUIL_LIBELLE'] =MSG_1497." : ";
 		$val['SERIE_BLOQUANTE_SEUIL'] =$seuil;
 		$val['SERIE_BLOQUANTE_NB_ESSAIS_LIBELLE'] =MSG_2555." : ";
 		$val['SERIE_BLOQUANTE_NB_ESSAIS'] =$nb_essai;
 		$this->set_var($val);
 	}
 }
?>