<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de base pour la cration de pages du back-office.
 */
class AstairsPageFo extends AstairsPage{
	
	var $pageBuilder;
	var $pageComponents;

	/**
	 * Constructeur.
	 * @param object PageBuilder $pageBuilder L'objet permettant de crer une page
	 * @param Array $templates Les templates  utiliser pour la cration de la page
	 * @param Array $style_files Les feuilles de style
	 * @param Array $javascript_files Les fichiers javascript
	 * @param string $javascript_internal_code Le code javascript interne
	 */
	function AstairsPageFo($pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code){

		//debug
//		Template::set_debug(1);
		global $chemin_fo, $dbpath;
		//parent
		$javascript_files["../templates/javascript"][]="javascript_front.js";
		parent::AstairsPage($pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code);
		
		//cration des lments de la page
		$page_fin=new AstairsPageFoFin("$chemin_fo/templates/tpl",array('page_footer' => 'astairs_page_fo_fin.tpl'));

		//affectation des lments
		$this->setComponent('page_footer', $page_fin);
	}
	
	function parse(){
		parent::parse();
	}
}
?>