<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
 
/**
	Fichier de fonction php pour alerte
	@package alerte
	@modulegroup fonctions
*/   




$list_jour = array(1 => "$JOUR_1", "$JOUR_2", "$JOUR_3", "$JOUR_4", "$JOUR_5", "$JOUR_6", "$JOUR_7");
$list_mois = array(1 => "$MOIS_1", "$MOIS_2", "$MOIS_3", "$MOIS_4", "$MOIS_5", "$MOIS_6", "$MOIS_7", "$MOIS_8", "$MOIS_9", "$MOIS_10", "$MOIS_11", "$MOIS_12");

function strip_zero($num){
        if($num[0]==0){
                $num=$num[1];
        }
        return($num);
}

function add_zero($num){
        if($num<10)
                $num='0'.$num;
        return $num;
}
function get_num_date($date){
	/* Fonction qui rcupre le numro de la date, crant la date dans la table "dates" si besoin */
    /*
        $sql="SELECT num_date
                  FROM dates
                  WHERE jour='$date'";
        $result=pg_query($sql);
	*/
	$result=get_date_numero($date);
	if(pg_numrows($result)==0){
		/*
                $sql="INSERT INTO dates (jour) VALUES('$date')";
                $result=pg_query($sql);
                $num=get_num_date($date);
		*/
		$num=set_date($date);
	}
    else{
                $num=pg_fetch_result($result,0);
	}
    return($num);
}

function reload_father(){
       global $num_cal,$odate;
       if($odate)
                $date=$odate;
       else
                global $date;

       echo '<script language="Javascript"> window.opener.location="addalerte.php?date='.$date.'&num_cal='.$num_cal.'";</script>';
}

function alert_js($msg){
               /* met en place un laert javascript */
                        echo '<script language="javascript">alert("'.$msg.'");</script>';
}


function test_cal($num_cal){
/* test si le calendrier existe */

if($num_cal!=''){
	/*
        $sql="SELECT count(*) FROM calendrier WHERE num_cal=$num_cal";
        $result=pg_exec($sql);
        if(pg_fetch_result($result,0)==0)
                return false;
        else
                return true;
	*/
	return check_formation_calendrier($num_cal);
}
else
        return false;
}

function dans_cal($num_cal,$date){
	/* test si la date $date est incluse dans la priode de la formation */
	/* retourne -1 si le calendrier n'existe pas, 1 si la date appartient  la formation, 0 sinon */
	/*

	$sql="SELECT D1.jour as debut, D2.jour as fin
          FROM calendrier C, dates D1,dates D2
          WHERE D1.num_date=C.datedeb
          AND D2.num_date=C.datefin
          AND C.num_cal=$num_cal";
          $result=pg_query($sql);
          if(pg_numrows($result)==0)
                return(-1);
          else{
                $debut=pg_fetch_result($result,0,'debut');
                $fin=pg_fetch_result($result,0,'fin');
                if($date>=$debut && $date <=$fin)
                        return(1);
                else
                        return(0);
          }
	*/
	$result=get_formation_dates($num_cal);
	if(pg_num_rows($result)==0)
		return (-1);
	$debut=pg_fetch_result($result,0,0);
	$fin=pg_fetch_result($result,0,1);
	if($date>=$debut && $date<=$fin)
		return (1);
	return (0);
}

function nom_demi_jour($type)
{
        global $MSG_189,$MSG_188,$MSG_187;
        switch($type)
        {
                case 'T' :  return($MSG_189);
                                break;
                case 'A' :  return($MSG_188);
                                break;
                case 'M' :  return($MSG_187);
                                break;
        }
}

function nb_jours_dans_mois($m, $a){
        return date("t", mktime(0, 0, 0, $m, 1, $a));
}


function numero_de_semaine($j, $m, $a){
        // semaine 1 = semaine du 1er janvier
        $h1 = mktime(0, 0, 0, 1, 1, $a);
        $h2 = mktime(0, 0, 0, $m, $j, $a);
        $nbj = ($h2 - $h1) / (3600*24);
        $p = date("w", $h1);
        $c = date("w", $h2);
        if ($p == 0)
                $p = 7;
        if ($c == 0)
                $c = 7;
        $p--;
        // p =1 lundi, c=1 lundi
        $nbj1 = 7 - $p;
        $nbj2 = ($nbj - $nbj1 - $c) / 7;
        return floor($nbj2+3);
}



function  fr_date($date){
/* Retourne  partir d'une date au format AAAA-MM-JJ la date au format JJ-MM-AAAA */
        list($annee,$mois,$jour)=split ('-',$date);
        return($jour.'-'.$mois.'-'.$annee);
}

// transforme un timestamp au format date (annee-mois-jour ex : 2006-07-25)
function timestamp_to_date($date,$separateur){
	$tab=getdate($date);
	$j=$tab["mday"];
	$m=$tab["mon"];
	$a=$tab["year"];
	$z=0;
	$j2=($j<10)?$z.$j:$j;
	$m2=($m<10)?$z.$m:$m;
	$texte=$a.$separateur.$m2.$separateur.$j2;
	return $texte;
}

// transforme une date (format date) en timestamp
function date_to_timestamp($date){
	$tab=explode("-",$date);
	return mktime(0,0,0,$tab[1],$tab[2],$tab[0]);
}   

function  fr_txt_date($date){
	
/* retourne la date au format texte, ex : Mardi 13 Avril */
        global $list_jour, $list_mois;
		if(gettype($date)=='integer'){
			$date=timestamp_to_date($date,'-');
			
		}
		//echo "dt=$date<br>";
		$tab=explode(" ",$date);
		$date=$tab[0];
        list($annee,$mois,$jour)=split('-',$date);
        $num_jour=jour_semaine($date);
        return($list_jour[$num_jour].'&nbsp;'.$jour.'&nbsp;'.$list_mois[strip_zero($mois)].'&nbsp;'.$annee);
}


function jour_semaine($date){
        $num=date('w',strtotime($date));
        if($num==0)                                                     
                $num=7;
        return($num);
}

// fonction qui retourne la periode max disponible
function calcul_periode($num_cal,$date){
	
    //recup des jours > $date
	/*
    $req="select jour from dates where num_date in
    (select num_date from alert where num_cal='$num_cal') and jour>'$date' order by jour";
    $res=pg_query($req);
	*/
	$periode=get_alerte_periode_max($num_cal,$date);
	//echo "periode=$periode<br>";
	/*
    if(pg_numrows($res)>0){
        // recup du premier jour
        $row=pg_fetch_row($res,0);
        $tabjour=explode("-",$row[0]);
        $tabdate=explode("-",$date);
        $jour = mktime( 0, 0, 0, $tabjour[1], $tabjour[2], $tabjour[0] );
        $dt = mktime( 0, 0, 0, $tabdate[1], $tabdate[2], $tabdate[0] );

        $dif=($jour-$dt) / (60*60*24);
        if($dif>15)
            $periode=15;
        else
            $periode=$dif -1;
    }
    else
        $periode=15;
	*/
	if($periode>15 || empty($periode))
		$periode=15;
    return $periode;
}

// fonction de mise  jours des periodes prcdentes
// ex : si le 15/03/2003 il y a une alerte pour 15 jours
//        et qu'on met une alerte le 25/03/2003 alors
//        il faut reduire la periode  9 jours
function maj_periode($num_cal,$num_date){
    // recup de la date de num_date
	/*
    $req="select jour from dates where num_date='$num_date'";
    $res=pg_query($req);
	*/
	$res=get_date_jour($num_date);
    $row=pg_fetch_row($res,0);
    $date=$row[0];
    //recup des jours < $date
	/*
    $req="select jour,num_date from dates where num_date in
    (select num_date from alert where num_cal='$num_cal') and jour<'$date' order by jour desc";
    $res=pg_query($req);
	*/
	$res=get_alerte_jours_avant_date($num_cal,$date);
    if(pg_numrows($res)>0){
        //recup du jour precedent
        $row=pg_fetch_row($res,0);

        // recup de la periode de ce jour
		/*
        $req="select periode from alert where num_cal='$num_cal' and num_date='$row[1]'";
        $resperiode=pg_query($req);
		*/
		$resperiode=get_alerte_periode($num_cal,$row[1]);
        $rowperiode=pg_fetch_row($resperiode,0);
        $periode=$rowperiode[0];
        $tabjour=explode("-",$row[0]);
        $tabdate=explode("-",$date);
        $jour = mktime( 0, 0, 0, $tabjour[1], $tabjour[2], $tabjour[0] );
        $dt = mktime( 0, 0, 0, $tabdate[1], $tabdate[2], $tabdate[0] );
        $dif=($dt -$jour) / (60*60*24);
        if($periode>$dif){
            $periode=$dif -1;
			/*
            $req="update alert set periode='$periode' where num_cal='$num_cal' and num_date='$row[1]'";
            $res=pg_query($req);
			*/
			$res=maj_alerte_periode($num_cal,$row[1],$periode);
        }

    }
}

function affiche_calendrier($date,$num_cal){                                          
	global $list_mois,$MSG_171;
	/*
        $sql="SELECT D1.jour as debut, D2.jour as fin
                  FROM calendrier C,dates D1, dates D2
                  WHERE num_cal='$num_cal'
                  AND  D1.num_date=C.datedeb
                  AND  D2.num_date=C.datefin
                  ";
        $result = pg_query($sql);
	*/
	
	//$result=get_formation_dates($num_cal);
	/*
        $debutcal=pg_fetch_result($result,0,"debut");
        $fincal=pg_fetch_result($result,0,"fin");
	*/
	//$debutcal=pg_fetch_result($result,0,0);
    //$fincal=pg_fetch_result($result,0,1);
	$result=get_formation($num_cal);
	$debutcal=pg_fetch_result($result,0,3);
    $fincal=pg_fetch_result($result,0,4);
	list($annee,$mois,$jour)=split('-',$date);
    $nb_jour=nb_jours_dans_mois($mois, $annee);
	

        // Dans cette version du calendrier, on ne veut visualiser que les jours ayant une alerte
        // on remplit le tableau $tab_cours, avec comme indice le numro du jour : 0 s'il y a au moins aun cours, 0 sinon;
        /*
        $sql="SELECT D.jour
                  FROM dates D,gest_cal G
                  WHERE D.num_date=g.num_date
                  AND G.gnum_cal=$num_cal
                  AND  D.jour BETWEEN '$annee-$mois-01' AND '$annee-$mois-$nb_jour'";
        */
		/*
        $sql="SELECT D.jour
                  FROM dates D,alert A
                  WHERE D.num_date=A.num_date
                  AND A.num_cal=$num_cal
                  AND  D.jour BETWEEN '$annee-$mois-01' AND '$annee-$mois-$nb_jour'";

        $result=pg_query($sql);
		*/
	$datedeb=$annee."-".$mois."-01";
	$datefin=$annee."-".$mois."-".$nb_jour;
	$result=get_formation_alertes_periode($num_cal,$datedeb,$datefin);
	/*
	while($row=pg_fetch_array($result)){
		list($a,$m,$j)=split('-',$row["jour"]);
        $tab_cours[strip_zero($j)]=1;
	}
	*/
	while($row=pg_fetch_row($result)){
		list($a,$m,$j)=split('-',$row[3]);
        $tab_cours[strip_zero($j)]=1;
	}
    // Gnration des mois suivants / prcdents
    if($mois==12)
		$moissuiv=($annee+1).'-01-01';
	else
		$moissuiv=$annee.'-'.add_zero(strip_zero($mois)+1).'-01';
	if($mois=='01')
		$moispre=($annee-1).'-12-01';
	else
		$moispre=$annee.'-'.add_zero(strip_zero($mois)-1).'-01';
	$num_premier=jour_semaine($annee.'-'.$mois.'-01');
    print("
	<table class=\"tableau_normal\">
    <tr>
    <td> &nbsp;</td>
    <td bgcolor=\"333399\" align=\"center\">
	<a href=\"alerte.php?action_alerte=ajout_alerte&num_cal=$num_cal&date=".($annee-1).'-'.$mois."-01\">
	<font color=\"#FFFFFF\"><b><</b></font></a>
	</td>
	<td colspan=\"5\" bgcolor=\"333399\" align=\"center\"><center><font color=\"#FFFFFF\"><b>$annee</center></td>
	<td bgcolor=\"333399\" align=\"center\">
	<a href=\"alerte.php?action_alerte=ajout_alerte&num_cal=$num_cal&date=".($annee+1).'-'.$mois."-01\">
	<font color=\"#FFFFFF\"><b>></b></font></a>
	</td>
    </tr>
	<tr>
    <td> &nbsp;</td>
    <td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\" ><b> 
	<a href=\"alerte.php?action_alerte=ajout_alerte&num_cal=$num_cal&date=$moispre\"><</a></b>
	</td>
    <td colspan=\"5\" bgcolor=\"333399\" align=\"center\">
	<center><font color=\"#FFFFFF\"><b>".$list_mois[strip_zero($mois)]."</center>
	</td>
    <td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b>
	<a href=\"alerte.php?action_alerte=ajout_alerte&num_cal=$num_cal&date=$moissuiv\">></a></b>
	</td>
    </tr>
	<tr>
	<td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b> $MSG_171 </b></font></td>
                   <td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b> L </b></font></td>
                   <td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b> M </b></font></td>
                   <td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b> M </b></font></td>
                   <td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b> J </b></font></td>
                   <td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b> V </b></font></td>
                   <td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b> S </b></font></td>
                   <td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b> D </b></font></td>
	</tr>
	<tr>
	");
	if($num_premier>1)
		print("
		<td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b>".numero_de_semaine('01',$mois,$annee)."</b></font></td>
		");
	$i=0;
    while ($i<($num_premier-1)){
		echo '<td>&nbsp;</td>';
        $i++;
	}
    $e=1;
    while($e<=$nb_jour){
		if( ($i % 7)==0 ){
			if($i!=0)
				print("<tr>");
			print("
			<td bgcolor=\"333399\" align=\"center\"><font color=\"#FFFFFF\"><b>".numero_de_semaine(add_zero($e),$mois,$annee)."</td>
			");
		}
        switch($annee.'-'.$mois.'-'.add_zero($e)){
			case($date) :
				$bgcolor='#FF0000';
			break;
			default :
				// jour de formation
				if( ($annee.'-'.$mois.'-'.add_zero($e))>=$debutcal && ($annee.'-'.$mois.'-'.add_zero($e))<=$fincal )
					$bgcolor='#EFB639';
				// jour hors de la formation
				else
					$bgcolor='#8E8EBB';
			break;
		}
		$chaine_date=$annee.'-'.$mois.'-'.add_zero($e);
		print("
		<td bgcolor=\"$bgcolor\" width=\"20\" align=\"center\"><b>
		<a href=\"alerte.php?action_alerte=ajout_alerte&num_cal=$num_cal&date=$chaine_date\">
		");

		if($tab_cours[$e]==1)
			print("<font color=\"black\">$e</font>");
		else
			print("<font color=\"#FFFFFF\">$e</font>"); // couleur blanche
		//echo $e;
		print("</a></b></td>");
		$e++;
		$i++;
		if( ($i % 7)==0)
			echo '</tr>';
	}
	echo '</tr></table>';
}                       


                    


?>