<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package alerte
 * @modulegroup plpgsql
 * @module plpgsql_alerte
 */
include("$root/lib/alerte/plpgsql_deprecated_alerte.inc");

/**
   Enregistre une alerte (OLD)
*
*   @param integer : le numero de formation
*   @param integer : le numero de date
*   @param integer : la periode
*   @param varchar : l'intitul de l'alerte
*   @param text : le texte de l'alerte
*   @return integer : le resultat de la requete
*/
function set_alerte_old($formation,$date,$periode,$titre,$texte){
	// recup $num_date
	$num_date=get_num_date($date);
    $sql="insert into alert (num_cal,num_date,periode,intitule,texte) values($formation,$num_date,$periode,'$titre','$texte');";
    $ins=pg_query($sql);
    return $ins;
}
/**
   Enregistre une alerte
*
*   @param integer : le numero de formation
*   @param integer : le numero de date
*   @param integer : la periode
*   @param varchar : l'intitul de l'alerte
*   @param text : le texte de l'alerte
*   @return integer : le resultat de la requete
*/
function set_alerte($formation,$date,$periode,$titre,$texte){
    if (VERSION_BASE > VERSION) {
    	if(empty($date)){
    		$date='NULL';
			$sql="select * from contraintes.af_set_alerte('$titre',$formation,$date,$periode,'$texte')";
    	}
    	else
    		$sql="select * from contraintes.af_set_alerte('$titre',$formation,'$date',$periode,'$texte')";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res = set_alerte_old($formation,$date,$periode,$titre,$texte);
    return $res;
}

/**
   Modifie une alerte (OLD)
*
*   @param integer : le numero d'alerte
*   @param integer : la periode
*   @param varchar : l'intitul de l'alerte
*   @param text : le texte de l'alerte
*   @return integer : le resultat de la requete
*/
function maj_alerte_old($alerte,$periode,$titre,$texte){
   $sql="update alert set periode=$periode,intitule='$titre',texte='$texte' where num_alert=$alerte";
    $maj=pg_query($sql);
    return $maj;
}
/**
   Modifie une alerte
*
*   @param integer : le numero d'alerte
*   @param integer : la periode
*   @param varchar : l'intitul de l'alerte
*   @param text : le texte de l'alerte
*   @return integer : le resultat de la requete
*/
function maj_alerte($alerte,$periode,$titre,$texte){
    if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_maj_alerte($alerte,'$titre',$periode,'$texte')";
		//echo "sql=$sql<br>";
		$res=sql2Bool(pg_fetch_result(pg_query($sql),0,0));
    }
    else
        $res = maj_alerte_old($alerte,$periode,$titre,$texte);
    return $res;
}

/**
    Supprime une alerte (OLD)
*
*   @param integer : le numero d'alerte
*   @return integer : le resultat de la requete
*/
function del_alerte_old($alerte){
    $sql="delete from alert where num_alert=$alerte";
    $del=pg_query($sql);
    return $del;
}
/**
    Supprime une alerte
*
*   @param integer : le numero d'alerte
*   @return integer : le resultat de la requete
*/
function del_alerte($alerte){
    if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_del_alerte($alerte)";
		echo $sql;
		$res=sql2Bool(pg_fetch_result(pg_query($sql),0,0));
    }
    else
        $res = del_alerte_old($alerte);
    return $res;
}

/**
    Obtenir les infos d'une alerte(OLD)
*
*   @param integer : le numero d'alerte
*   @return integer : le resultat de la requete
*/
function get_alerte_old($alerte){
    $sql="select num_alert,intitule,num_cal,num_date,periode,texte  from alert where num_alert=$alerte";
    $res=pg_query($sql);
    return $res;
}
/**
   Obtenir les infos d''une alerte
*
*   @param integer : le numero d'alerte
*   @return integer : le resultat de la requete
*/
function get_alerte($alerte){
    if (VERSION_BASE > VERSION) {
        $sql="select * from contraintes.af_get_alerte($alerte) as (id int4,libelle varchar,formation int4,date date,jours int4,texte text)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res = get_alerte_old($alerte);
    return $res;
}

/**
    Obtenir la periode max pour une alerte (OLD)
*
*   @param integer : le numero de formation
*   @param date : la date de l'alerte
*   @return integer : le resultat de la requete
*/
function get_alerte_periode_max_old($formation,$date){
    //$sql="select min(jour) from dates where num_date in (select num_date from alert where num_cal=$formation) and jour>'$date' ";
	$sql="select min(D.jour) from dates D,alert A where D.num_date=A.num_date and A.num_cal=$formation and D.jour>'$date'";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
	if(pg_fetch_result($res,0,0)>$date)
		$nbjours = round((strtotime(pg_fetch_result($res,0,0)) - strtotime($date))/(60*60*24)-1);
	else
		$nbjours=15;
	return $nbjours;;
}
/**
    Obtenir la periode max pour une alerte
*
*   @param integer : le numero de formation
*   @param date : la date de l'alerte
*   @return integer : le resultat de la requete
*/
function get_alerte_periode_max($formation,$date){
    if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_alerte_periode_max($formation,'$date')";
		$res=pg_query($sql);
		return $res;
    }
    else{
        //$res = get_alerte_periode_max_old($formation,$date);
		return  get_alerte_periode_max_old($formation,$date);
	}
    //return pg_fetch_result($res,0,0);
	
}

/**
    Obtenir les date d'alerte avant une date de formation (OLD)
*
*   @param integer : le numero de formation
*   @param date : la date de formation
*   @return integer : le resultat de la requete
*/
function get_alerte_jours_avant_date_old($formation,$date){
    $sql="select jour,num_date from dates where num_date in (select num_date from alert where num_cal=$formation) and jour<'$date' order by jour desc";
    $res=pg_exec($sql);
    return $res;
}
/**
    Obtenir les date d'alerte avant une date de formation
*
*   @param integer : le numero de formation
*   @param date : la date de formation
*   @return integer : le resultat de la requete
*/
function get_alerte_jours_avant_date($formation,$date){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_alerte_jours_avant_date_old($formation,$date);
    return $res;
}

/**
    Obtenir la periode d'une alerte (OLD)
*
*   @param integer : le numero de formation
*   @param integer: le numero de date de formation
*   @return integer : le resultat de la requete
*/
function get_alerte_periode_old($formation,$num_date){
    $sql="select periode from alert where num_cal=$formation and num_date=$num_date";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir la periode d'une alerte
*
*   @param integer : le numero de formation
*   @param integer : le numero de date de formation
*   @return integer : le resultat de la requete
*/
function get_alerte_periode($formation,$num_date){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = get_alerte_periode_old($formation,$num_date);
    return $res;
}

/**
    Modifier la periode d'une alerte (OLD)
*
*   @param integer : le numero de formation
*   @param integer : la date de formation
*   @param integer : la periode
*   @return integer : le resultat de la requete
*/
function maj_alerte_periode_old($formation,$num_date,$periode){
    $sql="update alert set periode=$periode where num_cal=$formation and num_date=$num_date";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    return $res;
}
/**
    Modifier la periode d'une alerte
*
*   @param integer : le numero de formation
*   @param integer : la date de formation
*   @param integer : la periode
*   @return integer : le resultat de la requete
*/
function maj_alerte_periode($formation,$num_date,$periode){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = maj_alerte_periode_old($formation,$num_date,$periode);
    return $res;
}

/**
    Mettre  jour une alerte pour un numero de date de formation (OLD)
*
*   @param integer : le numero de formation
*   @param integer : la date de formation
*   @param integer : la periode
*   @param varchar : l'intitul de l'alerte
*   @param text : le texte de l'alerte
*   @return integer : le resultat de la requete
*/
function maj_alerte_formation_num_date_old($formation,$num_date,$periode,$titre,$texte){
    $sql="update alert set periode=$periode,intitule='$titre',texte='$texte' where num_cal=$formation and num_date=$num_date";
    return (pg_query($sql));
}
/**
    Mettre  jour une alerte pour un numero de date de formation
*
*   @param integer : le numero de formation
*   @param integer : la date de formation
*   @param integer : la periode
*   @param varchar : l'intitul de l'alerte
*   @param text : le texte de l'alerte
*   @return integer : le resultat de la requete
*/
function maj_alerte_formation_num_date($formation,$num_date,$periode,$titre,$texte){
    if (VERSION_BASE > VERSION) {
        print ("A implementer...");
    }
    else
        $res = maj_alerte_formation_num_date_old($formation,$num_date,$periode,$titre,$texte);
    return $res;
}




?>