<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 Un bareme s'utilise dans les listes d'evaluations.
 Il est compos:
 	- d'un identifiant unique (id)
 	- d'un libell (libelle)
 	- d'un nombre de points pour une rponse juste (juste)
 	- d'un nombre de points pour une rponse fausse (fausse)
 	- d'un nombre de points si toutes les rponses ne sont pas coches (manquantes)
 	- d'un nombre de points si toutes les rponses sont coches (toutes)
 	
 Les nombres de points sont positifs ou ngatifs.
  
      @package bareme
      @modulegroup plpgsql
      @module plpgsql_bareme
*/

/**
 * Fichier de fonctions dprcies
 */
//include ("$chemin_bo/lib/bareme/plpgsql_deprecated_bareme.inc");


/**
    Enregistre un bareme (OLD)

    @param string : le libelle du bareme
    @param integer : valeur pour reponse juste
    @param integer : valeur pour reponse fausse
    @param integer : valeur pour pas coch
    @param integer : valeur pour tout coch
*/
function set_bareme_old($libelle,$juste,$fausse,$manquantes,$toutes){
        $sql="INSERT INTO bareme (libelle_bareme,repok,repnotok,pascoche,toutcoche) 
				VALUES ('$libelle',$juste,$fausse,$manquantes,$toutes)";
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $res=pg_query("SELECT num_bareme  FROM bareme WHERE OID=$oid;");
        return pg_result($res, 0, 0);

}
/**
    Enregistre un bareme

    @param string : le libelle du bareme
    @param integer : valeur pour reponse juste
    @param integer : valeur pour reponse fausse
    @param integer : valeur pour pas coch
    @param integer : valeur pour tout coch
*/
function set_bareme($libelle,$juste,$fausse,$manquantes,$toutes){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_set_bareme('$libelle',$juste,$fausse,$manquantes,$toutes)";
 		//echo "$sql<br>";
 		return pg_fetch_result(pg_query($sql),0,0);
    }
    else
        return set_bareme_old($libelle,$juste,$fausse,$manquantes,$toutes);
}

/**
	Modifie un bareme (OLD)
	@param integer : numero bareme
	@param string : le libelle du bareme
    @param integer : valeur pour reponse juste
    @param integer : valeur pour reponse fausse
    @param integer : valeur pour pas coch
    @param integer : valeur pour tout coch
	@return integer 1 ok , 0 false
*/
function maj_bareme_old($bareme, $libelle,$juste,$fausse,$manquantes,$toutes){
	$sql="update bareme set libelle_bareme='$libelle',repok=$juste,repnotok=$fausse,pascoche=$manquantes,toutcoche=$toutes 
				where num_bareme=$bareme";
	return pg_query($sql);
}
/**
	Modifie un bareme 
	@param integer : numero bareme
	@param string : le libelle du bareme
    @param integer : valeur pour reponse juste
    @param integer : valeur pour reponse fausse
    @param integer : valeur pour pas coch
    @param integer : valeur pour tout coch
	@return integer 1 ok , 0 false
*/
function maj_bareme($bareme, $libelle,$juste,$fausse,$manquantes,$toutes){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_bareme($bareme, '$libelle',$juste,$fausse,$manquantes,$toutes)";
		$res=pg_query($sql);
	}
	else
		$res=maj_bareme_old($bareme, $libelle,$juste,$fausse,$manquantes,$toutes);
	return $res;
}

/**
    Obtenir les infos d'un bareme (OLD)

    @param integer : le numero du bareme
    @param integer : le resultat de la requete (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4)
*/
function get_bareme_old($bareme){
    $sql="SELECT num_bareme, libelle_bareme,repok,repnotok,pascoche, toutcoche FROM BAREME WHERE num_bareme=$bareme";
    $res=pg_query($sql);
    //echo "$sql<br>";
    return $res;
}
/**
    Obtenir les infos d'un bareme

    @param integer : le numero du bareme
    @param integer : le resultat de la requete (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4)
*/
function get_bareme($bareme){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_bareme($bareme) AS (id int4, libelle varchar, juste int4, fausse int4, manquantes int4, toutes int4)";
 		//echo "$sql<br>";
 		return pg_query($sql);
    }
    else
        $res=get_bareme_old($bareme);
    return $res;
}

/**
    Vrifie qu'un nom de bareme est unique (OLD)

    @param string : le libelle du bareme
    @return integer : 1 si existe, 0 sinon
*/
function check_bareme_old($libelle){
    $sql="SELECT libelle_bareme FROM bareme WHERE libelle_bareme='$libellle'";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return "t";
    return "f";
}
/**
    Vrifie qu'un nom de bareme est unique

    @param string : le libelle du bareme
    @return integer : 1 si existe, 0 sinon
*/
function check_bareme($libelle){
    if(VERSION_BASE>VERSION){
		$sql = "select * from contraintes.af_check_bareme('$libelle')";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
		return pg_fetch_result($res, 0, 0);
    }
    else
        $res=check_bareme_old($libelle);
    return $res;
}

/**
	Supprime un bareme  (old)
	@param integer : numero bareme
	@return integer 1 ok, 0 erreur
*/
function del_bareme_old($bareme){
	$sql="delete from bareme where num_bareme=$bareme";
	 //echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Supprime un bareme  
	@param integer : numero bareme
	@return integer 1 ok, 0 erreur
*/
function del_bareme($bareme){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_bareme($bareme)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=del_bareme_old($bareme);
	return $res;
}

/**
	test si un bareme est supprimables (OLD)
	@param integer : numero bareme
	@return bool : true supprimable, false non supprimable
*/
function check_bareme_supprimable_old($bareme){
	$supprimable=true;
	$tab_bar=array("serie_exo"=>"bareme",
                                        "asso_exo_serie"=>"bareme",
                                        "asso_exo_serie_aleatoire"=>"bareme",
                                        "elaborqstn"=>"num_bareme",
                                        "elaborqstn_aleatoire"=>"num_bareme");

	while(list($tab,$champ)=each($tab_bar)){
		$sql="select * from $tab where $champ=$bareme ";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
		if(pg_numrows($res)>0){
			$supprimable=0;
			break;
		}
	}
	return $supprimable;
}
/**
	test si un bareme est supprimables
	@param integer : numero bareme
	@return bool : true supprimable, false non supprimable
*/
function check_bareme_supprimable($bareme){
	if(VERSION_BASE>VERSION){
		$res=!fk_finder('bareme','id',$bareme);
	}
	else
		$res=check_bareme_supprimable_old($bareme);
	return $res;
}
?>