<?
/*
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
*
 * @package bareme
 * @modulegroup plpgsql
 */

/**
    Vrifie qu'un nom de bareme est unique (OLD)

    @param string : le libelle du bareme
    @return integer : 1 si existe, 0 sinon
*/
function check_bareme_libelle_old($libelle){
    $sql="SELECT libelle_bareme FROM bareme WHERE libelle_bareme='$libellle'";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return 1;
    return 0;
}
/**
    Vrifie qu'un nom de bareme est unique

    @param string : le libelle du bareme
    @return integer : 1 si existe, 0 sinon
*/
function check_bareme_libelle($libelle){
    if(VERSION_BASE>VERSION){
		$sql = "select * from contraintes.af_check_bareme('$libelle')";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
		return pg_fetch_result($res, 0, 0);
    }
    else
        $res=check_bareme_libelle_old($libelle);
    return $res;
}

/**
    Enregistre un bareme (OLD)

    @param string : le libelle du bareme
    @param integer : valeur pour reponse juste
    @param integer : valeur pour reponse fausse
    @param integer : valeur pour pas coch
    @param integer : valeur pour tout coch
*/
function set_bareme_old($libelle,$rep_juste,$rep_fausse,$pas_coche,$tout_coche){
    if(!check_bareme_libelle($libelle)){
        $sql="INSERT INTO bareme (libelle_bareme,repok,repnotok,pascoche,toutcoche) VALUES ('$libelle',$rep_juste,$rep_fausse,$pas_coche,0)";
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $res=pg_query("SELECT num_bareme  FROM bareme WHERE OID=$oid;");
        return pg_result($res, 0, 0);
    }
    else
        return 0;

}
/**
    Enregistre un bareme

    @param string : le libelle du bareme
    @param integer : valeur pour reponse juste
    @param integer : valeur pour reponse fausse
    @param integer : valeur pour pas coch
    @param integer : valeur pour tout coch
*/
function set_bareme($libelle,$rep_juste,$rep_fausse,$pas_coche,$tout_coche){
    if(VERSION_BASE>VERSION){
        print(" set_bareme A implmenter...");
    }
    else
        $res=set_bareme_old($libelle,$rep_juste,$rep_fausse,$pas_coche,$tout_coche);
    return $res;
}

/**
    Obtenir les infos d'un bareme (OLD)

    @param integer : le numero du bareme
    @param integer : le resultat de la requete
*/
function get_bareme_infos_old($bareme){
    $sql="SELECT libelle_bareme,repok,repnotok,pascoche FROM BAREME WHERE num_bareme=$bareme";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'un bareme

    @param integer : le numero du bareme
    @param integer : le resultat de la requete
*/
function get_bareme_infos($bareme){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_bareme_infos_old($bareme);
    return $res;
}

/**
    Obtenir les infos d'un bareme (OLD)

    @param integer : le numero du bareme
    @param integer : le resultat de la requete
*/
function get_bareme_old($bareme){
    $sql="SELECT * FROM BAREME WHERE num_bareme=$bareme";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'un bareme

    @param integer : le numero du bareme
    @param integer : le resultat de la requete
*/
function get_bareme($bareme){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_bareme_old($bareme);
    return $res;
}

/**
	Supprime un bareme (OLD)

 	@param integer : le numero du bareme
 	@return integer : le resultat de la requete
*/
function del_bareme_old($bareme){
	$sql="delete from bareme where num_bareme=$bareme";
 	return (pg_query($sql));
}
/**
	Supprime un bareme

 	@param integer : le numero du bareme
 	@return integer : le resultat de la requete
*/
function del_bareme($bareme){
	 if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=del_bareme_old($bareme);
    return $res;
}

/**
	Mettre  jour un bareme (OLD)
	
	@param integer : le numero du bareme
	@param integer : valeur pour reponse juste
	@param integer : valeur pour reponse fausse
	@param integer : valeur pour pas coche
	@param integer : valeur pour tout coche
	@return integer : le resultat de la requete
*/
function maj_bareme_old($bareme,$libelle,$rep_juste,$rep_fausse,$pas_coche,$tout_coche){
	$sql="update bareme set libelle_bareme='$libelle',repok=$rep_juste,repnotok=$rep_fausse,
				pascoche=$pas_coche,toutcoche=$tout_coche where num_bareme=$bareme";
	return (pg_query($sql));
}
/**
	Mettre  jour un bareme (OLD)
	
	@param integer : le numero du bareme
	@param integer : valeur pour reponse juste
	@param integer : valeur pour reponse fausse
	@param integer : valeur pour pas coche
	@param integer : valeur pour tout coche
	@return integer : le resultat de la requete
*/
function maj_bareme($bareme,$libelle,$rep_juste,$rep_fausse,$pas_coche,$tout_coche){
	 if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_bareme_old($bareme,$libelle,$rep_juste,$rep_fausse,$pas_coche,$tout_coche);
    return $res;
}
?>