<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

 /**
  LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL

  Ce fichier contient toutes les fonctions necessaires  l'interrogation des bd pour les
 statistiques . Chacunes de ces fonctions  2 fonctions quivalentes: l'une prefix par
 _af_ en base, et l'autre suffux par _old dans le script.

 CONVENTION PROPOSEE:

 Le maximum des requetes SQL doivent etre ecritent sous la forme de fonctions
 en PLPGSQL en base, c'est a dire la totalit des requetes retournant  une valeur.

 Les requetes retournant plusieurs lignes ne pouvant etre traites ainsi, elles doivent
 tre ecrite sous la forme de fonctions PHP qui retournent une variable resultat (pg_exec)


 CONVENTION DE NOMAGE :
 Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
 PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
  la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
 Exemple:

 la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base
       @package blanc
       @modulegroup plpgsql
       @module plpgsql_blanc
*/



/*-----------------------------------------------------------------------------------------*/
//                         LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL
/*-----------------------------------------------------------------------------------------*/
/*
                            DOIVENT RETOURNER UNE VARIABLE
*/
/*
CONVENTION DE NOMAGE :
Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
 la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
Exemple:

la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base

*/

/**
    Verifie si un exercice "remplir les blancs" est utilis (OLD)
*
*   @param integer : le numero de l'exercice
*   @return bool : true =utilis
*/
function check_blanc_utilise_old($blanc){
    $sql="SELECT COUNT(*) FROM asso_exo_serie WHERE type_exo='f' AND id_exo=$blanc";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    if($row[0]>0)
        return true;
    return false;
}
/**
    Verifie si un exercice "remplir les blancs" est utilis
*
*   @param integer : le numero de l'exercice
*   @return bool : true =utilis
*/
function check_blanc_utilise($blanc){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=check_blanc_utilise_old($blanc);
    return $res ;
}

/**
    Enregistre un exercice "remplir les blanc" (OLD)
*
*   @param integer : le numero du theme
*   @param varchar : le texte
*   @param bool : true=voir les mots
*   @param bool : true=interpretation html
*   @return integer : le resultat de la requete
*/
function set_blanc_old($theme,$texte,$voir_mot,$inter_html){
     $sql="INSERT INTO gest_ftb (theme,text,show_word, inter_html) VALUES($theme,'$texte','$voir_mot', '$inter_html')";
     $ins=pg_query($sql);
     return $ins;
}
/**
    Enregistre un exercice "remplir les blanc"
*
*   @param integer : le numero du theme
*   @param varchar : le texte
*   @param bool : true=voir les mots
*   @param bool : true=interpretation html
*   @return integer : le resultat de la requete
*/
function set_blanc($theme,$texte,$voir_mot,$inter_html){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=set_blanc_old($theme,$texte,$voir_mot,$inter_html);
    return $res ;
}

/**
    Modifier un exercice "remplir les blanc" (OLD)
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero du theme
*   @param varchar : le texte
*   @param bool : true=voir les mots
*   @param bool : true=interpretation html
*   @return integer : le resultat de la requete
*/
function maj_blanc_old($blanc,$theme,$texte,$voir_mot,$inter_html){
     $sql="UPDATE gest_ftb SET text='$texte', show_word='$voir_mot', theme=$theme, inter_html='$inter_html' WHERE id=$blanc";
     //echo "sql=$sql<br>";
     $maj=pg_query($sql);
     return $maj;
}
/**
    Modifier un exercice "remplir les blanc"
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero du theme
*   @param varchar : le texte
*   @param bool : true=voir les mots
*   @param bool : true=interpretation html
*   @return integer : le resultat de la requete
*/
function maj_blanc($blanc,$theme,$texte,$voir_mot,$inter_html){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_blanc_old($blanc,$theme,$texte,$voir_mot,$inter_html);
    return $res ;
}

/**
    Obtenir les infos d'un exercice remplir les blancs (OLD)

    @param integer : le numero de l'exercice
    @return integer : le resultat de la requete
*/
function get_blanc_infos_old($blanc){
    $sql="SELECT * FROM gest_ftb WHERE id=$blanc";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'un exercice remplir les blancs

    @param integer : le numero de l'exercice
    @return integer : le resultat de la requete
*/
function get_blanc_infos($blanc){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_blanc_infos_old($blanc);
    return $res ;
}

/**
    Supprimer un exercice remplir les blancs (OLD)
*
*   @param integer : le numero de l'exercice
*   @return integer : le resultat de la requete
*/
function del_blanc_old($blanc){
    $sql="DELETE FROM gest_ftb WHERE id=$blanc";
    $del=pg_query($sql);
    return $del;
}
/**
    Supprimer un exercice remplir les blancs
*
*   @param integer : le numero de l'exercice
*   @return integer : le resultat de la requete
*/
function del_blanc($blanc){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=del_blanc_old($blanc);
    return $res ;
}

/**
    Obtenir les series pour un exercices "remplir les blancs" donn (OLD)
*
*   @param integer : le numero de l'exercice
*   @param string : ordre pour le tri (ex : desc)
*   @return integer : le resultat de la requete
*/
function get_blanc_series_old($blanc,$desc=""){
    $sql="SELECT DISTINCT id_serie,titre FROM asso_exo_serie A,serie_exo S WHERE id_exo=$blanc AND A.id_serie=S.id
                AND type_exo='f' ORDER BY titre $desc";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les series pour un exercices "remplir les blancs" donn
*
*   @param integer : le numero de l'exercice
*   @param string : ordre pour le tri (ex : desc)
*   @return integer : le resultat de la requete
*/
function get_blanc_series($blanc,$desc=""){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_blanc_series_old($blanc,$desc);
    return $res ;
}

/**
    Obtenir les numros et libelles des formations pour un "remplir les blanc" (OLD)
*
*   @param integer : le numero de l'exercice
*   @param string : ordre pour le tri (ex : desc)
*   @return integer : le resultat de la requete
*/
function get_blanc_formations_old($blanc,$desc=""){
    $sql="SELECT DISTINCT C.num_cal, C.nom_cal FROM gestparcours G1,gestionparcours G2, calendrier C WHERE num_c_q_e_d IN
                (SELECT DISTINCT id_serie FROM asso_exo_serie A WHERE id_exo=$blanc AND type_exo='f')
                AND type_etape='B' AND gp_num_parcours=g_num_parcours AND G2.num_cal=C.num_cal ORDER BY C.nom_cal $desc";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les numros et libelles des formations pour un "remplir les blanc"
*
*   @param integer : le numero de l'exercice
*   @param string : ordre pour le tri (ex : desc)
*   @return integer : le resultat de la requete
*/
function get_blanc_formations($blanc,$desc=""){
     if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_blanc_formations_old($blanc,$desc);
    return $res ;
}

/**
    Obtenir les titre de series pour un exercice (blenc) et une formation donns (OLD)
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_blanc_series_formation_old($blanc,$formation){
    $sql="SELECT DISTINCT titre FROM serie_exo, asso_exo_serie WHERE id IN
                (SELECT num_c_q_e_d FROM gestionparcours, gestparcours WHERE gp_num_parcours=g_num_parcours AND num_cal=$formation)
                AND id=id_serie AND id_exo=$blanc ORDER BY titre";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les titre de series pour un exercice (blanc) et une formation donns
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero de formation
*   @return integer : le resultat de la requete
*/
function get_blanc_series_formation($blanc,$formation){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_blanc_series_formation_old($blanc,$formation);
    return $res ;
}

/**
    Obtenir les sries qui ne sont pas dans un parcours pour un exercice "blanc" donn (OLD)
*
*   @param integer : le numero de l'exercice
*   @return integer : le resultat de la requete
*/
function get_blanc_series_sans_parcours_old($blanc){
    $sql="SELECT DISTINCT titre FROM asso_exo_serie A,serie_exo S WHERE id_exo=$blanc AND A.id_serie=S.id AND S.id NOT IN
                (SELECT num_c_q_e_d FROM gestparcours where type_etape='B') AND type_exo='f' ORDER BY titre";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les sries qui ne sont pas dans un parcours pour un exercice "blanc" donn
*
*   @param integer : le numero de l'exercice
*   @return integer : le resultat de la requete
*/
function get_blanc_series_sans_parcours($blanc){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_blanc_series_sans_parcours_old($blanc);
    return $res ;
}

/**
    Obtebir les groupes qui utilisent l'exo blanc donn (OLD)
*
*   @param integer : le numero de l'exercice
*   @param string : ordre pour le tri (ex : desc)
*   @return integer : le resultat de la requete
*/
function get_blanc_groupes_old($blanc,$desc=""){
    $sql="SELECT DISTINCT C.id, C.nom FROM gestparcours G1,gestionparcours G2, classe C WHERE num_c_q_e_d IN
                (SELECT id_serie FROM asso_exo_serie WHERE id_exo=$blanc AND type_exo='f') AND type_etape='B'
                AND gp_num_parcours=g_num_parcours AND G2.gp_num_groupe=C.id ORDER BY C.nom $desc";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtebir les groupes qui utilisent l'exo blanc donn
*
*   @param integer : le numero de l'exercice
*   @param string : ordre pour le tri (ex : desc)
*   @return integer : le resultat de la requete
*/
function get_blanc_groupes($blanc,$desc=""){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_blanc_groupes_old($blanc,$desc);
    return $res ;
}

/**
    Obtenir les formations pour un groupe et un exo blanc donns (OLD)
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero du groupe
*   @return integer :  le resultat de la requete
*/
function get_blanc_formations_groupe_old($blanc,$groupe){
     $sql="SELECT DISTINCT C.num_cal, C.nom_cal FROM gestparcours G1,gestionparcours G2, calendrier C WHERE num_c_q_e_d IN
                (SELECT DISTINCT id_serie FROM asso_exo_serie A WHERE id_exo=$blanc AND type_exo='f') AND type_etape='B'
                AND gp_num_groupe=$groupe AND gp_num_parcours=g_num_parcours AND G2.num_cal=C.num_cal ORDER BY C.nom_cal";
     $res=pg_query($sql);
     return $res;
}
/**
    Obtenir les formations pour un groupe et un exo blanc donns
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero du groupe
*   @return integer :  le resultat de la requete
*/
function get_blanc_formations_groupe($blanc,$groupe){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_blanc_formations_groupe_old($blanc,$groupe);
    return $res ;
}
?>