<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
Cette classe dcrit une capacitz

@author LADJANI said <sladjani@afide.fr>
@since 29/03/2005

@package capacite
*/
class Capacite
{

        /**
        * @var integer : Identifiant en base de donnes
        */
        var $id ;

        /**
        * @var string : Libell de la capacit
        */
        var $libelle ;

        /**
        * @var integer : numro de thme
        */
        var $num_theme ; //  l'avenir theme = new Theme(...)




        /**
        * Constructeur de la classe Capacite.
        * 
        * @param integer : identifiant de l'enregistrement en BD ou libll (string)
        * @param integer : identifiant du thme en base de donnes
        */
        function Capacite($num_ou_lib, $theme=0)
        {
            // On determine le type du paramtre  l'aide d'une expression regulire (on reoit toujours une String en php si c'est une rsultat de BD)
                $une_chaine  = ereg("[^0-9]",$num_ou_lib) ;

                // Deux constructions diffrentes selon le type du paramtre ( refaire le jour o on pourra surcharger les fonctions !!!)
                if(!$une_chaine)
                {
                        $this->id = $num_ou_lib ;
                        // echo "Class Salle : constructeur avec identifiant<br>" ;
                        /*
                        $requete="SELECT * FROM capacite WHERE num_capacite=$num_ou_lib" ;
                        //debug
                        //echo "req=$requete<br>";
                        $result=pg_query($requete) ;
                        */
                        $result=get_capacite($num_ou_lib);
                        $row=pg_fetch_row($result) ;
                        $this->libelle = $row[1] ;
                        //$this->num_theme = $row["theme"] ;
						$restheme=get_capacite_themes(10,$num_ou_lib);
						$this->num_theme=pg_fetch_result($restheme,0,0);

                }
                // Construction  partir d'un nom
                else
                {
                       $this->libelle = $num_ou_lib ;
                       $this->num_theme = $theme;
                }
                
        }
        // ------------------------------------------------------------------------------------------------------------------- fin Capacite()

        /**
        * Fonction qui insre un enregistrement en table capacite et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                // On n'insre une ligne que si l'organisme n'existe pas dj
                if($this->libelle=="")
                {
                        return (-110) ; // libell vide
                }
                // Le libell est correcte
                else
                {
                        //$lib=addslashes($this->libelle) ;
                        $lib=$this->libelle ;
                        // Cet organisme existe-il dj ?
                        //if(pg_num_rows(pg_query("SELECT num_capacite FROM capacite WHERE libelle_capacite='$lib'"))>0)
                        if(check_capacite($lib,$this->num_theme))
                        {
                                return (-111);  // organisme existe dj
                        }
                        else
                        {
                                //$insertion = "INSERT INTO capacite (libelle_capacite,theme) VALUES ('$lib','".$this->num_theme."')" ;
                                $insertion=set_capacite(set_ams_libelle($lib),$this->num_theme);

                                // On retourne un boolen
                                //if($res = pg_query($insertion))
                                if($insertion)
                                {
                                        /*
                                        $tmp = pg_result(pg_query("SELECT num_capacite FROM capacite WHERE libelle_capacite='$lib'"),0,0) ;
                                        // on retourne l'identifiant de la ligne cre
                                        return($tmp);
                                        */
                                        return $insertion;
                                }
                                else
                                        return (-1) ; // Problme requte
                        }
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table capacite
        *
        * Fonction qui met  jour l'enregistrement en table capacite
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */
        function updateToDB()
        {
                // Il faut que l'identifiant soit connu
                if($this->id != 0)
                {
                        //$update = "UPDATE capacite SET libelle_capacite = '".addslashes($this->libelle)."' WHERE num_capacite=$this->id" ;
                        //$lib=addslashes($this->libelle) ;
                        $lib=$this->libelle ;
                        $update=maj_capacite($this->id,set_ams_libelle($lib));

                        // echo "Class Titrecapacite : updateToDB. Requete =<br>$update<br>" ;

                        // On retourne un boolen
                        //if(pg_query($update))
                        if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin updateToDB()

        /**
        * Procdure qui supprime l'enregistrement en base
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */
        function deleteToDB(){
            // Il faut que l'identifiant soit connu
            if($this->id != 0){

                // suppression de la grille
                if(del_capacite($this->id)){
                    return true;
                }
                else
                    return -1;  // erreur base de donnes
            }
            else{
                // Identifiant inconnu : suppression impossible
                return -2;
            }
        }
         // ------------------------------------------------------------------------------------------------------------------- fin deleteToDB()

		/**
		 * Affiche des informations sur l'objet.
		 * 
		 * @param string format de l'affichage dsir
		 * @return string la chaine d'information.
		 */
        function toString($format="")
        {
                // Aucun paramtre, on retourne le titre de la srie
                if($format=="")
                        return $this->libelle ;

                // Ce tableau contient tous les pattern et les nouvelles valeurs
                $tab_replace = array("\[libelle\]"=>"$this->libelle","\[id_capacite\]"=>"$this->id","\[num_theme\]"=>"$this->num_theme") ;

                while($tab=each($tab_replace))
                        $format = ereg_replace($tab[0],$tab[1],$format) ;

                return $format ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin toString($format)

        function getId() { return $this->id ; }
        function getNumTheme() { return $this->num_theme ; }

}
?>