<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package capacite
 * @modulegroup plpgsql
 * @module plpgsql_capacite
 */

/**
*   Vrifier si un nom de capacite est unique pour un mme thme  (OLD)
*
*   @param integer : numero du theme
*   @param string : nom de la capacite
*   @return integer : numero de la capacite si existe, 0 sinon
*/
function check_capacite_old($libelle_capacite,$theme){
    $sql="select * from capacite where libelle_capacite='$libelle_capacite' and theme=$theme";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
*   Vrifier si un nom de capacite est unique pour un mme thme
*
*   @param integer : numero du theme
*   @param string : nom de la capacite
*   @return integer : numero de la capacite si existe, 0 sinon
*/
function check_capacite($libelle_capacite,$theme){
    if(VERSION_BASE>VERSION){
        //print("A IMPLEMENTER");
		// Pas tester pour le moment
		return false;
    }
    else
        return check_capacite_old($libelle_capacite,$theme);
}

/**
*   Supprimer une capacite.  (OLD)
*
*   Supprime la capacite

*
*   @param integer : numero de capacite  supprimer
*   @return integer : 1
*/
function del_capacite_old($capacite){


    // suppression du titre de capacite
    $del=pg_query("delete from capacite where num_capacite=$capacite;");

    return 1;
}

/**
*   Supprimer une capacite.
*
*   Supprime la capacite
*
*   @param integer : numero de capacite  supprimer
*   @return integer : 1
*/
function del_capacite($capacite){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_capacite($capacite)";
		$res=pg_query($sql);
	}
	else
		$res=del_capacite_old($capacite);
	return ($res);
}

/**
    Verifie si une capacite est utilise (OLD)

    @param integer : le numero de la capacite
    @return bool : true si utlis , false sinon
*/
function check_capacite_utilisee_old($capacite){
    $sql="select * from titrecapa where tr_num_capacite=$capacite";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    else
        return true;
}
/**
    Verifie si un titrecapacite est utilis

    @param integer : le numero de la capacite
    @return bool : true si utlis , false sinon
*/
function check_capacite_utilisee($capacite){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        return check_capacite_utilisee_old($capacite);
}

/**
	Obtenir les infos d'une capacite (OLD)
    @deprecated : utiliser get_capacite
	@param integer : le numero de la capacite
 	@return integer : le resultat de la requete
*/
function get_capacite_infos_old($capacite){
	$sql="select * from capacite where num_capacite=$capacite";
 	return (pg_query($sql));
}
/**
	Obtenir les infos d'une capacite
	@deprecated : utiliser get_capacite
	@param integer : le numero de la capacite
 	@return integer : le resultat de la requete
*/
function get_capacite_infos($capacite){
	 if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        return get_capacite_infos_old($capacite);
}

/**
    Enregitre une capacite (OLD)

    @param string : le nom de la capacite
    @param integer : le numero du theme
    @return integer : le numero de la capacite, 0 si erreur
*/
function set_capacite_old($libelle,$theme){
    $sql="INSERT INTO capacite (libelle_capacite,theme) VALUES ('$libelle',$theme)" ;
    $ins=pg_query($sql);
    if($ins){
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_capacite from capacite where oid=$oid");
        return pg_fetch_result($res, 0, 0);
    }
    else
        return 0;
}
/**
    Enregitre une capacite

    @param string : le nom de la capacite
    @param integer : le numero du theme
    @return integer : le numero de la capacite, 0 si erreur
*/
function set_capacite($libelle,$theme){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_capacite('$libelle')";
		$res=pg_query($sql);
		// enregistre dans theme_categories
		set_categorie_element_theme(10, $theme, pg_fetch_result($res, 0, 0));
		return pg_fetch_result($res, 0, 0);
    }
    else
        return set_capacite_old($libelle,$theme);
}

/**
    Mettre  jour une capacite (OLD)

    @param integer : le numero de la capacite
    @param string : le nom de la capacite
    @return integer : le resultat de la requete
*/
function maj_capacite_old($capacite,$libelle){
    $sql="UPDATE capacite SET libelle_capacite = '$libelle' WHERE num_capacite=$capacite" ;
    return pg_query($sql);
}
/**
    Mettre  jour une capacite

    @param integer : le numero de la capacite
    @param string : le nom de la capacite
    @return integer : le resultat de la requete
*/
function maj_capacite($capacite,$libelle){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_capacite($capacite,'$libelle')";
		$res=pg_query($sql);
    }
    else
        return maj_capacite_old($capacite,$libelle);
	return $res;
}

/**
	Obtenir les infos d'une capacite (OLD)
    
	@param integer : le numero de la capacite
 	@return integer : le resultat de la requete
*/
function get_capacite_old($capacite){
	$sql="select * from capacite where num_capacite=$capacite";
 	return (pg_query($sql));
}
/**
	Obtenir les infos d'une capacite
	
	@param integer : le numero de la capacite
 	@return integer : le resultat de la requete
*/
function get_capacite($capacite){
	 if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_capacite($capacite) as (id int4,libelle varchar)";
		$res=pg_query($sql);
    }
    else
        return get_capacite_old($capacite);
	return $res;
}

/**
	Obtenir les themes d'une capacite   (OLD)
	@param integer : numero categorie
	@param integer : numero capacite
	@return integer resultat requete
*/
function get_capacite_themes_old($capacite){
	 $sql="select distinct num_themedir,nom_theme from themedir where num_themedir in 
				(select theme from capacite where num_capacite=$capacite)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les themes d'une capacite   
	@param integer : numero categorie
	@param integer : numero capacite
	@return integer resultat requete
*/
function get_capacite_themes($categorie,$capacite){
	if(VERSION_BASE>VERSION){
		$res=get_categorie_element_themes($categorie,$capacite);
	}
	else
		return get_capacite_themes_old($capacite);
	return $res;
}

/**
	Teste si une capacite est supprimable (OLD)
	@param integer : numero capacite
	@return bool : true supprimable, false non supprimable
*/
function check_capacite_supprimable_old($capacite){
	 $sql="select * from titrecapa where tr_num_capacite=$capacite";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    else
        return true;
}
 /**
	Teste si une capacite est supprimable
	@param integer : numero capacite
	@return bool : true supprimable, false non supprimable
*/
function check_capacite_supprimable($capacite){
	if(VERSION_BASE>VERSION){
		 $res=!fk_finder('capacite','id',$capacite);
	}
	else
		$res=check_capacite_supprimable_old($capacite);
	return $res;
}
?>
