<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * 
 * @author Cocquet R�mi
 * @since 03/03/2006
 * @package categorie 
 */
class Categorie {

    /**
    * @var integer  Identifiant en base de donn�es
    */
	var $id;

	/**
	 * @var string  Lib�ll� de la cat�gorie
	 */
	var $libelle;

	/**
	 * @var string Nom de la table de la base de donn�es concern�e par la cat�gorie.
	 */
	var $table_cible;

	/**
	 * @var bool Indique si la cat�gorie apparait ou non dans le gestionnaire de contenus.
	 */
	var $gestionnaire_contenu;
	
	/**
	 * @var string Indique si la cat�gorie correspond � une �tape.
	 */
	var $table_etape;

	/**
	* Constructeur de la classe.
	* 
	* @param string $num_ou_lib identifiant de l'enregistrement en BD 
	* @param string $libelle_ou_table_cible lib�ll�
	* @param string $table_cible_ou_gestionnaire_contenu apparition dans le gestionnaire de contenus
	* @param string $gestionnaire_contenu_ou_table_etape libell� de la table cible
	* @param string $table_etape libell� de la table �tape
	*/
	function Categorie($num_ou_lib, $libelle_ou_table_cible = "", $table_cible_ou_gestionnaire_contenu = "", $gestionnaire_contenu_ou_table_etape = "", $table_etape="") {

			//soit on constuit un objet dont on dispose de toutes les donn�es
	if (func_num_args() == 5) {
			$this->id = $num_ou_lib;
			$this->libelle = $libelle_ou_table_cible;
			$this->table_cible = $table_cible_ou_gestionnaire_contenu;
			if ($gestionnaire_contenu_ou_table_etape == "f")
				$this->gestionnaire_contenu = false;
			else
				$this->gestionnaire_contenu = true;
				$this->table_etape = $table_etape;
			return;
		}
		//sinon on lit les donn�es en base ou on construit un nouvel objet

		//si on a que le numero on lit les donn�es en base
		if (func_num_args() == 1) {
			$this->id = $num_ou_lib;
			$res = get_categorie($num_ou_lib);
			$row=pg_fetch_row($res);
			$this->libelle = $row[1];
			$this->table_cible =  $row[2];
			$this->gestionnaire_contenu = sql2Bool($row[3]);
			$this->table_etape =  $row[4];
//			if (pg_result($res, 0, 3) == "f")
//				$this->gestionnaire_contenu = false;
//			else
//				$this->gestionnaire_contenu = true;
			return;
		}
		// Construction a partir d'un nom
		if (func_num_args() == 4) {  //avant modif : func_num_args() == 3, --> a re-tester
			$this->libelle = $num_ou_lib;
			$this->table_cible = $libelle_ou_table_cible;
			$this->gestionnaire_contenu = $table_cible_ou_gestionnaire_contenu;
			$this->table_etape = $table_etape;
			return;
		}

		//cas par d�faut
		print ("Erreur dans la construction de l'objet Categorie: le nombre de parametre est incorrect");
		return;
	}

	/**
	 * Obtenir l'identifiant en table de la cat�gorie
	 * 
	 * @return integer l'identifiant.
	 */
	function getId() {
		return $this->id;
	}

	/**
	 * Obtenir le lib�ll� de la cat�gorie tel qu'il sera affich� dans
	 * le gestionnaire de contenu
	 * 
	 * @return string le lib�ll�.
	 */
	function getLibelle() {
		//return htmlentities($this->libelle);
		return $this->libelle;
	}

	/**
	 * Obtenir le nom de la table correspondant � cette cat�gorie
	 * 
	 * @return string le lib�ll� de la table
	 */
	function getTableCible() {
		return $this->table_cible;
	}

	/**
	 *	Savoir si cette cat�gorie doit �tre affich�e dans le gestionnaire de contenu ou non.
	 *
	 * @return boolean true ou false
	 */
	function isGestionnaireContenu() {
		return $this->gestionnaire_contenu;
	}

	/**
	 * Affecte l'identifiant de la Categorie
	 * @param integer $id l'identifiant
	 */
	function setId($id) {
		$this->id = $id;
	}

	/**
	 * Affecte le lib�ll� de la Categorie
	 * @param string $libelle le lib�ll�
	 */
	function setLibelle($libelle) {
		$this->libelle = $libelle;
	}

	/**
	 * Affecte la table cible de la Categorie
	 * @param string $table_cible la table cible
	 */
	function setTableCible($table_cible) {
		$this->id = $table_cible;
	}

	/**
	 * Indique si la cat�gorie fait partie du gestionnaire de contenus ou non.
	 * @param bool $bool_value true ou false
	 */
	function setGestionnaireContenu($bool_value) {
		$this->gestionnaire_contenu = $bool_value;
	}

	/**
	 *Enregistre la Cat�gorie en base.
	 * @return integer L'identifiant de la Categorie ainsi cr�ee 
	 */
	function insertToDB() {
		return set_categorie(set_ams_libelle($this->libelle), $this->table_cible, $this->gestionnaire_contenu);
	}

	/**
	 * Modifie le lib�ll� d'une cat�gorie ou sa pr�sence dans le gestionnaire de contenu.
	 * La table_cible n'est pas modifiable.
	 * @return string  't' ou 'f' selon que la mise � jour ai �t� correctement effectu�e ou non 
	 */
	function updateToDB() {
		return maj_categorie($this->id, set_ams_libelle($this->libelle), $this->gestionnaire_contenu);
	}

	/**
	 * Supprime la cat�gorie et sa table associ�e sans supprimer son contenu
	 * @return string  't' ou 'f' selon que la suppression ai �t� correctement effectu�e ou non 
	 */
	function deleteToDB() {
		return del_categorie($this->id);
	}

	/**
	 * Affiche le libell� de la cat�gorie telle qu'il doit apparaitre dans les pages.
	 * @return string Le lib�ll� � afficher
	 */
	function toString() {
		return $this->libelle;
	}

	/**
	 *	Obtenir les �l�ments qui sont associ�s � la cat�gorie pour un theme
	 *	@param integer $theme le numero du theme
	 *	@return array: un tableau contenant les identifiants des �l�ments de la categorie
	 */
	function getElementsTheme($theme) {
		$elements = array ();
		$res_elements = get_categorie_elements_theme($this->id, $theme);
		$nb_elements = pg_numrows($res_elements);
		for ($i = 0; $i < $nb_elements; $i ++) {
			$elements[$i] = pg_result($res_elements, $i, 0);
		}
		return $elements;
	}

	/**
	 *	Obtenir les fichiers associ�s � une cat�gorie pour un th�me donn�
	 *	Les fichier sont tri�s par ordre alphab�tique selon leur libell�.
	 *
	 *	@param integer: l'identifiant du theme
	 *	@return array: un tableau contenant les identifiants des fichier de la categorie
	 */
	function getFichiersTheme($theme) {
		$fichiers = array ();
		$res_fichiers = get_categorie_fichiers_theme($this->id, $theme);	
		$nb_fichiers = pg_num_rows($res_fichiers);
		
		if (pg_num_fields($res_fichiers) > 4)
			$fichier_texte = true;
		for ($i = 0; $i < $nb_fichiers; $i ++) {
			$fichiers[$i][0] = pg_result($res_fichiers, $i, 0);
			$fichiers[$i][1] = pg_result($res_fichiers, $i, 1);
			if($this->id != TYPE_CATEGORIE_FICHIER_GLOSSAIRE){
			$fichiers[$i][2] = pg_result($res_fichiers, $i, 2);
			$fichiers[$i][3] = pg_result($res_fichiers, $i, 3);
			//s'il s'agit d'un fichier texte il y a plus d'infos � lire
			if ($fichier_texte) {
				$fichiers[$i][4] = pg_result($res_fichiers, $i, 4);
				$fichiers[$i][5] = pg_result($res_fichiers, $i, 5);
				$fichiers[$i][6] = pg_result($res_fichiers, $i, 6);
				$fichiers[$i][7] = pg_result($res_fichiers, $i, 7);
				$fichiers[$i][8] = pg_result($res_fichiers, $i, 8);
			}
			}
		}
		return $fichiers;
	}

	/**
	 * Ajouter un Fichier � la Cat�gorie
	 * 
	 * @param integer $fichier identifiant du fichier � ajouter
	 * @param boolean $connect 'TRUE' si le fichier est connect�, 'FALSE' sinon 
	 * @param integer $theme identifiant du Th�me du fichier � ajouter
	 * 
	 * @return string  't' ou 'f' selon que l'ajout ai �t� correctement effectu�e ou non  
	 */
	function setFichier($fichier, $connect, $theme) {
		return set_categorie_fichier_theme($fichier, $connect, $theme, $this->id);
	}

	/**
	 * Creer un fichier texte
	 * 
	 * @param string $libelle libelle du fichier texte
	 * @param string $titre titre du lien
	 * @param string $adresse adresse du lien
	 * @param string $description description
	 * @param string $mise_en_forme mise en forme
	 * @param bool $connecte connect� 
	 * @param integer $theme theme
	 * @return integer identifiant du nouveau fichier
	 */
	function setFichierTexte($libelle, $titre, $adresse, $description, $mise_en_forme, $connecte, $theme) {
		//return set_categorie_fichier_texte_theme(addslashes($libelle), addslashes($titre), addslashes($adresse), addslashes($description), addslashes($mise_en_forme), $connecte, $theme, $this->id);
		return set_categorie_fichier_texte_theme(set_ams_libelle($libelle), set_ams_libelle($titre), set_ams_libelle($adresse), set_ams_libelle($description), set_ams_libelle($mise_en_forme), $connecte, $theme, $this->id);
	
	}

	/**
	 * Met � jour les donn�es d'un fichier.
	 * Le lib�ll�, le type et la connexion du Fichier dont l'identifiant est sp�cifi� sont mis � jour.
	 * @param integer $id identifiant du Fichier � mettre � jour
	 * @param string $libelle Nouveau lib�ll� du Fichier 
	 * @param integer $type Nouveau type du Fichier
	 * @param string $connecte  Nouvel �tat de connection du Fichier ('TRUE' ou 'FALSE')
	 * 
	 * @return string  't' ou 'f' selon que la mise � jour  ai �t� correctement effectu�e ou non 
	 */
	function majFichier($id, $libelle, $connect, $theme=null) {
		return maj_fichier($id, addslashes($libelle), $connect, $theme, $this->id);
	}

	/**
	 * Met � jour les donn�ss d'un fichier texte.
	 * @param integer $id identifiant du Fichier Texte � mettre � jour
	 * @param string $libelle Nouveau lib�ll� du Fichier Texte
	 * @param string $titre Nouveau titre du Fichier Texte
	 * @param string $lien Nouveau lien du Fichier Texte
	 * @param string $description Nouvelle description du Fichier Texte
	 * @param string $mise_en_forme Nouvelle mise en forme du Fichier Texte
	 * @param string $connecte  Nouvel �tat de connection du Fichier Texte('TRUE' ou 'FALSE')
	 * 
	 * @return string  't' ou 'f' selon que la mise � jour  ai �t� correctement effectu�e ou non 
	 */
	function majFichierTexte($id, $libelle, $titre, $lien, $description, $mise_en_forme, $connecte) {
		//return maj_fichier_texte($id, addslashes($libelle), addslashes($titre), addslashes($lien), addslashes($description), addslashes($mise_en_forme), $connecte);
		return maj_fichier_texte($id, set_ams_libelle($libelle), set_ams_libelle($titre), set_ams_libelle($lien), set_ams_libelle($description), set_ams_libelle($mise_en_forme), $connecte);
		
	}

	/**
	 * Supprime un fichier de la cat�gorie.
	 * @param integer $id identifiant du fichier � supprimer de la cat�gorie.
	 * @return string  't' ou 'f' selon que la suppression ai �t� correctement effectu�e ou non 
	 */
	function delFichier($id) {
		return del_categorie_fichier($id);
	}

	/**
	 * Supprime un �l�ment de la cat�gorie.
	 * @param integer $id identifiant de l'�l�ment � supprimer de la cat�gorie.
	 * @return string  't' ou 'f' selon que la suppression ai �t� correctement effectu�e ou non
	 */
	function delElement($id) {
		return del_categorie_element($this->id, $id);
	}

	/**
	 * Obtenir un nom de fichier unique pour un theme et une categorie.
	 * Si le nom de fichier est deja unique, retourne le meme nom que celui passe
	 * en parametre, sinon, retourne le nom suffixe d'un numero entre parenthese.
	 * Ce numero est un indice calcule en fonction des fichiers ayant le meme nom avant
	 * leur passage par cette fonction.
	 * 
	 * @param string $nomfichier le nom du fichier (exemple: monfichier.txt)
	 * @param integer $theme identifiant du theme
	 * @param integer $id facultatif, l'identifiant du fichier modifi�
	 * @return string : le nom du fichier si unique, le nom du fichier suffixe d'un numero sinon.(exemple: monfichier.txt, monfichier(1).txt, monfichier(2).txt, etc...)
	 */
	function getFichierUniqueName($nomfichier, $theme, $id = 0) {
		$nouveau_num = 0;

		//les fichiers sont tri�s par ordre alphab�tique! ne pas modifier ce tris!!!
		$fichiers = $this->getFichiersTheme($theme);
		$nb_fichiers = count($fichiers);
		$trouve = false;
		for ($i = $nb_fichiers -1; $i >= 0; $i --) {
			//on cherche un fichier de meme nom
			if ((strcmp($nomfichier, $fichiers[$i][1]) == 0) && (empty ($id) || ($fichiers[$i][0] != $id))) {
				$trouve = true;
				//echo "trouve: ".$nomfichier.",". $fichiers[$i][0]."!=$id<br>";
				break;
			}
		}

		$i --;
		//on cherche si les mots suivants sont le mot trouv� avec  (1) , (2), ....
		if ($trouve) {
			//on recupere le nom sans l'extension
			$nom = get_fichier_name($nomfichier);
			//on recupere l'extension
			$extension = get_fichier_extension($nomfichier);
			//print("nom=$nom extension=$extension<br>");
			//on test si on trouve le nom du fichier avec  (1) , (2), ....
			$encore_trouve = false;

			for ($j = $i; $j >= 0; $j --) {
				//print("on cherche: ".$fichiers[$j][1]." avec ".$nomfichier." ");
				if (ereg("([^\(]*)\(([0-9]+)\)\.([^.]*)$", $fichiers[$j][1], $capt)&&(empty ($id) || ($fichiers[$i][0] != $id))) {

					//on verifie que le nom et l'extension de la chaine match� sont bien les bons
					if (($capt[1] == $nom) && ($capt[3] == $extension)) {
						//on stocke le numero trouv�
						if ($nouveau_num < $capt[2])
							$nouveau_num = $capt[2];
						$encore_trouve = true;
						//echo "encoretrouve<br>".$capt[0];
					} else {
						//on sort si pas le bon nom
						//echo ("qui n'a pas le bon nom:".$nom.".".$extension."!=".$capt[1].".".$capt[3]."<br>");
						break;
					}
				} else {
					//on sort si pas la bonne structure
					//echo("qui ne match pas<br>");
					break;
				}
			}
		}
		if ($trouve) {
			$nomfichier = $nom."(". ($nouveau_num +1).")".".$extension";
		}
		//print("<br>le nouveau nom sera: ".$nomfichier."<br>");
		return $nomfichier;
	}

	/**
	 * 	Obtenir un nom de fichier texte unique pour un theme et une categorie.
	 * 	Si le nom de fichier texte est deja unique, retourne le meme nom que celui passe
	 * 	en parametre, sinon, retourne le nom suffixe d'un numero entre parenthese.
	 * 	Ce numero est un indice calcule en fonction des fichiers ayant le meme nom avant
	 * 	leur passage par cette fonction.
	 * 	Le parametre facultatif permet de pr�ciser un num�ro de fichier en cas de modification, afin que le
	 * 	libelle du fichier modifi� ne soit pas modifi� inutilement.
	 * 	@param string $nomfichier le nom du fichier  texte (exemple: monfichier)
	 * 	@param integer $theme identifiant du theme
	 * 	@param integer $id facultatif, l'identifiant du fichier modifi�
	 * 	@return string  Le nom du fichier  texte si unique, le nom du fichier  texte suffixe d'un numero sinon.(exemple: monfichier, monfichier(1), monfichier(2), etc...)
	 */
	function getFichierTexteUniqueName($nomfichier, $theme, $id = 0) {
		$nouveau_num = 0;
		//constuction de l'ereg
		$p_nomfichier = str_replace("(", "\(", $nomfichier);
		$p_nomfichier = str_replace(")", "\)", $p_nomfichier);
		$find = $p_nomfichier.'\(([0-9]+)\)$';

		//les fichiers sont tri�s par ordre alphab�tique! ne pas modifier ce tris!!!
		$fichiers = $this->getFichiersTheme($theme);
		$nb_fichiers = count($fichiers);
		for ($i = 0; $i < $nb_fichiers; $i ++) {
			//on cherche le meme nom exactement
			if ($nouveau_num == 0) {
				//echo" (".$fichiers[$i][1]." ==". $nomfichier.") && (".empty($id)." || ".$fichiers[$i][0]."!=".$id." )<br>";
				if (($fichiers[$i][1] == $nomfichier) && (empty ($id) || ($fichiers[$i][0] != $id))) {
					$nouveau_num ++;
				}
			} else {
				//on cherche le meme nom avec (num)
				//echo" ereg($find, ".$fichiers[$i][1]."<br>";
				if (ereg($find, $fichiers[$i][1], $capt)) {
					//echo "ok<br>";
					//si num est plus grand que  nouveau_num, on prend nouveau_num +1 comme nouvel indice
					if ($nouveau_num <= $capt[1]) {
						$nouveau_num = ($capt[1] + 1);
					} else
						break;
				}
			}
		}
		if ($nouveau_num != 0)
			return $nomfichier."(". ($nouveau_num).")";
		else
			return $nomfichier;
	}
	
	/**
	 * Affecter la valeur de l'attribut is Etape.
	 * Seul l'appel � cette methode permet d'affecter cette valeur, cela n'est pas
	 * fait par le contructeur.
	 * @return bool true si la categorie est une categorie d'�tapes, false sinon.
	 */
	function getTableEtape(){
		return $this->table_etape;
	}

	/**
	 * Savoir si cette gategorie correspond � une categorie d'�tape ou non.
	 * @return bool true si la categorie est une categorie d'�tape, false sinon.
	 */
	function isEtape(){
		return $this->table_etape!=null;
	}	
	
/**
 * Cre un glossaire
 * @param string $libelle libelle du glossaire
 * @return integer identifiant du nouveau glossaire
 */
 function setFichierGlossaire($libelle,$theme){
 	return set_categorie_fichier_glossaire_theme(set_ams_libelle($libelle),$theme,$this->id);	
 }
}
?>