<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package categorie
 * @modulegroup plpgsql
 * @module plpgsql_categorie
 */

/**
 *	Cr�e une nouvelle cat�gorie.
 *	La cr�ation d'une cat�gorie entraine un enregistrement dans la table categorie, et si le 
 *	parametre $table_cible, est diff�rent de NULL, cr�e une table nomm�e "categorie_$table_cible".
 *	Dans ce cas, la cat�gorie corespond � une table. Si $table_cible est NULL, la cat�gorie correspond � un r�pertoire
 *	sur le disque.
 *	@param String $libelle le libell� de la cat�gorie
 *	@param String $table_cible: le nom d'une table qui existe
 *	@param bool $gestionnaire_contenu indique si cette cat�gorie doit apparaitre dans le gestionnaire de contenus.
 *	@return bool: indique si la cr�ation a �t� effectu�e
 */
function set_categorie($libelle, $table_cible, $gestionnaire_contenu) {
	if ($table_cible == null) {
		$table_cible = "NULL";
	}
	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_set_categorie($libelle, $table_cible, $gestionnaire_contenu) ";
		$res = pg_query($req);

	} else {
		print ("La fonction set_categorie($libelle, $table_cible, $gestionnaire_contenu) n'existe pas pour la version " . VERSION);
	}

	return pg_result($res, 0, 0);
}

/**
 *	Supprime la cat�gorie dont le nom est pass� en paramettre.
 *	Cela entraine la suppression de tous les enregistements concernat cette cat�gorie
 *	et la table qui y est associ�e.
 *	Le contenu de la cat�gorie n'est pas supprim�.
 *	@param Integer $id le num�ro de la cat�gorie � supprimer
 *	@return bool: true si la categorie a ete supprimee, false sinon. 
 */
function del_categorie($id) {

	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_del_categorie($id) ";
		$res = pg_query($req);

	} else {
		print ("La fonction del_categorie($id) n'existe pas pour la version " . VERSION);
	}

	return pg_result($res, 0, 0);
}

/**
 *	Modifie le libell� d'une cat�gorie ainsi que �a pr�sence dans le gestionnaire de contenu
 *	@param Integer $id le num�ro de la cat�gorie � modifier
 *	@param String $libelle le lib�ll� de la cat�gorie
 *	@param bool $gestionnaire_contenu TRUE si la cat�gorie doit apparaitre dans le gestionnaire de contenu, FALSE sinon.
 *	@return bool: true si la categorie a ete supprimee, false sinon. 
 */
function maj_categorie($id, $libelle, $gestionnaire_contenu) {

	if ($gestionnaire_contenu) {
		$gestionnaire_contenu = "TRUE";
	} else {
		$gestionnaire_contenu = "FALSE";
	}
	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_maj_categorie($id, '$libelle', $gestionnaire_contenu)";
		//echo $req;
		$res = pg_query($req);

	} else {
		print ("La fonction maj_categorie($id, $libelle, $gestionnaire_contenu) n'existe pas pour la version " . VERSION);
	}

	return pg_result($res, 0, 0);
}

/**
 *	Supprimer un fichier.
 *	@param Integer $id le num�ro du fichier a supprimer
 *	@return bool: true si le fichier a ete supprimee, false sinon. 
 */
function del_categorie_fichier($id) {

	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_del_fichier($id)";
		//echo $req;
		$res = pg_query($req);

	} else {
		print ("La fonction del_categorie_fichier($id) n'existe pas pour la version " . VERSION);
	}

	return pg_result($res, 0, 0);
}

/**
 *	Supprimer un element.
 * @param integer $categorie le la cat�gorie dans laquelle on veut effectuer la suppression.
 *	@param integer $id le num�ro de l'�l�ment a supprimer
 *	@return bool: true si l'�l�ment a ete supprimee, false sinon. 
 */
function del_categorie_element($categorie, $id) {

	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_del_categorie_element($categorie,$id)";
		//echo $req;
		$res = pg_query($req);

	} else {
		print ("La fonction af_del_categorie_element($categorie,$id) n'existe pas pour la version " . VERSION);
	}

	return pg_result($res, 0, 0);
}

///**
//	Supprimer un fichier texte.
//	@param Integer: le num�ro du fichier texte a supprimer
//	@return bool: true si le fichier a ete supprimee, false sinon. 
//*/
/*function del_fichier_texte($id){
	
	if (VERSION_BASE > VERSION) {
		
		$req="select * from contraintes.af_del_fichier_texte($id)";
		//echo $req;
		$res = pg_query($req);
		
	} else{
		print("La fonction del_fichier_texte($id) n'existe pas pour la version ".VERSION);
	}
	
	return pg_result($res, 0, 0);	
}*/

/**
 *	Obtenir tous les �l�ments d'un th�me pour une cat�gorie, qu'ils soient connect�s ou non
 *	@param integer $categorie le num�ro de la categorie
 *  @param integer $theme le num�ro du th�me
 *	@return integer : tous les champs des �l�ments de la cat�gorie (id, categorie, theme) 
 */
function get_categorie_elements_theme($categorie, $theme) {

	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_categorie_elements_theme($categorie,$theme) ";
		//echo $req."<BR>";
		$res = pg_query($req);

	} else {
		print ("La fonction get_categorie_elements($categorie) n'existe pas pour la version " . VERSION);
	}

	return $res;
}

/**
 *	Obtenir tous les fichiers d'une categorie
 *	@param integer $categorie le numero de la categorie
 *	@param integer $theme le numero du theme
 *	@return integer : tous les champs des fichiers de la categorie pour ce theme
 */
function get_categorie_fichiers_theme($categorie, $theme) {

	if (VERSION_BASE > VERSION) {
		//fichiers simples
		if ($categorie != TYPE_CATEGORIE_RESSOURCE_TEXTE && $categorie!=TYPE_CATEGORIE_FICHIER_GLOSSAIRE) {
			$req = "select * from contraintes.af_get_categorie_fichiers_all_theme($categorie,  $theme) AS ( id int4, libelle varchar, \"type\" int4, connecte bool)";
		}
		//fichiers textes
		else {
			//echo "cat=$categorie<br>";
			if($categorie==TYPE_CATEGORIE_RESSOURCE_TEXTE)
				$req = "select * from contraintes.af_get_categorie_fichiers_textes_all_theme($categorie,  $theme) AS ( id int4, libelle varchar, \"type\" int4, connecte bool, lien varchar, adresse varchar, description varchar, mise_en_forme text, date_modification text)";
			else{
				// glossaire
				if($categorie==TYPE_CATEGORIE_FICHIER_GLOSSAIRE){
					//$req="select * from contraintes.af_get_categorie_glossaire_theme($categorie,$theme) as (id int4,libelle varchar)";
					$req="select * from contraintes.af_get_theme_glossaires($theme) as (id int4,libelle varchar)";
				}
			}
		}
		//echo "req=$req<BR>";
		$res = pg_query($req);

	} else {
		print ("La fonction get_categorie_fichiers_theme($categorie, $theme) n'existe pas pour la version " . VERSION);
	}

	return $res;
}

/**
 * Associer un fichier � un th�me au sein d'une cat�gorie.
 * @param integer $fichier le numero du fichier
 * @param string $connect TRUE ou FALSE selon que le fichier est connect� ou non
 * @param integer $theme le numero du theme
 * @param integer $categorie le numero de la categorie
 * @return string 't' ou 'f' selon que le traitement aie r�ussi ou non.
 */
function set_categorie_fichier_theme($fichier, $connect, $theme, $categorie) {

	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_set_categorie_fichier_theme('$fichier', $connect, $theme, $categorie)";
		echo $req;
		$res = pg_query($req);

	} else {
		print ("La fonction af_set_categorie_fichier_theme('$fichier', $connect, $theme, $categorie) n'existe pas pour la version " . VERSION);
	}

	return pg_result($res, 0, 0);
}

/**
 * Cr�e et associer un fichier texte � un th�me au sein d'une cat�gorie.
 * @param string $libelle Nouveau lib�ll� du Fichier Texte
 * @param string $titre Nouveau titre du Fichier Texte
 * @param string $adresse Nouveau lien du Fichier Texte
 * @param string $description Nouvelle description du Fichier Texte
 * @param string $mise_en_forme Nouvelle mise en forme du Fichier Texte
 * @param string $connecte  Nouvel �tat de connection du Fichier Texte('TRUE' ou 'FALSE')
 * @param integer $theme le numero du theme
 * @param integer $categorie le numero de la categorie
 * 
 * @return integer Identifiant du nouveau fichier texte.
 */
function set_categorie_fichier_texte_theme($libelle, $titre, $adresse, $description, $mise_en_forme, $connecte, $theme, $categorie) {

	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_set_categorie_fichier_texte_theme( varchar '$libelle',  varchar '$titre',  varchar '$adresse',  varchar '$description',  text '$mise_en_forme', boolean '$connecte', integer '$theme', integer '$categorie')";
		//echo $req;
		$res = pg_query($req);

	} else {
		print ("La fonction af_set_categorie_fichier_texte_theme($libelle, $titre, $adresse, $description, $mise_en_forme, $connecte, $theme, $categorie) n'existe pas pour la version " . VERSION);
	}

	return pg_result($res, 0, 0);
}

/**
 *	Obtenir les informations sur une categorie
 *
 *	@param integer $categorie le num�ro de la categorie
 *	@return integer : tous les champs d'une cat�gorie :( id int4 ,  libelle varchar, table_cible varchar,  gestionnaire_contenu bool, table_etape varchar )
 */
function get_categorie($categorie) {

	if (VERSION_BASE > VERSION) {

		$req = "select * from contraintes.af_get_categorie($categorie)AS ( id int4 ,  libelle varchar, table_cible varchar,  gestionnaire_contenu bool, table_etape varchar );";
		$res = pg_query($req);

	} else {
		print ("La fonction get_categorie($categorie) n'existe pas pour la version " . VERSION);
	}

	return $res;
}

/**
 * Enregistre un �l�ment d'une categorie dans un theme
 * @param integer $categorie identifiant de la categorie
 * @param integer $theme: identifiant du theme
 * @param integer $id identifiant de l'�l�ment
 */
function set_categorie_element_theme($categorie, $theme, $id) {
	if(empty($categorie)||empty($theme)||empty($id)){
		die("set_categorie_element_theme($categorie, $theme, $id): Parametre manquant.<br>");
	}	

	if (VERSION_BASE > VERSION) {
		$sql = "select contraintes.af_set_categorie_element_theme($categorie,$theme,$id)";
		//echo "$sql<br>";
		return pg_query($sql);
	} else {
		print ("La fonction set_categorie_element_theme($categorie,$theme,$id) n'existe pas pour la version " . VERSION);
	}
}

/**
	Obtenir  les th�mes d'un �l�ment d'une cat�gorie 
	@param integer $categorie le num�ro de la categorie
	@param integer $element le num�ro de l'�l�ment
	@return integer : le resultat de la requete  (id int4, libelle varchar)
*/
function get_categorie_element_themes($categorie, $element) {
	if(empty($categorie)||empty($element)){
		die("Erreur de parametre get_categorie_element_themes($categorie, $element)");
	}
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_categorie_themes_element_infos($categorie, $element) AS (id int4, libelle varchar)";
//		echo $req."<BR>";
		$res = pg_query($req);

	} else {
		print ("La fonction get_categorie_themes_element($categorie, $element) n'existe pas pour la version " . VERSION);
	}

	return $res;
}

/**
 * Cre un glossaire et l'associe  un theme au sein d'une catgorie
 * @param string $libelle Nouveau lib�ll� du glossaire
 * @param integer $theme le numero du theme
 * @param integer $categorie le numero de la categorie
 *  @return integer Identifiant du nouveau glossaire.
 */
 function set_categorie_fichier_glossaire_theme($libelle,$theme,$categorie){
 	$req="select * from contraintes.af_set_categorie_fichier_glossaire_theme(varchar '$libelle', integer '$theme',integer '$categorie')";
 	$res = pg_query($req);
 	return pg_fetch_result($res, 0, 0);
 }
?>