<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette classe dcrit un choix de rponse  un positionnement.
 * Un Choix est une Rponse avec un Bareme.
 * La cration d'un choix donne lieu a l'enregistrement d'un sondage ou d'un qcm pour l'ancienne bdd,
 * et  l'enregistrement d'un objet de type Choix pour la bases contraintes.
 * La connexion  la base de donnes doit tre $db
 * 
 * @package choix
 */
class Choix extends Reponse {
	
	var $bareme;
	var $configEvaluationsType;
	
	/**
	* Constructeur de la classe Choix
	*
	* On peut construire de deux faons. Soit on utilise le paramtre identifiant l'enregistrement en base de donnes, soit on passe
	* toutes les informations ncssaires.
	* @param integer $id Identifiant de la srie s'il elle existe en base de donnes (doit tre le seul argument valu si on veut construire un objet  partir de l'enregistrement en BD
	* @param integer $type Identifiant du type de choix
	* @param string $libelle Libell
	* @param integer $theme Identifiant du thme en base de donnes
	* @param integer $media Identifiant du mdia en base de donnes
	*/
	function Choix($id = 0, $type = 0, $libelle = "Nouveau choix", $interpretationHTML = false, $bareme=0, $media=0) {
		messageDebug("Choix::Choix($id,  $type , $libelle , $interpretationHTML, $bareme , $media )");
		// Si l'identifiant est inconnu
		if( func_num_args()>2 ) {

		}
		// Si on connait l'identifiant,on construit l'objet a partir de l'enregistrement en base
		else {
			if(empty($id)){
				parent :: Reponse(0, $libelle, $type, $interpretationHTML);
			}else{
				if (VERSION_BASE > VERSION) {
					$result = get_choix($id);
					// recup du theme
					$res_th = get_choix_themes($id);
				} else {
	
					// On rcupre les informations en base de donnes
					if ($type == get_evaluation_type_old_new('q')||$type == get_evaluation_type_old_new('m')) {
						$result = get_reponse_qcm($id);
						// recup du theme
						$res_th = get_reponse_qcm_theme($id);
					} else
						if ($type == get_evaluation_type_old_new('s')||$type == get_evaluation_type_old_new('o')) {
							$result = get_proposition_sondage($id);
							// recup du theme
							$res_th = get_proposition_sondage_theme($id);
						}
						else{
							print("Erreur Choix(...):<br> Le type '".$type."' n'est pas support par la fonction.");
						}
				}
				$row = pg_fetch_array($result);
				$id=$row[0];
				$libelle=$row[1];
				$interpretationHTML=$row[2];
				$type=$row[3];
			}
		}
		// On appel le constructeur de la classe mre
		parent :: Reponse($id, $libelle, $type, $interpretationHTML, $media);
		$this->initChoix($bareme);
	}

function initChoix($bareme){
	$this->bareme=$bareme;
	$this->evaluations_generees=Array();
}
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert($message);
		$verif=Choix::verify($message);
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate($message);
		$verif=Choix::verify($message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Ne vrifie aucun attribut.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes (toujours), false si non (jamais).
	 */
	function verify(&$message){
		return true;
	}
	
	/**
	* Fonction qui insre le Choix en base.
	* Affecte l'identifiant du Choix.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre le Choix 
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant du Choix cr ou false
	*/
	function insertToDB($theme, &$message) {
		if(Choix::verifyInsert(&$message)){
			return parent::insertToDB($theme, &$message);
		}
		else{
			return false;
		}	
	}

	
/*	function insertToDB() {
		//echo "dans insertdb";
		if ((!empty ($this->libelle)) && (!empty ($this->num_theme)) && (!empty ($this->type))) {
			//traitement des variables
			$lib = addslashes($this->libelle);
			$html = "FALSE";

			//insertion
			if (VERSION_BASE > VERSION) {
				$insertion = set_choix($lib, $html, $this->num_theme);
			} else {

				if ($this->type == get_evaluation_type_old_new('q')||$this->type == get_evaluation_type_old_new('m')) {
					$insertion = set_reponse_qcm($lib, $html, $this->num_theme);
				} else
					if ($this->type == get_evaluation_type_old_new('s')||$this->type == get_evaluation_type_old_new('o')) {
						$insertion = set_proposition_sondage($lib, $html, $this->num_theme);
					}

			}
			if(empty($insertion)){
				die("Erreur lors de l'insertion du Choix<br>");
			}
			$this->id_reponse=$insertion;
			return $insertion;

		} else {
			echo "Insertion Choix impossible : mauvais attributs d'objet:".$this->libelle.",".$this->num_theme.",".$this->type."<br>";
			return false;
		}

	}*/


	/**
	* Fonction qui met  jour l'enregistrement en base.
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant, un libelle, un theme et un type.
	* @return bool: 't' ou 'f' selon que la mise a jour ai t ffectue ou non.
	*/
	function updateToDB(&$message) {
		
		if(Choix::verifyUpdate(&$message)){
			
			//traitement des variables
			$lib = addslashes($this->libelle);
			//update
			if (VERSION_BASE > VERSION) {
				$update = maj_choix($this->id, $lib, "FALSE");
			} else {
				if ($this->type == get_evaluation_type_old_new('q')||$this->type == get_evaluation_type_old_new('m')) {
					$update = maj_reponse_qcm($this->id, $lib, "FALSE");
				} else{
					if ($this->type == get_evaluation_type_old_new('s')||$this->type == get_evaluation_type_old_new('o')) {
						$update = maj_proposition_sondage($this->id, $lib, "FALSE");
					}
					else{
						echo "Update Choix impossible : type inconnu ($this->type) <br>";
					}
				}	
			}
			return $update;
		} else {
			return false;
		}
	}

//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	/**
	 * Affecte ou met  jour une configuration pour un type d'Evaluation.
	 * @return bool true si une configuration n'existait pas pour ce type, false si la config  t mise  jour.
	 */
	 function setConfigEvaluationsType($type, $nb, $chapeau){
	 	if(!is_array($this->configEvaluationsType[$type])){
	 		$this->configEvaluationsType[$type]=Array($nb, $chapeau);
	 		return true;
	 	}else{
	 		$this->configEvaluationsType[$type]=Array($nb, $chapeau);
	 		return false;
	 	}
	 }
	 
	 /**
	 * 
	 */
	 function delConfigEvaluationsType($type){
	 	if(is_array($this->configEvaluationsType[$type])){
	 		unset($this->configEvaluationsType[$type]);
	 		return true;
	 	}else{
	 		return false;
	 	}
	 }
	 
	 /**
	 * 
	 */
	 function getConfigEvaluationsType($type){
	 	return $this->configEvaluationsType[$type];
	 }

	/**
	 * Obtenir le numero de Bareme du Choix.
	 */
	function getBareme(){
		return $this->bareme;
	}
	
	/**
	 * Affecter un numero de Bareme du Choix.
	 */
	function setBareme($bareme){
		$this->bareme=$bareme;
	}
}
?>