<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Created on 27 mars 2006
 * @author Rmi Cocquet
 * @package choix
 * @modulegroup plpgsql
 * @module plpgsql_choix
 */
 

/**
	Enregistre un nouveau choix
	
	@param string : le libelle du choix
	@param bool : interpretation html ?
	@param integer : le numero du theme
	@return integer : le numero du nouveau choix
*/
function set_choix($libelle,$html,$theme){
	if(VERSION_BASE>VERSION){
		$num=set_question_reponse_element($libelle,$html,6,'TRUE');
		$sql="select contraintes.af_set_categorie_element_theme(17,$theme,$num)";
		//echo "$sql<br>";
		$res=pg_query($sql);
		return $num;
	
	}
	else
		print("Les choix n'existent pas dans la version actuelle de la base :".VERSION);	
}

/**
	Mettre  jour un choix
	@param integer : numero de choix
	@param string : libelle choix
	@param bool : interpretation html ?
	@return bool : t si ok, f sinon
*/
function maj_choix($choix,$libelle,$inter_html){
	if(VERSION_BASE>VERSION){
		 return maj_question_reponse_element($choix,$libelle,$inter_html);
	}
	else
		print("Les choix n'existent pas dans la version actuelle de la base :".VERSION);
}

/**
	Obtenir les informations d'un choix
	
	@param integer : le numero du choix
	@return integer :  le resultat de la requete (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_choix($choix){
	if(VERSION_BASE>VERSION){
		return get_question_reponse_element($choix);
	}
	else
		print("Les choix n'existent pas dans la version actuelle de la base :".VERSION);
}

/**
	Obtenir les info d'un choix
	
	@param integer : le numero de la proposition
	@return integer :  le resultat de la requete
*/
function get_choix_themes($choix){
	if(VERSION_BASE>VERSION){
	return get_categorie_element_themes(17,$choix);
	}
	else
		print("Les choix n'existent pas dans la version actuelle de la base :".VERSION);
}
?>
