<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  @package classe
   @modulegroup plpgsql
   @module plpgsql_classe
*/

include("$root/lib/lib_groupe.php"); // a supprimer)
/**
*   Obtenir les classes  partir d'un pre (OLD)
*
*   @param integer : numero du pre.
*   @return integer : l'entier rsultat de la requete
*/
function get_classe_pere_old($pere){
    $sql="select * from classe where id_pere=$pere order by nom";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les classes  partir d'un pre
*
*   @param integer : numero du pre.
*   @return integer : l'entier rsultat de la requete
*/
function get_classe_pere($pere){
	global $auth;	

    if(VERSION_BASE > VERSION){
        $sql="select * from contraintes.af_get_classe_pere($pere) as (id int4,nom varchar,id_pere int4,min int4,max int4)";
         //echo $sql;
        $res=pg_query($sql);

    }
    else
        $res=get_classe_pere_old($pere);
    return $res;
}

/**
*   Obtenir les classes de tous les pres et fils
*
*   @return integer : l'entier rsultat de la requete
*/
function get_classe_peres_fils(){
    if(VERSION_BASE > VERSION){
        $sql="select * from contraintes.af_get_classe_peres_fils() as (id int4,nom varchar,id_pere int4,min int4,max int4) order by id";
         //echo $sql;
        $res=pg_query($sql);

    }
    else
        $res=get_classe_pere_old($pere);
    return $res;
}

/**
*   Obtenir le niveau d'une class (OLD)
*
*   Une classe qui n'a pas de pre  est de niveau 1.
*
*   @param integer : numero de la classe
*   @return integer : identifiant resultat ( identifiant,  nom , numero du pere , maximun de places, minimum de places)
*/
function get_classe_niveau_old($classe){

        $parent=$classe;
        while($parent<>0){
                $res=pg_query("select * from classe where id='$parent';");
                $row=pg_fetch_row($res,0);
                $tab[]=$row[1];
                $parent=$row[2];
    }
   $niv=sizeof($tab);
   return $niv;
}

/**
*   Obtenir le niveau d'une classe
*
*   Une classe qui n'a pas de pre  est de niveau 1.
*
*   @param integer : numero de la classe
*   @return integer : identifiant resultat ( identifiant,  nom , numero du pere , maximun de places, minimum de places)
*/
function get_classe_niveau($classe){
	if(VERSION_BASE>VERSION){
		//$req="select   _af_get_niveau_groupe($groupe)";
		$req="select contraintes.af_gen_get_element_niveau('contraintes.classe','id',$classe,' ',0)";
		//echo $req;
		$res = pg_query($req);
		$res = pg_result($res, 0,0);
	}
	else
		$res=get_classe_niveau_old( $classe);
	return ($res);
}

/**
	Obtenir les infos d'une classe (OLD)
	@param integer : le numero de la classe
	@return integer : resultat requete
*/
function get_classe_old($classe){
	$sql="select id, nom, id_pere, minplace, maxplace from classe, placegroupe  where id=$classe and id=num_gest_groupe;";
    $res = pg_query($sql);
    return $res;
}
 /**
	Obtenir les infos d'une classe 
	@param integer : le numero de la classe
	@return integer : resultat requete
*/
function get_classe($classe){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_classe($classe) as (id int4,libelle varchar,pere int4,min int4,max int4)";
		$res=pg_query($sql);
	}
	else
		$res=get_classe_old($classe);
	return $res;
}

/**
*   Retourne les individus d'une classe  (OLD)
*
*    Retourne les numero des individus d'une classe
*   Le parametre de selection permet de retourner les individus (u, fu ou f),
*   les formateur(f ou fu) ou les stagiaires(u ou fu) Set l'ordre
*   d'avoir un classement par nom croissant ou decroissant
*   La selection exclusive permet de selectionner les individus strictement formateurs ou stictement
*   utilisateurs.
*
*   @param integer : numero de la classe
*   @param integer : 0 individus, 1 formateurs, 2 utilisateurs
*   @param string  : DESC sinon ASC
*   @param integer : 1 selection exclusive
*   @return integer : les numero d'utilisateur de la classe , leur nomprenom et categorie
*/
function get_classe_individus_old($classe, $selection, $ordre, $exclusif){
	if($classe>=0&&!empty($classe)){
		/*
		$requete="select num_user, textcat( textcat( nom, text ' '),prenom) AS nomprenom ,categorie , lower(nom) AS ordre
							from utilisateurs
							where categorie like ";
		*/
		$requete="select num_user, nom,prenom ,num_org,categorie , lower(nom) AS ordre
							from utilisateurs
							where categorie like ";
		if($selection==0)
			$requete.=" '%%' ";
		else {
			if($selection==1){
				if($exclusif)
					$requete.="'%f%' ";
				else
					$requete.="'f' ";
			}
			else {
				if($selection==2){
					if($exclusif)
						$requete.="'%u%' ";
					else
						$requete.="'u' ";
				}
				else {
					echo 'Erreur: la selection est incorrecte'.'['.$selection.']';
				}
			}
		}
		$requete.=" and num_user in (select gu_num_user from gestionutil where gu_num_gest_gr='$classe' )
							ORDER BY ordre ";
		if($ordre=="DESC") 
			$requete.=" DESC ";
		//echo "req=$requete<br>";
		//debug echo $requete;
		$individus=pg_query($requete);
		return  $individus;
	} 
	else{
	     //echo 'Erreur: le numero de groupe est incorrect'.'['.$groupe.']';
		return null;
    }
}

/**
*   Retourne les individus d'une classe  
*
*    Retourne les numero des individus d'une classe
*   Le parametre de selection permet de retourner les individus (u, fu ou f),
*   les formateur(f ou fu) ou les stagiaires(u ou fu) Set l'ordre
*   d'avoir un classement par nom croissant ou decroissant .
*   La selection exclusive permet de selectionner les individus strictement formateurs ou stictement
*   utilisateurs.
*
*   @param integer : numero de la classe
*   @param integer : 0 individus, 1 formateurs, 2 utilisateurs
*   @param string  : DESC sinon ASC
*   @param integer : 1 selection exclusive
*   @return integer : les numero d'utilisateur de la classe , leur nomprenom et categorie (type)
*/
function get_classe_individus($classe, $selection=0, $ordre="ASC", $exclusif=true){
	if(VERSION_BASE>VERSION){
		if($ordre=="ASC")$v_type="ORDER BY nom $ordre";
		else $v_type="ORDER BY nom $ordre";	
		if($selection==0)
			$exclusif='false';	
	
	    $sql="select * from contraintes.af_get_classe_individus($classe,$selection,'$ordre','$exclusif') $v_type ";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
    else
        $res=get_classe_individus_old($classe, $selection, $ordre, $exclusif) ;

    return  $res;
}

/**
	Retourne les infos individus d'une classe (old)
	@param integer : numero de la classe
   @param integer : 0 individus, 1 formateurs, 2 utilisateurs
   @param string  : DESC sinon ASC
   @param integer : 1 selection exclusive
   @return integer : (* from individu)
*/
function get_classe_individus_infos_old($classe,$selection,$ordre,$exclusif){

}
/**
	Retourne les infos individus d'une classe 
	@param integer : numero de la classe
   @param integer : 0 individus, 1 formateurs, 2 stagiaires
   @param string  : DESC sinon ASC
   @param integer : 1 selection exclusive
   @return integer : (* from individu)
*/
function get_classe_individus_infos($classe,$selection,$ordre,$exclusif='false'){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_classe_individus_infos($classe,$selection,'$ordre',$exclusif) 
			as (id int4,identifiant_md5 varchar,login varchar,password varchar,nom varchar,prenom varchar,adresse varchar,code varchar,ville varchar,email varchar,tel_fixe varchar,tel_port varchar,langue int4,organisme int4,photo int4)";
		//echo $sql."<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_classe_individus_infos_old($classe,$selection,$ordre,$exclusif);
	return $res;
}


/**
	Enregistre un classe (OLD)
	@param string : le nom de la classe
	@param integer : n pere
	@param integer : place min
	@param integer : place max
*/
function set_classe_old($libelle_classe,$pere,$min,$max){
	if($pere=="NULL")
		$pere=0;
	// test doublon
	$sql="select * from classe where id_pere=$pere and nom='$libelle_classe'";
	$res=pg_query($sql);
	if(pg_num_rows($res)>0)
		return 0;
	$res=pg_query("insert into classe (nom,id_pere)
                                    values('$libelle_classe',$pere)");
        $oid=pg_getlastoid($res);
        $res=pg_query("SELECT id  FROM classe WHERE OID=$oid;");
        $nv_groupe=pg_result($res, 0, 0);
        $res=set_places_groupe($nv_groupe,$max,$min);
		//$sql=

        return $nv_groupe;
}
/**
	Enregistre un classe 
	@param string : le nom de la classe
	@param integer : n pere
	@param integer : place min
	@param integer : place max
*/
function set_classe($libelle_classe,$pere='NULL',$min='NULL',$max='NULL'){
	if(VERSION_BASE>VERSION){
		if($pere==0)
			$pere="NULL";
		$sql="select * from contraintes.af_set_classe('$libelle_classe',$pere,$min,$max)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
		$nv_groupe=pg_fetch_result($res,0,0);
	}
	else{
		$nv_groupe=set_classe_old($libelle_classe,$pere,$min,$max);
		
	}
	return $nv_groupe; 
}

/**
	Obtenir le nom entier d'une classe (OLD)
	@param integer : n de la classe
	@return string : le nom entier de la classe
*/
function get_classe_nom_entier_old($classe){
	$parent=$classe;
    $tab1=array();
    
    while($parent<>0){
    
        $req="select * from classe where id=$parent ;" ;
        $res=pg_query($req);
        $row=pg_fetch_row($res,0);
        $tab[]=$row[1];
        $parent=$row[2];
    }
    
    $tab1=array_reverse($tab,TRUE);
   
    return (implode("/",$tab1));
}
/**
	Obtenir le nom entier d'une classe 
	@param integer : n de la classe
	@return string : le nom entier de la classe
*/
function get_classe_nom_entier($classe){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_classe_nom_entier($classe) ";
		$res=pg_query($sql);
		$res = pg_fetch_result($res, 0,0);
	}
	else
		$res=get_classe_nom_entier_old($classe);
	return $res;
}

/**
	Obtenir les formations pour une classe (OLD)
	@param integer : n de la classe
	@param string : 'asc' ou 'desc'
	@return integer : resultat requete
*/
function get_classe_formations_old($classe,$ordre,$orderby,$periode){
	$sql="SELECT DISTINCT num_cal AS num_formation,nom_cal AS nom_formation,  
			g_num_parcours AS num_parcours,D1.jour AS debut, D2.jour AS fin,langue
                        FROM gestionnaire, calendrier, dates D1, dates D2
                        WHERE g_num_gest_g=$classe
                        AND g_num_cal=num_cal
                        AND d1.num_date=datedeb
                        AND d2.num_date=datefin ";
			// traitement periode
			switch($periode){
				case 1 : $sql .=" and D2.jour<current_date ";
				break;
				case 2 : $sql .=" and current_date between D1.jour and D2.jour ";
				break;
				case 3 : $sql .=" and D1.jour>current_date ";
				break;
			}
			// traitement du tri
			if($orderby=='libelle')
				$sql .=" order by nom_cal ";
			else
				$sql .=" order by D1.jour ";
					
				// classement
				$sql .="  $ordre";
                        
	//echo "$sql";
            return(pg_query($sql));
}
/**
	Obtenir les formations pour une classe 
	@param integer : n de la classe
	@param string : 'asc' ou 'desc'
	@param string : 'date' ou 'libelle' (orderby)
	@param integer : 1 passes, 2 prsentes, 3 futures, 0 toutes
	@return integer : resultat requete
*/
function get_classe_formations($classe,$ordre='asc',$orderby='libelle',$periode=0){
	 if(VERSION_BASE>VERSION){
	 	global $auth;
		$user_id=$auth->getUserId();
		$sql="select * from contraintes.af_get_classe_formations($classe,'$ordre','$orderby',$periode,$user_id) as (id int4,libelle varchar,parcours int4,date_debut date,date_fin date,langue int4,classe int4)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	 }
	 else
		$res=get_classe_formations_old($classe,$ordre,$orderby,$periode);
	 return $res;
}

/**
	Mettre  jour le nom de la classe (OLD)
	@param integer : le N de la classe
	@param string : le nouveau nom de la classe
	@param integer : n du pere
	@return bool : true si ok false sinon
*/
function maj_classe_old($classe,$libelle_classe,$pere){
	if(check_groupe($pere, $libelle_classe)==0){

        $req="update classe set nom='$libelle_classe' where id=$classe ;";
        $ok=pg_query($req);
        $ok=1;
    }
    else {
        $ok=0;
        //print("Le groupe existe deja");
    }

    return  $ok;
}
/**
	Mettre  jour le nom de la classe 
	@param integer : le N de la classe
	@param string : le nouveau nom de la classe
	@param integer : n du pere
	@return bool : true si ok false sinon
*/
function maj_classe($classe,$libelle_classe,$pere){
	if(VERSION_BASE>VERSION){
		if($pere=="" || $pere==0)
			$pere="NULL";
		$sql="select * from contraintes.af_maj_classe($classe,'$libelle_classe',$pere)";
		$res=pg_query($sql);
	}
	else
		$res=maj_classe_old( $classe,$libelle_classe,$pere);
	return $res;
}

/**
	Supprime une classe (OLD)
	@param integer : n de la classe
	@return integer : resultat requete
*/
function del_classe_old($classe){
	 //suppression du pere courant
        $del=pg_query("delete from classe where id=$classe;");

        $del=pg_query("delete from gestionutil where gu_num_gest_gr=$classe;");
        $del=pg_query("delete from placegroupe where num_gest_groupe=$classe;");

        //recup de ses fils
        $res=pg_query("select * from classe where id_pere=$classe;");
        while($row=pg_fetch_array($res)){
                $classe=$row["id"];
                del_groupe_old($classe);
        }
        return 1;
}
 /**
	Supprime une classe
	@param integer : n de la classe
	@return integer : resultat requete
*/
function del_classe($classe){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_classe($classe)";
		$res=pg_query($sql);
	}
	else
		$res=del_classe_old($classe);
	return $res;
}

/**
	Obtenir les individus affiliables pour une classe (OLD)
	@param integer : n classe
	@return integer : resultat requete
*/
function get_classe_individus_affiliables_old($classe){
	$resusergp=get_classe_individus($classe,0,"ASC");

    if(pg_numrows($resusergp)>0  )


            $resuser=pg_query("select num_user,nom,prenom,categorie from utilisateurs
            where num_user not in
            (select gu_num_user from gestionutil where gu_num_gest_gr='$classe')
            and  num_org in (select num_org from utilisateurs where num_user in
            (select gu_num_user from gestionutil where gu_num_gest_gr='$classe') or num_org=0)
            and categorie <> 'c' order by nom;");
    else
    {
            //recupere tous les individus
            $resuser=get_plateforme_individus(0,'asc',false);
    }

    return  $resuser;
}
/**
	Obtenir les individus affiliables pour une classe 
	@param integer : n classe
	@return integer : resultat requete
*/
function get_classe_individus_affiliables($classe){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_classe_individus_affiliables($classe) as (id int4,nom varchar,prenom varchar,organisme int4)";
		$res=pg_query($sql);
	}
	else
		$res=get_classe_individus_affiliables_old($classe);
	return $res;
}

/**
	Affilie un individu et ses droits  une classe (OLD)
	@param integer : n de la classe
	@param integer : n individu
	@param array : tableau des droits
	@return integer : resultat requete
*/
function set_classe_individu_old($classe,$individu,$tabdroit){
	for($i=0; $i<count( $tabdroit); $i++){
		$req="insert into gestionutil (gu_num_user , gu_num_gest_gr , gu_num_droit)
					values ($individu, $classe, '".$tabdroit[$i][0]."') ";
		//echo $req;
		$res = pg_query($req);
	}
    return ($res);
}
 /**
	Affilie un individu et ses droits  une classe 
	@param integer : n de la classe
	@param integer : n individu
	@param array : tableau des droits
	@return integer : resultat requete
*/
function set_classe_individu($classe,$individu,$tabdroit){
	if(VERSION_BASE>VERSION){
		// affiliation
		$sql="select * from contraintes.af_set_classe_individu($classe,$individu)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
		// les droits (prparation du tableau pl)
		
		$nb_droit=sizeof($tabdroit);
		$chaine="_int4'{";
		for($i=0;$i<$nb_droit;$i++){
			$chaine .=$tabdroit[$i][0].",";
		}
		$chaine=substr($chaine,0,-1);
		$chaine.="}'";
		$res=set_individu_droits_classe($individu,$classe,$chaine);
	}
	else
		$res=set_classe_individu_old($classe,$individu,$tabdroit);
	return $res;
}

/**
	Obtenir l'organisme d'une classe d'individus (OLD)
	@param integer : numero classe
	@return : le numero d'organisme (ou NULL si multi-organisme)
*/
function get_classe_organisme_old($classe){

}
/**
	Obtenir l'organisme d'une classe d'individus
	@param integer : numero classe
	@return : le numero d'organisme (ou NULL si multi-organisme)
*/
function get_classe_organisme($classe){
	 if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_classe_organisme($classe)";
	 }
	 else
		$res=get_classe_organisme_old($classe);
	 return $res;
}

/**
	Desaffilier un individu d'une classe (OLD)
	@param integer : numero classe
	@param integer : numero individu
	
	@return bool : resultat requete
*/
function del_classe_individu_old($classe,$individu){
	// supprime l'individu de la classe
	$sql="delete from gestionutil where gu_num_user=$individu and gu_num_gest_gr=$classe";
	$res=pg_query($sql);
	return $res;
	// si individu en formation ? A Suivre ....Pas sr qu'on fasse quelque chose
}
/**
	Desaffilier un individu d'une classe 
	@param integer : numero classe
	@param integer : numero individu
	
	@return bool : resultat requete
*/
function del_classe_individu($classe,$individu){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_classe_individu($classe,$individu)";
		//die( "sql=$sql");
		$res=pg_query($sql);
	}
	else
		$res=del_classe_individu_old($classe,$individu);
	return $res;
}

/**
	Obtenir les droits communs pour une classe  (OLD)
	@param integer : numero classe
	@param integer : nombre d'individu de la classe
	@return integer : resultat requete
*/
function get_classe_droits_communs_old($classe,$nbindividus){
	$sql="select gu_num_droit from GESTIONUTIL where gu_num_gest_gr=$classe group by gu_num_droit having count(*)=$nbindividus;" ;
	return pg_query($sql);
}
/**
	Obtenir les droits communs pour une classe  
	@param integer : numero classe
	@param integer : nombre d'individu de la classe
	@return integer : resultat requete
*/
function get_classe_droits_communs($classe,$nbindividus){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_classe_droits_communs($classe,$nbindividus) as (id int4)";
		$res=pg_query($sql);
	}
	else
		$res=get_classe_droits_communs_old($classe,$nbindividus);
	return $res;
}

/**
	Obtenir les droits non affilies pour une classe  (OLD)
	@param integer : numero classe
	@return integer : resultat requete
*/
function get_classe_droits_non_affilies_old($classe){
	$sql="select num_droit from droit where type_droit='u' and num_droit not in
			(select distinct gu_num_droit from gestionutil where gu_num_gest_gr=$classe)";
	return pg_query($sql);
}
/**
	Obtenir les droits non affilies pour une classe  
	@param integer : numero classe
	@return integer : resultat requete
*/
function get_classe_droits_non_affilies($classe){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_classe_droits_non_affilies($classe) as (id int4)";
		$res=pg_query($sql);
	}
	else
		$res=get_classe_droits_non_affilies_old($classe);
	return $res;
}

/**
	Ajouter un droit  une classe (OLD)
	@param integer : numero classe
	@param integer : numero droit
	@return integer : resultat requete
*/
function set_classe_droit_old($classe,$droit){
	// recup des users du groupe
	$resuser=pg_query("select distinct gu_num_user from gestionutil where gu_num_gest_gr=$classe;");
	$nbuser=pg_numrows($resuser);
	// ajout du droit  pour chaque user
	for($i=0;$i<$nbuser;$i++){
		$rowuser=pg_fetch_row($resuser,$i);
		$ins=pg_query("insert into gestionutil (gu_num_user,gu_num_gest_gr,gu_num_droit) values($rowuser[0],$classe,$droit);");
	}
}
/**
	Ajouter un droit  une classe 
	@param integer : numero classe
	@param integer : numero droit
	@return integer : resultat requete
*/
function set_classe_droit($classe,$droit){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_classe_droit($classe,$droit)";
//		echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=set_classe_droit_old($classe,$droit);
	return $res;
}

/**
	Supprime un droit  une classe (OLD)
	@param integer : numero classe
	@param integer : numero droit
	@return integer : resultat requete
*/
function del_classe_droit_old($classe,$droit){
	$sql="delete from GESTIONUTIL where gu_num_gest_gr=$classe and gu_num_droit=$droit";
	return pg_query($sql);
}
/**
	Supprime un droit  une classe 
	@param integer : numero classe
	@param integer : numero droit
	@return integer : resultat requete
*/
function del_classe_droit($classe,$droit){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_classe_droit($classe,$droit)";
		$res=pg_query($sql);
	}
	else
		$res=del_classe_droit_old($classe,$droit);
	return $res;
}

/**
	Mettre  jour le nombre de places min et max d'une classe (OLD)
	@param integer : numero de la classe
	@param integer : min
	@param integer : max
	@return integer : resultat requete
*/
function maj_classe_places_old($classe,$min,$max){
	$sql="update placegroupe set maxplace=$max,minplace=$min where num_gest_groupe=$classe";
	$res=pg_query($sql);
}
/**
	Mettre  jour le nombre de places min et max d'une classe 
	@param integer : numero de la classe
	@param integer : min
	@param integer : max
	@return integer : resultat requete
*/
function maj_classe_places($classe,$min,$max){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_classe_places($classe,$min,$max)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=maj_classe_places_old($classe,$min,$max);
	return $res;
}

/**
	Obtenir les evenements d'une classe pour une semaine de formation (OLD)
*   @param integer : le numero du groupe
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_classe_evenements_old($classe,$date){
	$sql="SELECT gnum_cal,libelle,
				 cast(D.jour as timestamp)+cast(hdeb as time),
				cast(hfin as time)-cast(hdeb as time),
				numtype,type,num_intervenant,num_salle 
				from gest_cal g,dates d,gestionnaire 
				where g.gnum_cal=g_num_cal 
				and g.num_date=d.num_date 
				and g_num_gest_g=$classe and jour='$date'";
	return pg_query($sql);
}
/**
	Obtenir les evenements d'une classe pour une semaine de formation 
*   @param integer : le numero du groupe
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_classe_evenements($classe,$date){
	 if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_classe_evenements($classe,'$date')
				as (formation int4,libelle varchar,date timestamp,duree interval,modalite int4,intervention int4,intervenant int4,salle int4)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	 }
	 else
		$res=get_classe_evenements_old($classe,$date);
	 return $res;
}

/**
 * Obtenir les fils d'une classe
 * @param integer : classe
 * @return integer : res req
 */
 function get_classe_fils($classe){
 	$sql="select * from contraintes.af_get_classe_fils($classe) as (id integer)";
 	return pg_query($sql);
 }
 
 
?>