<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  @package commentaire
  @modulegroup plpgsql
  @module plpgsql_commentaire
*/

/**
	Enregistre un commentaire (OLD)
	@param integer : numero de l'etape (serie)
	@param integer : min
	@param integer : max
	@param text : commentaire
	@return : 1 ok, 0 false
*/
function set_commentaire_old($etape,$min,$max,$commentaire,$type_exo){
	$fourchette=$min .",". $max;
	$sql="insert into commentaire values('$etape','$fourchette','$commentaire','$type_exo')";
	return pg_query($sql);
}
/**
	Enregistre un commentaire 
	@param integer : numero de l'etape (serie)
	@param integer : min
	@param integer : max
	@param text : commentaire
	@return : 1 ok, 0 false
*/
function set_commentaire($etape,$min,$max,$commentaire,$type_exo='f'){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_commentaire($etape,$min,$max,'$commentaire')";
		$res=pg_query($sql);
	}
	else
		$res=set_commentaire_old($etape,$min,$max,$commentaire,$type_exo);
	return $res;
}

/**
	Mettre  jour un commentaire (OLD)
	@param integer : numero etape
	@param integer : min
	@param integer : max
	@param text : commentaire
	@return : 1 ok, 0 false
*/
function maj_commentaire_old($etape,$min,$max,$commentaire,$oldmin,$oldmax,$type_exo='f'){
	$fourchette=$min .",". $max;
	$oldfourchette=$oldmin.",".$oldmax;
	$sql="update commentaire set fourchette='$fourchette',commentaire='$commentaire',type_exo='$type_exo' where 
				num_qstaire=$etape and fourchette='$oldfourchette'";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Mettre  jour un commentaire 
	@param integer : numero etape
	@param integer : min
	@param integer : max
	@param text : commentaire
	@return : 1 ok, 0 false
*/
function maj_commentaire($etape,$min,$max,$commentaire,$oldmin,$oldmax,$type_exo='f'){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_commentaire($etape,$min,$max,'$commentaire',$oldmin,$oldmax)";
		$res=pg_query($sql);
	}
	else
		$res=maj_commentaire_old($etape,$min,$max,$commentaire,$oldmin,$oldmax,$type_exo);
	return $res;
}

/**
	Obtenir un commentaire (OLD)
	@param integer : numero etape
	@param integer : min
	@param integer : max
	@param char : type_exo
	@return integer : resultat requete
*/
function get_commentaire_old($etape,$min,$max,$type_exo='f'){
	$fourchette=$min .",". $max;
	$sql="select * from commentaire where num_qstaire=$etape and fourchette='$fourchette' and type_exo='$type_exo'";
	return pg_query($sql); 
}
/**
	Obtenir un commentaire 
	@param integer : numero etape
	@param integer : min
	@param integer : max
	@param char : type_exo
	@return integer : resultat requete
*/
function get_commentaire($etape,$min,$max,$type_exo='f'){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_commentaire($etape,$min,$max) as (etape int4,min int4,max int4,commentaire text)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=get_commentaire_old($etape,$min,$max,$type_exo);
	return $res;
}

/**
	Supprime un commentaire  (OLD)
	@param integer : numero etape
	@param integer : min
	@param integer : max
	@param char : type_exo
	@return : 1 ok, 0 false
*/
function del_commentaire_old($etape,$min,$max,$type_exo='f'){
	 $fourchette=$min .",". $max;
	 $sql="delete from commentaire where num_qstaire=$etape and fourchette='$fourchette' and type_exo='$type_exo'";
	 return pg_query($sql);
}
/**
	Supprime un commentaire  
	@param integer : numero etape
	@param integer : min
	@param integer : max
	@param char : type_exo
	@return : 1 ok, 0 false
*/
function del_commentaire($etape,$min,$max,$type_exo='f'){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_commentaire($etape,$min,$max)";
		$res=pg_query($sql);
	}
	else
		$res=del_commentaire_old($etape,$min,$max,$type_exo);
	return $res;
}
?>