<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL

  
  @package connexion
  @modulegroup plpgsql
  @module plpgsql_connexion
*/



/**
	Obtenir les dates max de connexion et deconnexion pour un individu (OLD)
	@param integer : individu
	@return integer : res req
*/
function get_connexion_dates_max_old($individu){
	$sql="select max(c1.date_connexion),max(c2.date_deconnexion) 
				from connexion c1,connexion c2 where c1.num_user=$individu and c2.num_user=$individu";
	return pg_query($sql);
}
/**
	Obtenir les dates max de connexion et deconnexion pour un individu 
	@param integer : individu
	@return integer : res req
*/
function get_connexion_dates_max($individu){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_connexion_dates_max($individu) as (individu int4,connexion timestamp,deconnexion timestamp)";
		$res=pg_query($sql); 
	}
	else
		$res=get_connexion_dates_max_old($individu);
	return $res;
}

/**
 * Obtenir les dates de connexions des individus
 * @return integer : res req
 */
 function get_connexion_individus(){
 	$sql="select * from contraintes.af_get_connexion_individus() as (individu int4,date_connexion timestamp,ip varchar)";
 	return pg_query($sql); 
 }


/**
*  Obtenir les informations de connexions des individus
*
* @return date : la liste des dates de connexion et d�connexion
*/
function get_connexions(){
	
	if(VERSION_BASE > VERSION){
        $req="select * from contraintes.fw_get_connexions() as (sid varchar, name varchar, start_time timestamp, referer varchar, addr varchar, user_agent varchar, user_id integer)";
        $res=pg_query($req);
	}
	else{
		die("get_connexions_old() manquant");
	}
	
	return($res);
}

?>