<?php
/*
 * Session Management for PHP3
 *
 * Copyright (c) 1998-2000 NetUSE AG
 *                    Boris Erdmann, Kristian Koehntopp
 *
 * $Id: local4.inc,v 1.1 2002/10/01 16:22:03 joestewart Exp $
 *
 * All functions in this file are example classes, which can be used
 * by your application to get you going. Once you get the hang of it,
 * you should backup this file and start over with a clean local.inc
 * which contains only your own classes and only the classes you need.
 */ 

//class DB_Example extends DB_Sql {
//  var $Host     = "localhost";
//  var $Database = "test";
//  var $User     = "kk";
//  var $Password = "";
//}
/**
 * Connexion � la base de donn�es
 */
class DbPgsqlAstairs extends DB_Pgsql {
  
  function DbPgsqlAstairs(){
  	global $adressebase, $nombase,$login,$pass;
  	parent::DB_Pgsql();
  	$this->Host=$adressebase;
  	$this->Database=$nombase;
  	$this->User=$login;
  	$this->Password=$pass;
  }
  
//   function affected_rows() { 
//	return pg_affected_rows($this->Query_ID);
//  }
}

class DB_Permission extends DbPgsqlAstairs {
	var $classname = "DB_Permission";
//	var $database_table="contraintes.fw_permission";
	var $database_table="contraintes.fw_individu_type";
	
	function haltmsg($msg) {
	    printf("</td></table><b>Database error:</b> %s<br>\n", $msg);
	    printf("<b>MySQL Error</b>: %s (%s)<br>\n",
	      $this->Errno, $this->Error);
	    printf("Please contact support@afide.fr and report the ");
	    printf("exact error message.<br>\n");
  	}
}

class DB_FrontPermission extends DbPgsqlAstairs {
	var $classname = "DB_FrontPermission";
//	var $database_table="contraintes.fw_permission";
	var $database_table="contraintes.droit";
	
	function haltmsg($msg) {
	    printf("</td></table><b>Database error:</b> %s<br>\n", $msg);
	    printf("<b>MySQL Error</b>: %s (%s)<br>\n",
	      $this->Errno, $this->Error);
	    printf("Please contact support@afide.fr and report the ");
	    printf("exact error message.<br>\n");
  	}
}

class DB_ModulePermission extends DbPgsqlAstairs {
	var $classname = "DB_ModulePermission";
//	var $database_table="contraintes.fw_permission";
	var $database_table="contraintes.fw_module_individus_types MIT";
	
	function haltmsg($msg) {
	    printf("</td></table><b>Database error:</b> %s<br>\n", $msg);
	    printf("<b>MySQL Error</b>: %s (%s)<br>\n",
	      $this->Errno, $this->Error);
	    printf("Please contact support@afide.fr and report the ");
	    printf("exact error message.<br>\n");
  	}
}

//class DB_AstairsPermission extends DbPgsqlAstairs {
//	var $classname = "DB_AstairsPermission";
//	var $database_table="contraintes.fw_individu_type";
//	
//	function haltmsg($msg) {
//	    printf("</td></table><b>Database error:</b> %s<br>\n", $msg);
//	    printf("<b>MySQL Error</b>: %s (%s)<br>\n",
//	      $this->Errno, $this->Error);
//	    printf("Please contact shopmaster@doma.in and report the ");
//	    printf("exact error message.<br>\n");
//  	}
//}
function unserializesession($data) {
   $vars=preg_split(
             '/([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\|/',
             $data,-1,PREG_SPLIT_NO_EMPTY |                
              PREG_SPLIT_DELIM_CAPTURE
             );
   for($i=0; $vars[$i]; $i++) {
       $result[$vars[$i++]]=unserialize($vars[$i]);    
   }
   return $result;
}



/**
 * Session needs to use a storage container (ct). 
 * Select exactly one of the following and set $that_class 
 * in Example_Session appropriately.
 */
class AstairsCtSql extends CT_Sql {
  var $database_class = "DbPgsqlAstairs";          ## Which database to connect...
  var $database_table = "contraintes.session_active"; ## and find our session data in this table.
  
  	/**
  	 * Garbage Collector
  	 * Supprime les enregistrements de session ayant expirés 
  	 * L'expiration d'une session à lieu dans les 2 cas suivants:
  	 * 
  	 * NB: Le garbage collector traite les sessions autres que celle qui a déclanché l'appel à cette méthode.
  	 * En effet, la session qui a déclanché l'appel à cette méthode est bien supprimée, mais est réenregistrée immédiatement après.
  	 */
    function ac_gc( $gc_inactive, $name) {
//    $timeout = time();
//    $sqldate = date("YmdHis", $timeout - ($gc_time * 60));
//    $this->db->query(sprintf("DELETE FROM %s WHERE changed < '%s' AND name = '%s'",
//                    $this->database_table, 
//                    $sqldate,
//                    addslashes($name)));
//	die("GARBAGE COLLECTOR!<br>");
	$query=sprintf("DELETE FROM %s WHERE name LIKE '%s' " .
					"AND ( (now()-changed )> CAST( %s ||' minutes' AS interval) ) ",
                    $this->database_table, 
                     addslashes($name),$gc_inactive);
//                     echo $query;
    $this->db->query($query);
    }
    
    function ac_unregister_user($user_id){
//    	echo "ac_unregister_user($user_id)";
    	$query=sprintf("select  sid, name
							from %s", $this->database_table);
    	$res=pg_query($query);
		$nb=pg_num_rows($res);
//		echo "\$nb=$nb";
		$deleted=false;
		for($i=0;$i<$nb;$i++){
			$sid = pg_fetch_result($res,$i,0);
			$name =pg_fetch_result($res,$i,1);
			$str=$this->ac_get_value($sid,$name);
			$data=unserializesession($str);
            if(is_object($data['auth'])){
           		$sess_user_id=$data['auth']->getUserId();
            
				if(!empty($user_id)&&!empty($sess_user_id)&&$user_id==$sess_user_id){
//					echo "supprime $name";
					$cur_deleted=$this->ac_delete($sid,$name);
					if($cur_deleted){
						$deleted=true;
					}
				}
            }
		}
		return $deleted;
    }
    
	function ac_delete($id, $name) {
   		$res=pg_query(sprintf("delete from %s where name = '%s' and sid = '%s'",
	      $this->database_table,
	      addslashes($name),
	      $id));
     	return $res;
  	}
  	
    function ac_unregister_user_session($user_id,$name){
    	
    	$query=sprintf("select  sid	from %s where name='%s'", $this->database_table, $name);
    	$res=pg_query($query);
		$nb=pg_num_rows($res);
		$deleted=false;
		for($i=0;$i<$nb;$i++) {
			$sid = pg_fetch_result($res,$i,0);
			$str=$this->ac_get_value($sid,$name);
			$data=unserializesession($str);
            $sess_user_id=$data['auth']->getUserId();
			if(!empty($user_id)&&$user_id==$sess_user_id){
				$res_del=$this->ac_delete($sid,$name);
				if($res_del)$deleted=true;
			}
		}
		return $deleted;
    }
    
	function ac_store($id, $name, $str) {
	    $ret = true;
	    switch ( $this->encoding_mode ) {
	      case "slashes":
	        $str = addslashes($name . ":" . $str);
	      break;
	
	      case "base64":
	      default:
	        $str = base64_encode($name . ":" . $str);
	    };
	
	    $name = addslashes($name);
	
	    ## update duration of visit
	    $uquery = sprintf("update %s set val='%s', changed=now() where sid='%s' and name='%s'",
	      $this->database_table,
	      $str,
	      $id,
	      $name);
	    $squery = sprintf("select count(sid) from %s where val='%s' and sid='%s' and name='%s'",
	      $this->database_table,
	      $str,
	      $id,
	      $name);
	    $iquery = sprintf("insert into %s ( sid, name, val, changed ) values ('%s', '%s', '%s', now())",
	      $this->database_table,
	      $id,
	      $name,
	      $str);
	    $this->db->query($uquery);
	
	    if ( $this->db->affected_rows() == 0
	        && $this->db->query($squery)
		&& $this->db->next_record() && $this->db->f("count") == 0
	        && !$this->db->query($iquery)) {
	
	        $ret = false;
	    }
	    return $ret;
	  }
}

class AstairsFrontCtSql extends AstairsCtSql{
	

	 /**
  	 * Garbage Collector
  	 * Supprime les enregistrements de session ayant expirés 
  	 * -la date actuelle moins la modification est supérieure à la durée max d'inactivité. (durée d'inactivité max atteinte)
  	 * 
  	 * NB: Le garbage collector traite les sessions autres que celle qui a déclanché l'appel à cette méthode.
  	 * En effet, la session qui a déclanché l'appel à cette méthode est bien supprimée, mais est réenregistrée immédiatement après.
  	 */
    function ac_gc( $gc_inactive, $name) {
	
		//suppression des sessions non associes  une formation dont la duree d'inactivit est dpass
		$query=sprintf("DELETE FROM %s WHERE name LIKE '%s' " .
						"AND ( (now()-changed )> CAST( %s ||' minutes' AS interval) ) AND formation IS NULL",
	                    $this->database_table, 
	                     addslashes($name),$gc_inactive);
		//echo $query;
	    $this->db->query($query);
	    
	    //suppression des sessions associes  une formation dont la duree d'inactivit est dpass
		$query=sprintf("DELETE FROM %s USING contraintes.formation_session FS WHERE name LIKE '%s' " .
						"AND ( (now()-changed )> inactivite  ) " .
						"AND FS.formation = %s.formation ",
	                    $this->database_table, 
	                     addslashes($name),$this->database_table);
		//echo $query;
	    $this->db->query($query);
    }
    
   	function ac_store($id, $name, $str) {
   		
   		global $obj_DoFormation;
   		if(is_object($obj_DoFormation)&&$obj_DoFormation->getFormation()){
   			$formation = $obj_DoFormation->getFormation();
   		}
	    $ret = true;
	    switch ( $this->encoding_mode ) {
	      case "slashes":
	        $str = addslashes($name . ":" . $str);
	      break;
	
	      case "base64":
	      default:
	        $str = base64_encode($name . ":" . $str);
	    };
	
	    $name = addslashes($name);
	
	    ## update duration of visit
	    $uquery = sprintf("update %s set val='%s', changed=now() where sid='%s' and name='%s'",
	      $this->database_table,
	      $str,
	      $id,
	      $name);
	    $squery = sprintf("select count(sid) from %s where val='%s' and sid='%s' and name='%s'",
	      $this->database_table,
	      $str,
	      $id,
	      $name);
	    $iquery = sprintf("insert into %s ( sid, name, val, changed , formation) values ('%s', '%s', '%s', now(),%s)",
	      $this->database_table,
	      $id,
	      $name,
	      $str,
	      int2Sql($formation));
	    $this->db->query($uquery);
	
	    if ( $this->db->affected_rows() == 0
	        && $this->db->query($squery)
		&& $this->db->next_record() && $this->db->f("count") == 0
	        && !$this->db->query($iquery)) {
	
	        $ret = false;
	    }
	    return $ret;
	  }
}
##
## An example of Split_Sql container usage
## You may need it if you expect significant amount of session-registered
## data and there are restrictions on tuple size in your database
## engine (e.g. like in Postgres)
##
## NB: session table name is different only for illustrative purposes,
## so you wouldn't absent-mindedly confuse split session data and non-split
## table structure is the same - if you are sure you won;t be switching
## back and forth between containers, just use active_sessions

#class Example_CT_Split_Sql extends CT_Split_Sql {
#  var $database_class = "DB_Example";         ## Which database to connect...
#  var $database_table = "active_sessions_split"; ## and find our session data in this table.
#  var $split_length = 4096;                   ## Split rows every 4096 bytes
#}

#class Example_CT_Shm extends CT_Shm {
#  var $max_sessions   = 500;               ## number of maximum sessions
#  var $shm_key        = 0x123754;          ## unique shm identifier
#  var $shm_size       = 64000;             ## size of segment
#}

#class Example_CT_Ldap extends CT_Ldap {
#   var $ldap_host = "localhost";
#   var $ldap_port = 389;
#   var $basedn    = "dc=your-domain, dc=com";
#   var $rootdn    = "cn=root, dc=your-domain, dc=com";
#   var $rootpw    = "secret";
#   var $objclass  = "phplibdata";
#}

#class Example_CT_Dbm extends CT_DBM {
#   var $dbm_file  = "must_exist.dbm";
#}

/*class Example_Session extends Session {
  var $classname = "Example_Session";

  var $cookiename     = "";                ## defaults to classname
  var $magic          = "Hocuspocus";      ## ID seed
  var $mode           = "cookie";          ## We propagate session IDs with cookies
  var $fallback_mode  = "get";
  var $lifetime       = 0;    //0             ## 0 = do session cookies, else minutes
//  var $that_class     = "Example_CT_Sql";  ## name of data storage container class
var $that_class     = "AstairsCtSql";  ## name of data storage container class
  var $gc_probability = 5;  
  var $allowcache     = "no";              ## "public", "private", or "no"

}*/

class CachedSession extends Session {
  var $classname = "CachedSession";

  var $cookiename     = "";                ## defaults to classname
  var $magic          = "Hocuspocus";      ## ID seed
  var $mode           = "cookie";          ## We propagate session IDs with cookies
  var $fallback_mode  = "get";
  var $lifetime       = 0;    //0             ## 0 = do session cookies, else minutes
//  var $that_class     = "Example_CT_Sql";  ## name of data storage container class
var $that_class     = "AstairsCtSql";  ## name of data storage container class
  var $gc_probability = 5;  
  var $allowcache     = "private";              ## "public", "private", or "no"

}

include("session4_custom.inc");
/**
 * Gestionnaire de session Astairs.
 * $magic: Utilise la $magic_pass_phrase définie dans le fichier de configuration de la plateforme.
 * $mode: L'identifiant de la session client est stockée dans un cookie.
 * $fallback_mode: En cas de désactivation des cookies par le client,  l'identifiant de la session est propagé par l'URL (get)
 * $lifetime: La session à une durée de vie infinie, tant que le cookie de session est présent sur le client
 * $lifetime: Pas de cache   
 */
class AstairsPageSession extends Session_Custom {
  var $classname = "AstairsPageSession";

  var $cookiename     = "";//"AstairsPage";                ## defaults to classname
  var $magic          = "Hocuspocushgkgy1Gygyg76867hgj";      ## ID seed
  var $mode           = "cookie";          ## We propagate session IDs with cookies (or get)
  var $fallback_mode  = "get";
  var $lifetime       = 0;                 ## 0 = do session cookies, else minutes
  var $that_class     = "AstairsCtSql";  ## name of data storage container class
  var $gc_probability = 100;
  var $allowcache     = "no";              ## "public", "private", or "no"
  var $auto_init = "setup_astairs.php";   // name of auto_init file.
  // var $module         = "files";           ## user, files or mm

	function AstairsPageSession(){
		global $magic_pass_phrase,$dureeSessionBack,$dureeMaxInactifBack;
		
		//remplace la valeur par défaut par la valeur de la configuration de la plateforme
		$this->magic=$magic_pass_phrase;
		$this->gc_time=$dureeSessionBack/60; //duree maximale d'une session en minutes
		$this->gc_inactive=$dureeMaxInactifBack/60;
	}
	
	 /**
  * gc callback.
  *
  * Destroy all session data older than $this->gc_time
  *
  */
  function gc() {
//echo "gargabe collector!";
    if ($this->module == 'user') {
    
      if (empty($this->gc_time)) 
        $this->gc_time = get_cfg_var("session.gc_maxlifetime");
    
	    srand(time());
	    if (true||(rand()%100) < $this->gc_probability) {
	    	return $this->that->ac_gc($this->gc_inactive, $this->name);
	    }
    }
     return true;
//  function gc() {
//    srand(time());
//    if ((rand()%100) < $this->gc_probability) {
//      $this->that->ac_gc($this->gc_time, $this->name);
//    }
//  }
   
  } // end func gc
  	/**
	 * @return integer Duree en minutes
	 */
	function getDureeSessionMax(){
		return $this->gc_time;
	}
	
	/**
	 * @return integer Duree en minutes
	 */
	function getDureeInactifMax(){
		return $this->gc_inactive;
	}
	
	function getName(){
		return $this->name;
	}
}

class AstairsBackSession extends Session_Custom {


  var $classname = "AstairsBackSession";

 var $cookiename     = "";//"AstairsBackOffice";                ## defaults to classname
  var $magic          = "Hocuspocushgkgy1Gygyg76867hgj";      ## ID seed
  var $mode           = "cookie";          ## We propagate session IDs with cookies (or get)
  var $fallback_mode  = "get";
  var $lifetime       = 0;                 ## 0 = do session cookies, else minutes
  var $that_class     = "AstairsCtSql";  ## name of data storage container class
  var $gc_probability = 100;					//defaut a 5
  var $allowcache     = "no";              ## "public", "private", or "no"
  var $auto_init = "setup_astairs.php";   // name of auto_init file.
  var $gc_time = 1440;					//1440 minutes '24h' par d�faut
//  var $gc_inactive= 0;
  // var $module         = "files";           ## user, files or mm

	function AstairsBackSession(){
		global $magic_pass_phrase,$dureeSessionBack,$dureeMaxInactifBack;
		
		//remplace la valeur par défaut par la valeur de la configuration de la plateforme
		$this->magic=$magic_pass_phrase;
		$this->gc_time=sprintf('%d',$dureeSessionBack/60); //duree maximale d'une session en minutes
		$this->gc_inactive=sprintf('%d',$dureeMaxInactifBack/60); //duree maximale d'inactivité pour une session en minutes
	}
	
 /**
  * gc callback.
  *
  * Destroy all session data older than $this->gc_time
  *
  */
  function gc() {
//echo "gargabe collector!";
    if ($this->module == 'user') {
    
      if (empty($this->gc_time)) 
        $this->gc_time = get_cfg_var("session.gc_maxlifetime");
    
	    srand(time());
	    if (true||(rand()%100) < $this->gc_probability) {
	    	return $this->that->ac_gc($this->gc_inactive, $this->name);
	    }
	    
    }
    
    return true;
    
//      function gc() {
//    srand(time());
//    if ((rand()%100) < $this->gc_probability) {
//      $this->that->ac_gc($this->gc_time, $this->name);
//    }
//  }
  } // end func gc
  
  	/**
	 * @return integer Duree en minutes
	 */
	function getDureeSessionMax(){
		return $this->gc_time;
	}
	
	/**
	 * @return integer Duree en minutes
	 */
	function getDureeInactifMax(){
		return $this->gc_inactive;
	}
}

class AstairsFrontSession extends Session_Custom {
  var $classname = "AstairsFrontSession";

 var $cookiename     = "";// "AstairsFrontOffice";                ## defaults to classname
  var $magic          = "Hocuspocushgkgy1Gygyg76867hgj";      ## ID seed
  var $mode           = "cookie";          ## We propagate session IDs with cookies (or get)
  var $fallback_mode  = "get";
  var $lifetime       = 0;                 ## 0 = do session cookies, else minutes
  var $that_class     = "AstairsFrontCtSql";  ## name of data storage container class
  var $gc_probability = 100;
  var $allowcache     = "no";              ## "public", "private", or "no"
  var $auto_init = "setup_astairs.php";   // name of auto_init file.
  // var $module         = "files";           ## user, files or mm
  
	function AstairsFrontSession(){
		global $magic_pass_phrase,$dureeSessionFront,$dureeMaxInactifFront;
//		echo "\$dureeMaxInactifFront=$dureeMaxInactifFront";
		//remplace la valeur par défaut par la valeur de la configuration de la plateforme
		$this->gc_inactive=$dureeMaxInactifFront/60;
		$this->gc_time=sprintf('%d',$dureeSessionFront/60); //duree maximale d'une session en minutes
		$this->gc_inactive=sprintf('%d',$dureeMaxInactifFront/60); //duree maximale d'inactivité pour une session en minutes
	}
	 /**
  * gc callback.
  *
  * Destroy all session data older than $this->gc_time
  *
  */
  function gc() {

    if ($this->module == 'user') {
    
      if (empty($this->gc_time)) 
        $this->gc_time = get_cfg_var("session.gc_maxlifetime");
    
	    srand(time());
	    if (true||(rand()%100) < $this->gc_probability) {
	    	return $this->that->ac_gc($this->gc_inactive, $this->name);
	    }
    }
    
    return true;
  } //
  
  	/**
	 * @return integer Duree en minutes
	 */
	function getDureeSessionMax(){
		return $this->gc_time;
	}
	
	/**
	 * @return integer Duree en minutes
	 */
	function getDureeInactifMax(){
		return $this->gc_inactive;
	}
	
	function setDureeInactifMax($minutes){
		$this->gc_inactive=$minutes;
	}
	
	function getName(){
		return $this->name;
	}
}

/*
class Example_Session_Custom extends Session_Custom {
  var $classname = "Example_Session";

  var $cookiename     = "";                ## defaults to classname
  var $magic          = "Hocuspocus";      ## ID seed
  var $mode           = "cookie";          ## We propagate session IDs with cook
ies
  var $fallback_mode  = "get";
  var $lifetime       = 0;                 ## 0 = do session cookies, else minut
es
  var $that_class     = "Example_CT_Sql";  ## name of data storage container class
  var $gc_probability = 5;
  var $allowcache     = "no";              ## "public", "private", or "no"

  // var $module         = "files";           ## user, files or mm

}
*/

class Example_User extends User {
  var $classname = "Example_User";

  var $magic          = "Abracadabra";     ## ID seed
//  var $that_class     = "Example_CT_Sql";  ## name of data storage container class
var $that_class     = "AstairsCtSql";  ## name of data storage container class
}

//class Example_Auth extends Auth {
//  var $classname      = "Example_Auth";
//
//  var $lifetime       = 15;
//
//  var $database_class = "DbPgsqlAstairs";
//  var $database_table = "auth_user";
//  
//  function auth_loginform() {
//    global $sess;
//    global $_PHPLIB;
//
//    include($_PHPLIB["libdir"] . "loginform.ihtml");
//  }
//  
//  function auth_validatelogin() {
//    global $HTTP_POST_VARS;
//
//    if(isset($HTTP_POST_VARS["username"])) {
//      $this->auth["uname"] = $HTTP_POST_VARS["username"];        ## This provides access for "loginform.ihtml"
//    }
//    
//    $uid = false;
//    
//    $this->db->query(sprintf("select user_id, perms ".
//                             "        from %s ".
//                             "       where username = '%s' ".
//                             "         and password = '%s'",
//                          $this->database_table,
//                          addslashes($HTTP_POST_VARS["username"]),
//                          addslashes($HTTP_POST_VARS["password"])));
//
//    while($this->db->next_record()) {
//      $uid = $this->db->f("user_id");
//      $this->auth["perm"] = $this->db->f("perms");
//    }
//    return $uid;
//  }
//}

//class AstairsAuth extends Auth {
//  var $classname      = "AstairsAuth";
//
//  var $lifetime       = 15;
//
//  var $database_class = "DbPgsqlAstairs";
//  var $database_table = "contraintes.fw_individu";
//  
//  //var $user_id;
//  
//  function auth_loginform($message_erreur="") {
//    global $sess;
//    global $_PHPLIB;
//    global $chemin_bo,$root;
//    global $ERROR_102;
//    global $chemin_fo,$nom_site_front;
//
//	if(empty($dbpath))$dbpath="."; 
//	
//    //D�finition des variables
//	$page_lang = "fr";
//	$page_encoding = "UTF8";
//	$page_style_path = "$dbpath/$nom_site_front/styles/afide";
//	$page_javascript_path = "$dbpath/$nom_site_front/javascript";
//	$page_resolution = 'res_800x600';
//	
//	//les templates de base
//	$base_templates = array(
//		'structure' => 'structure_xhtml11.tpl',
//		'meta' => 'meta.tpl',
//		'style' => 'style.tpl',
//		'javascript' => 'javascript.tpl',
//		'internal_javascript' => 'internal_javascript.tpl',
//		'content' => 'content.tpl');
//	
//	//le constructeur de page g�n�rique
//	$page_builder=new PageBuilder(
//							$root."lib/framework/templates/tpl",
//							$base_templates,
//							$page_lang,
//							$page_encoding,
//							$page_style_path,
//							$page_javascript_path,
//							$page_resolution,
//							"$chemin_bo/connexion/templates/tpl");
//							
//	print_rr($page_builder);
//	//les styles
//	$liste_style_files=list_file($page_builder->getStylePath());
//	$style_files=array();
//	if(is_array($liste_style_files)){
//		foreach($liste_style_files as $s=>$style_file){
//			foreach($style_file as $style_file_path=>$style_file_name){
//				$style_files[$style_file_path][]=$style_file_name;	
//			}
//		}
//	}
//	messageDebugR("Fichier CSS charg�s:",$style_files);	
//		
//	//les fichiers javascripts
//	$javascript_files=array();
//	messageDebugR("Fichier javascript charg�s:",$javascript_files);	
//	
//	//le javascript interne
//	$javascript_internal_code="";
//	messageDebug("Code javascript charg�:<br>$javascript_internal_code");	
//	
//	//les �l�ments pour la page
//	$page_debut=new ConnexionPageDebut($page_builder->getModuleRoot(),array('debut' => 'debut_connexion.tpl'));
//	$page_contenu=new ConnexionPageContenu($page_builder->getModuleRoot(),array('contenu' => 'contenu_connexion.tpl'));
//	$page_fin=new ConnexionPageFin($page_builder->getModuleRoot(),array('fin' => 'fin_connexion.tpl'));
//	
//	//la page sp�cifique
//	$page=new ConnexionPage($page_builder, array('page_dev' => 'connexion.tpl'),$style_files,$javascript_files,$javascript_internal_code);
//	
//	//affectation des �l�ments
//	$page->setComponent('DEBUT', $page_debut);
//	$page->setComponent('CONTENU', $page_contenu);
//	$page->setComponent('FIN',$page_fin);
//	
//	//debug
////	print_rr($page);
////	print_rr($this);
//
//	//on parse
//	$page->parse();
//	
//	//on affiche
//	$page->p();
//  }
//  
//  function auth_validatelogin() {
//    global $HTTP_POST_VARS,$ERROR_102;
// 	global $sess, $user_id;
//    
//    if(isset($HTTP_POST_VARS["user"])) {
//      $this->auth["uname"] = $HTTP_POST_VARS["user"];        ## This provides access for "loginform.ihtml"
//    }
//    
//    $uid = false;
//    
//    //cas ou le formulaire est valid�
//    if((isset($HTTP_POST_VARS["user"]))&&(isset($HTTP_POST_VARS["mdp"]))){
//    	$this->db->query(sprintf("select id, identifiant_md5, perms ".
//                             "        from %s ".
//                             "       where login = '%s' ".
//                             "         and password = '%s'",
//                          $this->database_table,
//                          addslashes($HTTP_POST_VARS["user"]),
//                          addslashes($HTTP_POST_VARS["mdp"])));
//	    while($this->db->next_record()) {
//	   	  $this->auth["user_id"]=$this->db->f("id");
//	   	  $user_id=$this->db->f("id");
//	      $this->auth["perm"] = $this->db->f("perms");
//	      $uid = $this->db->f("identifiant_md5");
//	    }
//	    if($this->db->num_rows()==0){
//	     	$this->auth["MSG_ERROR"] =$ERROR_102;
//		}else{
//			unset($this->auth["MSG_ERROR"]);
//		}
//    }else{
//			unset($this->auth["MSG_ERROR"]);
//	}
//    return $uid;
//  }
//  
//  function getUserId(){
//  	return $this->auth["user_id"];
//  }
//}

//class Example_Default_Auth extends Example_Auth {
//  var $classname = "Example_Default_Auth";
//  
//  var $nobody    = true;
//}

# A variation of Example_Auth which uses a Challenge-Response
# Authentication. The password never crosses the net in clear,
# if the remote system supports JavaScript. Please read the
# Documentation section about CR Authentication to understand
# what is going on.
/*
class Example_Challenge_Auth extends Auth {
  var $classname      = "Example_Challenge_Auth";

  var $lifetime       =  1;

  var $magic          = "Simsalabim";  ## Challenge seed
  var $database_class = "DbPgsqlAstairs";
  var $database_table = "auth_user";

  function auth_loginform() {
    global $sess;
    global $challenge;
    global $_PHPLIB;
    
    $challenge = md5(uniqid($this->magic));
    $sess->register("challenge");
    
    include($_PHPLIB["libdir"] . "crloginform.ihtml");
  }
  
  function auth_validatelogin() {
    global $HTTP_POST_VARS, $challenge;

    if(isset($HTTP_POST_VARS["username"])) {
      $this->auth["uname"] = $HTTP_POST_VARS["username"];        ## This provides access for "loginform.ihtml"
    }
    $this->db->query(sprintf("select user_id, perms, password ".
                "from %s where username = '%s'",
                          $this->database_table,
                          addslashes($HTTP_POST_VARS["username"])));

    if ($this->db->num_rows() == 0) {
      return false;
    }

    while($this->db->next_record()) {
      $uid   = $this->db->f("user_id");
      $perm  = $this->db->f("perms");
      $pass  = $this->db->f("password");
    }
    $expected_response = md5("$HTTP_POST_VARS[username]:$pass:$challenge");

    ## True when JS is disabled
    if ($HTTP_POST_VARS["response"] == "") {
      if ($HTTP_POST_VARS["password"] != $pass) {
        return false;
      } else {
        $this->auth["perm"] = $perm;
        return $uid;
      }
    }
    
    ## Response is set, JS is enabled
    if ($expected_response != $HTTP_POST_VARS["response"]) {
      return false;
    } else {
      $this->auth["perm"] = $perm;
      return $uid;
    }
  }
}*/

##
## Another variation of Challenge-Response authentication,
## done slightly differently. This one does not keep cleartext
## passwords in your database table. 
##
## Example_Challenge_Crypt_Auth: Keep passwords in md5 hashes rather 
##                           than cleartext in database
## Author: Jim Zajkowski <jim@jimz.com>
/*
class Example_Challenge_Crypt_Auth extends Auth {
  var $classname      = "Example_Challenge_Crypt_Auth";

  var $lifetime       =  1;

  var $magic          = "Frobozzica";  ## Challenge seed
  var $database_class = "DB_Example";
  var $database_table = "auth_user_md5";

  function auth_loginform() {
    global $sess;
    global $challenge;
    global $_PHPLIB;
    
    $challenge = md5(uniqid($this->magic));
    $sess->register("challenge");
    
    include($_PHPLIB["libdir"] . "crcloginform.ihtml");
  }
  
  function auth_validatelogin() {
    global $HTTP_POST_VARS, $challenge;

    $this->auth["uname"] = $HTTP_POST_VARS["username"];        ## This provides access for "loginform.ihtml"
    
    $this->db->query(sprintf("select user_id, perms, password ".
                "from %s where username = '%s'",
                          $this->database_table,
                          addslashes($HTTP_POST_VARS["username"])));

    if ($this->db->num_rows() == 0) {
      return false;
    }

    while($this->db->next_record()) {
      $uid   = $this->db->f("user_id");
      $perm  = $this->db->f("perms");
      $pass  = $this->db->f("password");   ## Password is stored as a md5 hash
    }
    $expected_response = md5("$HTTP_POST_VARS[username]:$pass:$challenge");

    ## True when JS is disabled
    if ($HTTP_POST_VARS["response"] == "") {
      if (md5($HTTP_POST_VARS["password"]) != $pass) {       ## md5 hash for non-JavaScript browsers
        return false;
      } else {
        $this->auth["perm"] = $perm;
        return $uid;
      }
    }
    
    ## Response is set, JS is enabled
    if ($expected_response != $HTTP_POST_VARS["response"]) {
      return false;
    } else {
      $this->auth["perm"] = $perm;
      return $uid;
    }
  }
}*/

## An example implementation of a Perm subclass, implementing
## a few atomic permissions. You want to read up on Permission
## schemata design in the documentation.

//class Example_Perm extends Perm {
//  var $classname = "Example_Perm";
//  
//  var $permissions = array(
//                            "user"       => 1,
//                            "author"     => 2,
//                            "editor"     => 4,
//                            "supervisor" => 8,
//                            "admin"      => 16
//                          );
//
//  function perm_invalid($does_have, $must_have) {
//    global $perm, $auth, $sess;
//    global $_PHPLIB;
//    
//    include($_PHPLIB["libdir"] . "perminvalid.ihtml");
//  }
//}

//class AstairsPerm extends Perm {
//  var $classname = "AstairsPerm";
//  
//  var $permissions = array(
//                            "user"       => 1,
//                            "author"     => 2,
//                            "editor"     => 4,
//                            "supervisor" => 8,
//                            "admin"      => 16
//                          );
//
//  function perm_invalid($does_have, $must_have) {
//    global $perm, $auth, $sess;
//    global $_PHPLIB;
//    
//    include($_PHPLIB["libdir"] . "perminvalid.ihtml");
//  }
//}

/**
 * Gestion des permissions pour Astairs.
 * 
 * Cet objet défini les permissions comme étant les codes de types d'individus.
 * 
 * Cette classe est à utiliser pour la gestion des permissions sur les pages
 * ne correspondant pas à un objet Module ($_SESSION['obj_module']).
 * 
 */
class AstairsPerm extends Perm {
	
	/**
	 * Nom de la classe
	 * @var string $classname
	 */
	var $classname = "AstairsPerm";
	
	/**
	 * Permissions (codes de types d'individus)
	 * @var string $permissions Une chaine contenant les codes séparés par des ','
	 */
  	var $permissions;
  	
  	/**
	 * Classe de gestion de Base de données pour le chargement des permissions
	 * @var string $db
	 */
  	var $db;
  	
  	function AstairsPerm(){
		$this->db = new DB_Permission;
//		$this->db = new DB_AstairsPermission;
  		$this->loadPerms();
  	}
  	
  	function loadPerms(){
		$this->db->query(sprintf(	"select id, libelle, code ".
									"from %s order by id" ,
	                      			$this->db->database_table));
	
		if ($this->db->num_rows() == 0) {
			return false;
		}
		$perm_bit=1;
		while($this->db->next_record()) {
			$this->permissions[$this->db->f("code")] = $perm_bit;
			$perm_bit=$perm_bit*2;
	    }
  	}
  	
//  	function getPerms(){
//		$this->db->query(sprintf(	"select id, libelle, code ".
//									"from %s order by id" ,
//	                      			$this->db->database_table));
//	
//		if ($this->db->num_rows() == 0) {
//			return false;
//		}
//		$perm_bit=1;
//		$permissions=array();
//		while($this->db->next_record()) {
//			$permissions[$this->db->f("code")] = $perm_bit;
//			$perm_bit=$perm_bit*2;
//	    }
//	    return $permissions;
//  	}
  	
	function perm_invalid($does_have, $must_have) {
    	global $perm, $auth, $sess,$root;
    	global $_PHPLIB;
    
    	include("$root/lib_graphique/pages/" . "perminvalid.ihtml");
	}
	
	function is_root() {
	    global $auth;
	    
	    if (( is_array($auth->auth["perm"]->permissions['root'])) &&(count($auth->auth["perm"]->permissions['root'])>0)) {
			return true;
	    }
		return false;
	}
}

class AstairsFrontPerm extends Perm {
	
	/**
	 * Nom de la classe
	 * @var string $classname
	 */
	var $classname = "AstairsFrontPerm";
	
	/**
	 * Permissions (droits)
	 * @var string $permissions Une chaine contenant les droits séparés par des ','
	 */
  	var $permissions;
  	
  	/**
	 * Classe de gestion de Base de données pour le chargement des permissions
	 * @var string $db
	 */
  	var $db;
  	
  	function AstairsFrontPerm(){
		$this->db = new DB_FrontPermission;
  		$this->loadPerms();
  	}
  	
  	function loadPerms(){
  		global $obj_DoFormation;
  		
  		//if(!is_object($obj_DoFormation)){
  			
  			//inutile??
			$this->db->query(sprintf(	"select id, libelle, code,type, defaut ".
										"from %s where type=2 order by id" ,
		                      			$this->db->database_table));
		
			if ($this->db->num_rows() == 0) {
				//print("Pas de permissions");			
				return false;
			}else{
				//print("permissions touv�es:".$this->db->num_rows()."</br>");	
			}
			
		
  		/*}else{
  			//inutile??
			$this->db->query(sprintf(	"select D.id, D.libelle, D.code, D.type, D.defaut ".
										"from contraintes.droit D, " .
										"contraintes.individu_droits ID, " .
										"contraintes.formation_participants FP " .
										"where D.id= ID.droit AND ID.classe=FP.classe " .
										"AND D.type=2 " .
										"AND FP.formation=%s " .
										"AND ID.individu=%s " .
										"order by D.id" ,
										$obj_DoFormation->getFormation(),
										$obj_DoFormation->getIndividu(),
		                      			$this->db->database_table));
		
			if ($this->db->num_rows() == 0) {
				//print("Pas de permissions");			
				return false;
			}else{
				//print("permissions touv�es:".$this->db->num_rows()."</br>");	
			}
			
  		}*/
		$perm_bit=1;
		while($this->db->next_record()) {
			$tmp_permissions[]= $this->db->f("code");
			
			$this->permissions[$this->db->f("code")] = $perm_bit;
			$perm_bit=$perm_bit*2;
	    }
//	    $this->permissions=implode(',',$tmp_permissions);
//	    echo "permissions:<br><pre>";
//		print_r($this->permissions);
//		echo"</pre>";
  	}
  	
	function perm_invalid($does_have, $must_have) {
    	global $perm, $auth, $sess,$root;
    	global $_PHPLIB;
    
    	include("$root/lib_graphique/pages/" . "frontperminvalid.ihtml");
    	include("$root/pied_page.php");
    	exit();
	}
	
	function getPermissions(){
		return $this->permissions;
	}
}

class AstairsModulePerm extends Perm {
	
	var $classname = "AstairsModulePerm";
  	var $permissions;
  	var $db;
  	var $module_id;
  	
  	function AstairsModulePerm($module_id){
  		$this->module_id=$module_id;
		$this->db = new DB_ModulePermission;
//		$this->db = new DB_AstairsPermission;
  		$this->loadPerms();
  	}
  	
  	
  /**
   *Permission code
   */
  function check($p) {
    global $auth;

    if (! $this->have_perm($p)) {    
      if (! isset($auth->auth["perm"]) ) {
        $auth->auth["perm"] = "";
      }
      $this->perm_invalid(eval_string_langues_messages(get_plateforme_individus_types_libelles_by_codes(explode(',',$auth->auth["perm"]))), $p);
      exit();
    }
  }
  
  	
  	function loadPerms(){
  		if(!empty( $this->module_id)){
		$this->db->query(sprintf(	"select T.code as profile, D.code as droit ".
									"from %s  , contraintes.fw_individu_type T , contraintes.fw_droit D " .
									"where individu_type=T.id " .
									"and module=%s and D.id=droit order by T.code, T.code" ,
	                      			$this->db->database_table, $this->module_id));
  		}
		if (empty( $this->module_id)||$this->db->num_rows() == 0) {
			return false;
		}
		$this->permissions=array();
		$perm_bit=1;
		$cur_pro=null;
		while($this->db->next_record()) {
//			$tmp_permissions[]= $this->db->f("code");
			$profile=$this->db->f("profile");
			if($cur_pro!=$profile){
				$cur_pro=$profile;
				$perm_bit=1;
			}
			$this->permissions[$profile][$this->db->f("droit")] = $perm_bit;
			$perm_bit=$perm_bit*2;
	    }
  	}
	function perm_invalid($does_have, $must_have) {
    	global $perm, $auth, $sess,$root,$obj_module;
    	global $_PHPLIB;
    
    	include("$root/lib_graphique/pages/" . "moduleperminvalid.ihtml");
    	include("$root/pied_page.php");
    	exit();
	}
	
	function page_perm_invalid($does_have, $must_have) {
    	global $perm, $auth, $sess,$root;
    	global $_PHPLIB;
    
    	include("$root/lib_graphique/pages/" . "pageperminvalid.ihtml");
    	include("$root/pied_page.php");
    	exit();
	}
	
	function have_perm($p) {
	    global $auth;
	    
	    //permission utilisateurs:
	    // profils tels que u, f, root, etc...
	    if (! isset($auth->auth["perm"]) ) {
	      $auth->auth["perm"] = "";
	    }
	    $userperm = split(",", $auth->auth["perm"]);
	    
	    //permissions à tester
	    // permissions telles que ADD, LST, etc...
    	$pageperm = split(",", $p);
    
    	//pour chacun des profils, on regarde si le droit est présent
	    foreach($userperm as $key => $profile){
	    	
	    	if($profile=='root')return true;
	    	list ($ok0, $pagebits) = $this->permsum_profile($pageperm,$profile);
	    	if($ok0) return true;
	    }
		return false;
	}

	function is_root() {
	    global $auth;
	    
	    if (( is_array($auth->auth["perm"]->permissions['root'])) &&(count($auth->auth["perm"]->permissions['root'])>0)) {
			return true;
	    }
		return false;
	}

	/**
	 * Retourne la somme des droits valides 
	 * passés en parametres , pour un profile
	 */
   	function permsum_profile($p,$profile) {
    global $auth;
    if (!is_array($p)) {
      return array(false, 0);
    }
    $perms = $this->permissions;
    $r = 0;
    reset($p);
    while(list($key, $val) = each($p)) {
      if (!isset($perms[$profile][$val])) {
        return array(false, 0);
      }
      $r |= $perms[$profile][$val];
    }
    return array(true, $r);
   }
}


##
## Example_Menu may extend Menu.
## Remember that in PHP 3 a class's constructor function must have the 
## same name as the class. To make it easier to extend this class we 
## have a real constructor function called setup(). When you create an
## extension of this class, create your constructor function which only
## needs to call setup().
##
## To use this, you must enable the require statement for
## menu.inc in prepend.php3.
##
## See /pages/menu for an example application of Example_Menu.
##

// class Example_Menu extends Menu {
//   var $classname = "Example_Menu";
//
//   # Map of PHP_SELF URL strings to menu positions
//   var $urlmap = array(
//     "/bac_a_sable/AstairsV2/menu/index.php3"   => "",
//     "/bac_a_sable/AstairsV2/menu/item1.php3"   => "/1",
//     "/bac_a_sable/AstairsV2/menu/item11.php3"  => "/1/1",
//     "/bac_a_sable/AstairsV2/menu/item12.php3"  => "/1/2",
//     "/bac_a_sable/AstairsV2/menu/item13.php3"  => "/1/3",
//     "/bac_a_sable/AstairsV2/menu/item2.php3"   => "/2",
//     "/bac_a_sable/AstairsV2/menu/item21.php3"  => "/2/1",
//     "/bac_a_sable/AstairsV2/menu/item22.php3"  => "/2/2",
//     "/bac_a_sable/AstairsV2/menu/item221.php3" => "/2/2/1",
//     "/bac_a_sable/AstairsV2/menu/item222.php3" => "/2/2/2",
//     "/bac_a_sable/AstairsV2/menu/item23.php3"  => "/2/3",
//     "/bac_a_sable/AstairsV2/menu/item24.php3"  => "/2/4"
//   );
//   
//   # Information about each menu item
//   var $item = array(
//     ""      => array("title" => "Main"),
//     "/1"    => array("title" => "Text 1"),
//     "/1/1"  => array("title" => "Text 1.1"),
//     "/1/2"  => array("title" => "Text 1.2"),
//     "/1/3"  => array("title" => "Text 1.3"),
//     "/2"    => array("title" => "Text 2"),
//     "/2/1"  => array("title" => "Text 2.1"),
//     "/2/2"  => array("title" => "Text 2.2", "pseudo" => true),
//     "/2/2/1"=> array("title" => "Text 2.2.1"),
//     "/2/2/2"=> array("title" => "Text 2.2.2"),
//     "/2/3"  => array("title" => "Text 2.3"),
//     "/2/4"  => array("title" => "Text 2.4")
//   );
//
//   function Example_Menu() {
//     $this->setup();
//   }
//
// }

?>
