<?php
/*
 * Session Management for PHP3
 *
 * Copyright (c) 1998-2000 NetUSE AG
 *                    Boris Erdmann, Kristian Koehntopp
 *
 * $Id: page4.inc,v 1.1 2002/10/04 14:13:27 joestewart Exp $
 *
 */ 

function page_open($feature) {
  global $_PHPLIB;

  # enable sess and all dependent features.
  if (isset($feature["sess"])) {
    global $sess;
    $sess = new $feature["sess"];
    $sess->start();
    
    # the auth feature depends on sess
    if (isset($feature["auth"])) {
      global $auth;
//      echo "ici";
      if (is_object($auth)) {
//      	echo "icii";
        $auth= $auth->check_feature($feature["auth"]);
      } else {
//      	echo "iciii";
        $auth = new $feature["auth"];
      }
      $auth->start();
  
      # the perm feature depends on auth and sess
      if (isset($feature["perm"])) {
        global $perm;
        if (!is_object($perm)) {
          $perm = new $feature["perm"];
        }
      }
      # the user feature depends on auth and sess
      if (isset($feature["user"])) {
        global $user;
        
        if (!is_object($user)) {
          $user = new $feature["user"];
        }
        $user->start($auth->auth["uid"]);
      }
    }

    ## Load the auto_init-File, if one is specified.
    if (($sess->auto_init != "") && !$sess->in) {
      $sess->in = 1;
      include($_PHPLIB["libdir"] . $sess->auto_init);
      if ($sess->secure_auto_init != "") {
        $sess->freeze();
      }
    } 
  }
}


function module_open(&$obj_module) {
  global $sess;
  global $auth;
   global $perm;
  if (is_object($sess)) {
     if (is_object($auth)) {
      	//the perm feature depends on auth and sess
        if (is_object($obj_module)) {
			$obj_module->loadPerms();
			$perm =$obj_module->permissions;   
		}
     }
  }
}

function module_check($obj_module){
	global $auth;
   	global $perm;
//   print_rr($perm);


	if($auth->is_root())return true;
	$tmp_perms=explode(',',$auth->auth["perm"]);
	
	if(count($perm->permissions)>0){
	          $individu_type_found=false;
	          foreach($tmp_perms as $profile){
	          	
	          	if(count($perm->permissions[$profile])>0){
	          		$individu_type_found=true;
	          		continue;
	          	}
	          }
	          if(!$individu_type_found){
	          	$perm->perm_invalid(eval_string_langues_messages(get_plateforme_individus_types_libelles_by_codes(explode(',',$auth->auth["perm"]))),get_langue_message($obj_module->getLibelle()));
//	          	print_rr($perm->permissions);	       
//    			echo "<br><b>module sans permissions pour ce profile</b></br>";
//				exit();
	          }
	}
    else{
    	$perm->page_perm_invalid(eval_string_langues_messages(get_plateforme_individus_types_libelles_by_codes(explode(',',$auth->auth["perm"]))),get_langue_message($obj_module->getLibelle()));
//    	echo "<br><b>module sans permissions</b></br>";
//    	exit();
    }
}

function page_close() {
  global $sess, $user;

  if (is_object($sess)) {
    $sess->freeze();
    if (is_object($user)) {
      $user->freeze();
    }
  }
}

function sess_load($session) {
  reset($session);
  while (list($k,$v) = each($session)) {
    $GLOBALS[$k] = new $v;
    $GLOBALS[$k]->start();
  }
}

function sess_save($session) {
  reset($session);
  while (list(,$v) = each($session)) {
    $GLOBALS[$v]->freeze();
  }
}
?>
