<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL

  @package critere
  @modulegroup plpgsql
  @module plpgsql_critere
*/

//include("$chemin_bo/lib/critere/plpgsql_deprecated_critere.inc");
include("$root/lib/critere/plpgsql_deprecated_critere.inc");

/**
	Teste si un critere est supprimable (OLD)
	@param integer : numero critere
	@return bool : true supprimable,false sinon
*/
function check_critere_supprimable_old($critere){
	if(!check_critere_corrections($critere) && !check_critere_modeles($critere))
        return true;
    else
        return false;
}
/**
	Teste si un critere est supprimable 
	@param integer : numero critere
	@return bool : true supprimable,false sinon
*/
function check_critere_supprimable($critere){
	if(VERSION_BASE>VERSION){
		$res=!fk_finder('critere','id',$critere);
	}
	else
		$res=check_critere_supprimable_old($critere);
	return $res;
}

/**
	Obtenir les informations d'un critere ou d'un sous critere.
	Si la fonction est appelle avec un parametre, cherche un sous critre,
	si le deuxieme parametre est un entier positif, rajoute le numero de critere dans la requete.
	
	Les informations obtenues sont:
		pour un critere:
			num_rub  |   libelle_rub |  rub_numtheme
		pour un sous critere
			num_srub  |   libelle_srub |  srub_numtheme | num_rub
			
  	@param integer: identifiant en base du sopus critere
  	@param integer: identifiant en base du critere(facultatif)
	@return integer: l'entier resultat de la requete
*/
function get_critere_old($id, $num_rub=""){

	if(isset($num_rub)&&($num_rub!="")){
		$req="SELECT * FROM sousrubrique WHERE num_srub=$id ";
		if($num_rub>0)$req.=" AND num_rub=$num_rub";
        //echo $req."<br>";
        $res=pg_query($req);
	}
	else{
		$req="SELECT * FROM rubrique WHERE num_rub=$id";
        //echo $req."<br>";
        $res=pg_query($req);
	}	
        
        return $res;

}

/**
	Obtenir les informations d'un critere ou d'un sous critere.
	Si la fonction est appellee avec un parametre, cherche un sous critere,
	si le deuxieme parametre est un entier positif, rajoute le numero de critere dans la requete.
	
	Les informations obtenues sont:
		pour un critere:
			num_rub  |   libelle_rub |  rub_numtheme
		pour un sous critere
			num_srub  |   libelle_srub |  srub_numtheme | num_rub
			
  	@param integer: identifiant en base du sopus critere
  	@param integer: identifiant en base du critere(facultatif)
	@return integer: l'entier resultat de la requete
*/
function get_critere($id, $num_rub=""){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_critere($id) as (id int4,libelle varchar,theme int4,pere int4)";
		$res=pg_query($sql);

	}
    else{
		if(isset($num_rub)&&($num_rub!="")){
			$res= get_critere_old($id, $num_rub);
		}
        else{
			$res= get_critere_old($id);
		}
	}
    return ($res);
}



/**
	Obtenir les sous criteres pour un critere de correction
	resultat retourne:
	num_srub | libelle_srub | srub_numtheme | num_rub

	@param $critere numrero du critere dont on veut les sous criteres
	@return integer l'entier resultat
*/
function get_critere_sous_criteres_old($critere){

        $req="	SELECT * FROM sousrubrique
        			WHERE num_rub=$critere";

        $res=pg_query($req);

		return $res;
}

/**
	Obtenir les sous criteres pour un critere de correction
	resultat retourn:
	num_srub | libelle_srub | srub_numtheme | num_rub

	@param $critere numrero du critere dont on veut les sous criteres
	@return integer l'entier resultat (id int4,libelle varchar,theme int4,pere int4)
*/
function get_critere_sous_criteres($critere){
	if(VERSION_BASE>VERSION){
		 $sql="select * from contraintes.af_get_critere_sous_criteres($critere) as (id int4,libelle varchar,theme int4,pere int4)";
		 $res=pg_query($sql);
	}
    else{
		$res=get_critere_sous_criteres_old($critere);
	}
    return ($res);
}

/**
    Enregistrer un critere (OLD)
*
*   @param string :  le libelle du critere
*   @param integer : le numero du theme
*   @return integer : le numero du critere si ok sinon 0
*/
function set_critere_old($libelle,$theme){
    if(!check_critere_libelle_theme($libelle,$theme)){
        $sql="insert into rubrique(libelle_rub,rub_numtheme) values('$libelle',$theme)";
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_rub from rubrique where oid=$oid");
        return (pg_result($res,0,0));
    }
    else
        return 0;
}
/**
    Enregistrer un critere
*
*   @param string :  le libelle du critere
*   @param integer : le numero du theme
*   @return integer : le numero du critere
*/
function set_critere($libelle,$theme,$pere){
    if(VERSION_BASE>VERSION){
	    $sql="select * from contraintes.af_set_critere('$libelle',$pere)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
		// enregistrement ds theme_categorie
		set_categorie_element_theme(12,$theme,pg_fetch_result($res,0,0));
    }
    else{
        $res=set_critere_old($libelle,$theme);
    }
    return ($res);
}


/**
    Mettre  jour le nom d'un critere (OLD)
*
*   @param integer : le numero du critere
*   @param string : le libelle du critere
*   @param integer : le numero du theme
*   @return integer : 1 si ok, 0 si ERREUR
*/
function maj_critere_old($critere,$libelle,$theme){
    if(!check_critere_libelle_theme($libelle,$theme)){
        $sql="update rubrique set libelle_rub='$libelle' where num_rub=$critere";
        $maj=pg_query($sql);
        return 1;
    }
    else
        return 0;
}
/**
    Mettre  jour le nom d'un critere
*
*   @param integer : le numero du critere
*   @param string : le libelle du critere
*   @param integer : le numero du theme
*   @return integer : 1 si ok, 0 si ERREUR
*/
function maj_critere($critere,$libelle,$theme){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_critere($critere,'$libelle')";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else{
        $res=maj_critere_old($critere,$libelle,$theme);
    }
    return ($res);
}

/**
    Mettre  jour le nom d'un sous critere (OLD)
*
*   @param integer : le numero du sous critere
*   @param string : le libelle du sous critere
*   @param integer : le numero du theme
*   @param integer : le numero du critere
*   @return integer : 1 si ok, 0 si ERREUR
*/
function maj_souscritere_old($souscritere,$libelle,$theme,$critere){
    if(!check_souscritere_libelle_theme_critere($libelle,$theme,$critere)){
        $sql="update sousrubrique set libelle_srub='$libelle' where num_srub=$souscritere";
        $maj=pg_query($sql);
        return 1;
    }
    else
        return 0;
}
/**
    Mettre  jour le nom d'un sous critere
*
*   @param integer : le numero du sous critere
*   @param string : le libelle du sous critere
*   @param integer : le numero du theme
*   @param integer : le numero du critere
*   @return integer : 1 si ok, 0 si ERREUR
*/
function maj_souscritere($souscritere,$libelle,$theme,$critere){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=maj_souscritere_old($souscritere,$libelle,$theme,$critere);
    }
    return ($res);
}

/**
    Supprimer un critere de correction (OLD)
*
*   @param integer : le numero du critere
*   @return integer : 1
*/
function del_critere_old($critere){
    $sql="delete from rubrique where num_rub=$critere";
    $del=pg_query($sql);
    $sql="delete from sousrubrique where num_rub=$critere";
    $del=pg_query($sql);
    return 1;
}
/**
    Supprimer un critere de correction
*
*   @param integer : le numero du critere
*   @return integer : 1
*/
function del_critere($critere){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_critere($critere)";
		$res=pg_query($sql);
    }
    else{
        $res=del_critere_old($critere);
    }
    return ($res);
}

/**
    Supprimer un sous critere de correction (OLD)
*
*   @param integer : le numero du souscritere
*   @return integer : 1
*/
function del_souscritere_old($souscritere){
    $sql="delete from sousrubrique where num_srub=$souscritere";
    $del=pg_query($sql);
    return 1;
}
/**
    Supprimer un sous critere de correction
*
*   @param integer : le numero du sous critere
*   @return integer : 1
*/
function del_souscritere($souscritere){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=del_souscritere_old($souscritere);
    }
    return ($res);
}
?>