<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL

  Ce fichier contient toutes les fonctions necessaires l'interrogation des bd pour la
  plateforme . Chacunes de ces fonctions a 2 fonctions equivalentes: l'une prefixe par
 _af_ en base, et l'autre suffuxe par _old dans le script.

 CONVENTION PROPOSEE:

 Le maximum des requetes SQL doivent etre ecritent sous la forme de fonctions
 en PLPGSQL en base, c'est a dire la totalite des requetes retournant  une valeur.

 Les requetes retournant plusieurs lignes ne pouvant etre traitees ainsi, elles doivent
 etre ecrite sous la forme de fonctions PHP qui retournent une variable resultat (pg_exec)


 CONVENTION DE NOMAGE :
 Il faut etablir une correspondance entre le nom de la fonction php et le nom de la fonction
 PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci pres que le nom de
  la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
 Exemple:

 la fonction php function check_access($droit, $cal, $user) correspond a _af_check_access dans la base

       @package critere
       @modulegroup plpgsql
*/





/**
	Obtenir les sous criteres pour un critere de correction
	resultat retourne:
	num_srub | libelle_srub | srub_numtheme | num_rub

	@param $critere numrero du critere dont on veut les sous criteres
	@return integer l'entier resultat
*/
function get_criteres_sous_criteres_old($critere){

        $req="	SELECT * FROM sousrubrique
        			WHERE num_rub=$num_rub";

        $res=pg_query($req);

		return $res;
}

/**
	Obtenir les sous criteres pour un critere de correction
	resultat retourn:
	num_srub | libelle_srub | srub_numtheme | num_rub

	@param $critere numrero du critere dont on veut les sous criteres
	@return integer l'entier resultat
*/
function get_criteres_sous_criteres($critere){

	        if(VERSION_BASE>VERSION)
            {

            }
            else{
            	$res=get_criteres_sous_criteres_old($critere);
            }
            return ($res);
}


/**
    Vrifier si un critre est utilis pour les corrections (OLD)
*
*   @param integer :  numrero du critere
*   @return bool : true si utilis
*/
function check_critere_corrections_old($critere){
    $sql="select * from gestexotlc where gesttlc_rub=$critere";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return true;
    return false;
}
/**
    Vrifier si un critre est utilis pour les corrections
*
*   @param integer :  numrero du critere
*   @return bool : true si utilis
*/
function check_critere_corrections($critere){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=check_critere_corrections_old($critere);
    }
    return ($res);
}

/**
    Vrifier si un sous-critre est utilis pour les corrections (OLD)
*
*   @param integer :  numrero du sous-critere
*   @return bool : true si utilis
*/
function check_souscritere_corrections_old($souscritere){
    $sql="select * from gestexotlc where gesttlc_srub=$souscritere";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return true;
    return false;
}
/**
    Vrifier si un critre est utilis pour les corrections (OLD)
*
*   @param integer :  numrero du critere
*   @return bool : true si utilis
*/
function check_souscritere_corrections($souscritere){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=check_souscritere_corrections_old($souscritere);
    }
    return ($res);
}

/**
    Vrifier si un critre est utilis pour les modeles de correction (OLD)
*
*   @param integer :  numrero du critere
*   @return bool : true si utilis
*/
function check_critere_modeles_old($critere){
    $sql="select * from correction_modele_asso where num_rub=$critere";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return true;
    return false;
}
/**
    Vrifier si un critre est utilis pour les corrections
*
*   @param integer :  numrero du critere
*   @return bool : true si utilis
*/
function check_critere_modeles($critere){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=check_critere_modeles_old($critere);
    }
    return ($res);
}

/**
    Vrifier si un sous-critre est utilis pour les modeles de correction (OLD)
*
*   @param integer :  numrero du sous-critere
*   @return bool : true si utilis
*/
function check_souscritere_modeles_old($souscritere){
    $sql="select * from correction_modele_asso where num_srub=$souscritere";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return true;
    return false;
}
/**
    Vrifier si un critre est utilis pour les corrections (OLD)
*
*   @param integer :  numrero du souscritere
*   @return bool : true si utilis
*/
function check_souscritere_modeles($souscritere){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=check_souscritere_modeles_old($souscritere);
    }
    return ($res);
}

/**
    Obtenir les infos d'un critere  (OLD)
*
*   @param integer :  numerero du critere
*   @return integer : le resulatat de la requete
*/
function get_critere_infos_old($critere){
    $sql="select * from rubrique where num_rub=$critere";
    return (pg_query($sql));
}
/**
    Obtenir les infos d'un critere
*
*   @param integer :  numerero du critere
*   @return integer : le resulatat de la requete
*/
function get_critere_infos($critere){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=get_critere_infos_old($critere);
    }
    return ($res);
}

/**
    Obtenir les infos d'un sous critere  (OLD)
*
*   @param integer :  numerero du sous critere
*   @return integer : le resulatat de la requete
*/
function get_critere_souscritere_infos_old($souscritere){
    $sql="select * from sousrubrique where num_srub=$souscritere";
    return (pg_query($sql));
}
/**
    Obtenir les infos d'un sous critere
*
*   @param integer :  numerero du souscritere
*   @return integer : le resulatat de la requete
*/
function get_critere_souscritere_infos($souscritere){
    if(VERSION_BASE>VERSION){
		
    }
    else{
        $res=get_critere_souscritere_infos_old($souscritere);
    }
    return ($res);
}

/**
    Verifier si un libelle de critere existe deja (OLD)
*
*   @param string :  le libelle du critere
*   @param integer : le numero du theme
*   @return bool : (true=existe)
*/
function check_critere_libelle_theme_old($libelle,$theme){
    $sql="select num_rub from rubrique where libelle_rub='$libelle' and rub_numtheme=$theme";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return false;
    else
        return true;
}
/**
    Verifier si un libelle de critere existe deja
*
*   @param string :  le libelle du critere
*   @param integer : le numero du theme
*   @return bool : (true=existe)
*/
function check_critere_libelle_theme($libelle,$theme){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=check_critere_libelle_theme_old($libelle,$theme);
    }
    return ($res);
}

/**
    Verifier si un libelle de sous critere existe deja (OLD)
*
*   @param string :  le libelle du sous critere
*   @param integer : le numero du theme
*   @param integer : le numero du critere
*   @return bool : (true=existe)
*/
function check_souscritere_libelle_theme_critere_old($libelle,$theme,$critere){
    $sql="select num_srub from sousrubrique where libelle_srub='$libelle' and srub_numtheme=$theme and num_rub=$critere";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return false;
    else
        return true;
}
/**
    Verifier si un libelle de sous critere existe deja
*
*   @param string :  le libelle du sous critere
*   @param integer : le numero du theme
*   @param integer : le numero du critere
*   @return bool : (true=existe)
*/
function check_souscritere_libelle_theme_critere($libelle,$theme,$critere){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=check_souscritere_libelle_theme_critere_old($libelle,$theme,$critere);
    }
    return ($res);
}


/**
    Enregistrer un sous critere (OLD)
*
*   @param string :  le libelle du sous critere
*   @param integer : le numero du theme
*   @return integer : le numero du sous critere si ok sinon 0
*/
function set_souscritere_old($libelle,$theme,$critere){
    if(!check_souscritere_libelle_theme_critere($libelle,$theme,$critere)){
        $sql="insert into sousrubrique(libelle_srub,srub_numtheme,num_rub) values('$libelle',$theme,$critere)";
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_srub from sousrubrique where oid=$oid");
        return (pg_result($res,0,0));
    }
    else
        return 0;
}
/**
    Enregistrer un sous critere
*
*   @param string :  le libelle du sous critere
*   @param integer : le numero du theme
*   @return integer : le numero du critere
*/
function set_souscritere($libelle,$theme,$critere){
    if(VERSION_BASE>VERSION){
    }
    else{
        $res=set_souscritere_old($libelle,$theme,$critere);
    }
    return ($res);
}






?>