<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fichier de configuration des plate-forme Astairs.
 * 
 * Ce fichier contient la dfinition des variables nceesaires au fonctionnement des plate-formes Astairs. 
 * 
 * @package configuration
 */
 
define("MAX_UPLOAD_SIZE","2");
//---------------------------------------------------------------------------------------------------------------
//                              			CONFIGURATION CONCERNANT POSTGRESQL
//---------------------------------------------------------------------------------------------------------------
$server="localhost";
$login="postgres";
$password="";

//---------------------------------------------------------------------------------------------------------------
//                              BASE admin_client 
//---------------------------------------------------------------------------------------------------------------
$serverclient="localhost";
$nombaseclient="admin_clients";
$loginclient="postgres";
$passwordclient="";

//---------------------------------------------------------------------------------------------------------------
//                              LES DIFFERENTS DOCUMENT ROOT POSSIBLES
//---------------------------------------------------------------------------------------------------------------
$documentRoot[]="interformation.net";
$documentRoot[]="html";
$documentRoot[]="bo_clients";

//---------------------------------------------------------------------------------------------------------------
//             										PRODUCTION
//---------------------------------------------------------------------------------------------------------------

//PGR
///////

	//adresses IP
	$CONFIG_ASTAIRS["production"]["pgr"]["ip"]["back"]="192.168.1.86";
	$CONFIG_ASTAIRS["production"]["pgr"]["ip"]["front"]="192.168.1.85";

	//base de donnes
	$CONFIG_ASTAIRS["production"]["pgr"]["ip"]["db"]="192.168.1.80";
	$CONFIG_ASTAIRS["production"]["pgr"]["user"]["db"]="www";
	$CONFIG_ASTAIRS["production"]["pgr"]["user"]["db_archive"]="www";

	//chemins
	$CONFIG_ASTAIRS["production"]["pgr"]["dir"]["chemin"]["back"]="/usr/local/www/data/foad/pgr/bo_clients/";
	$CONFIG_ASTAIRS["production"]["pgr"]["dir"]["chemin"]["front"]="/usr/local/www/data/foad/pgr/interformation.net/";

//MONO-CLIENT
//////////////

	//adresses IP
	$CONFIG_ASTAIRS["production"]["mono"]["ip"]["back"]="192.168.1.84";
	$CONFIG_ASTAIRS["production"]["mono"]["ip"]["front"]="192.168.1.83";

	//base de donnes
	$CONFIG_ASTAIRS["production"]["mono"]["ip"]["db"]="192.168.1.80";
	$CONFIG_ASTAIRS["production"]["mono"]["dir"]["db"]="prod_formationdb";
	$CONFIG_ASTAIRS["production"]["mono"]["user"]["db"]="www";
	$CONFIG_ASTAIRS["production"]["mono"]["dir"]["db_archive"]="prod_formationdb_archive";
	$CONFIG_ASTAIRS["production"]["mono"]["user"]["db_archive"]="www";
	
	//chemins
	$CONFIG_ASTAIRS["production"]["mono"]["dir"]["chemin"]["back"]="/usr/local/www/data/foad/plateforme/back-office/";
	$CONFIG_ASTAIRS["production"]["mono"]["dir"]["chemin"]["front"]="/usr/local/www/data/foad/plateforme/interformation.net/";

//---------------------------------------------------------------------------------------------------------------
//             										PORTABLE
//---------------------------------------------------------------------------------------------------------------

//PGR
///////

	//adresses IP
	$CONFIG_ASTAIRS["portable"]["pgr"]["ip"]["back"]="192.168.1.247";
	$CONFIG_ASTAIRS["portable"]["pgr"]["ip"]["front"]="192.168.1.247";
	
	//base de donnes
	$CONFIG_ASTAIRS["portable"]["pgr"]["ip"]["db"]="localhost";
	$CONFIG_ASTAIRS["portable"]["pgr"]["user"]["db"]="postgres";
	$CONFIG_ASTAIRS["portable"]["pgr"]["user"]["db_archive"]="";
	
	//chemins
	$CONFIG_ASTAIRS["portable"]["pgr"]["dir"]["chemin"]["back"]="/var/www/html/bo_clients/";
	$CONFIG_ASTAIRS["portable"]["pgr"]["dir"]["chemin"]["front"]="/var/www/html/";

//MONO-CLIENT
//////////////

	//adresses IP
	$CONFIG_ASTAIRS["portable"]["mono"]["ip"]["back"]="192.168.1.247";
	$CONFIG_ASTAIRS["portable"]["mono"]["ip"]["front"]="192.168.1.247";
	
	//base de donnes
	$CONFIG_ASTAIRS["portable"]["mono"]["ip"]["db"]="localhost";
	$CONFIG_ASTAIRS["portable"]["mono"]["dir"]["db"]="prod_formationdb";
	$CONFIG_ASTAIRS["portable"]["mono"]["user"]["db"]="postgres";
	$CONFIG_ASTAIRS["portable"]["mono"]["dir"]["db_archive"]="";
	$CONFIG_ASTAIRS["portable"]["mono"]["user"]["db_archive"]="";
		
	//chemins
	$CONFIG_ASTAIRS["portable"]["mono"]["dir"]["chemin"]["back"]="/var/www/html/";
	$CONFIG_ASTAIRS["portable"]["mono"]["dir"]["chemin"]["front"]="/var/www/html/";


//---------------------------------------------------------------------------------------------------------------
//             										EN LIGNE
//---------------------------------------------------------------------------------------------------------------

//PGR
///////

	//adresses IP
	$CONFIG_ASTAIRS["enligne"]["pgr"]["ip"]["back"]="217.113.207.7";
	$CONFIG_ASTAIRS["enligne"]["pgr"]["ip"]["front"]="217.113.207.8";
	
	//base de donnes
	$CONFIG_ASTAIRS["enligne"]["pgr"]["ip"]["db"]="localhost";
	$CONFIG_ASTAIRS["enligne"]["pgr"]["user"]["db"]="www";
	$CONFIG_ASTAIRS["enligne"]["pgr"]["user"]["db_archive"]="www";
	
	//chemins
	$CONFIG_ASTAIRS["enligne"]["pgr"]["dir"]["chemin"]["back"]="/usr/local/www/data/foad/pgr/bo_clients/";
	$CONFIG_ASTAIRS["enligne"]["pgr"]["dir"]["chemin"]["front"]="/usr/local/www/data/foad/pgr/interformation.net/";

//MONO-CLIENT
//////////////

	//adresses IP
	$CONFIG_ASTAIRS["enligne"]["mono"]["ip"]["back"]="212.208.0.10";
	$CONFIG_ASTAIRS["enligne"]["mono"]["ip"]["front"]="www.interformation.net";
	
	//base de donnes
	$CONFIG_ASTAIRS["enligne"]["mono"]["ip"]["db"]="localhost";
	$CONFIG_ASTAIRS["enligne"]["mono"]["dir"]["db"]="formationdb";
	$CONFIG_ASTAIRS["enligne"]["mono"]["user"]["db"]="www";
	$CONFIG_ASTAIRS["enligne"]["mono"]["dir"]["db_archive"]="formationdb_archive";
	$CONFIG_ASTAIRS["enligne"]["mono"]["user"]["db_archive"]="www";
	
	//chemins
	$CONFIG_ASTAIRS["enligne"]["mono"]["dir"]["chemin"]["back"]="/usr/local/www/data/foad/plateforme/back-office/";
	$CONFIG_ASTAIRS["enligne"]["mono"]["dir"]["chemin"]["front"]="/usr/local/www/data/foad/plateforme/interformation.net/";

//---------------------------------------------------------------------------------------------------------------
//             										CHERBOURG
//---------------------------------------------------------------------------------------------------------------

//MONO-CLIENT (uniquement)
//////////////////////////

	//adresses IP
	$CONFIG_ASTAIRS["cherbourg"]["mono"]["ip"]["back"]="192.168.1.94";
	$CONFIG_ASTAIRS["cherbourg"]["mono"]["ip"]["front"]="192.168.1.93";

	//base de donnes	
	$CONFIG_ASTAIRS["cherbourg"]["mono"]["ip"]["db"]="localhost";
	$CONFIG_ASTAIRS["cherbourg"]["mono"]["dir"]["db"]="prod_cherbourgdb";
	$CONFIG_ASTAIRS["cherbourg"]["mono"]["dir"]["db_archive"]="";
	
	//chemins
	$CONFIG_ASTAIRS["cherbourg"]["mono"]["dir"]["chemin"]["back"]="/usr/local/www/data/foad/plateforme/bo_clients/";
	$CONFIG_ASTAIRS["cherbourg"]["mono"]["dir"]["chemin"]["front"]="www.interformation.net/cherbourg";

?>
