<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
*  Biblioth�que de fonctions pour le front et le back
*	@package root
*/

/**
 * Obtenir la liste des bases du server en cours de connection
 * @return string retourne la requete a executer pour r�cup�rer la liste des bases de donn�es
 */
function getDataBases (){
	$sql = "
		SELECT pdb.datname AS datname,
			(SELECT spcname FROM pg_catalog.pg_tablespace pt WHERE pt.oid=pdb.dattablespace) AS tablespace
		FROM pg_database pdb, pg_user pu
		WHERE pdb.datdba = pu.usesysid
		AND pdb.datallowconn
		ORDER BY pdb.datname";
 	return $sql;
}

/**
 * Obtenir la liste des schemas de la base a la quelle on est connecte
 * @return string retourne la requete a executer pour r�cup�rer la liste des schemas
 */
function getSchemas() {
	$where = "WHERE nspname NOT LIKE 'pg\\\\_%' AND nspname NOT LIKE 'information_schema'";
	$sql = "
		SELECT pn.nspname,comparaison de dates avec php
			pu.usename AS nspowner,
			pg_catalog.obj_description(pn.oid, 'pg_namespace') AS nspcomment
		FROM pg_catalog.pg_namespace pn LEFT JOIN pg_catalog.pg_user pu ON (pn.nspowner = pu.usesysid)
		{$where} ORDER BY nspname";
	 
	return $sql;
}

/**
 * Obtenir toutes les fonctions d'une base
 * @param string $schema sch�ma � utiliser
 * @return string requ�te permetant le retour de la liste des fonctions avec leurs proprit�s
 */
function getFunctions($schema = 'public') {
	//choix du sch�ma
	$where = "n.nspname = '$schema'";

	//construction de la requ�te
	$sql = "
				SELECT
					p.proname,
					p.oid AS prooid,
					pl.lanname AS prolanguage,
					pg_catalog.format_type(p.prorettype, NULL) AS proresult,
					prosrc AS prodefinition,
					p.proretset,
					proisstrict,
					provolatile,
					prosecdef,
					pg_catalog.oidvectortypes(p.proargtypes) AS proarguments,
					pg_catalog.obj_description(p.oid, 'pg_proc') AS procomment,
					p.proname || ' (' || pg_catalog.oidvectortypes(p.proargtypes) || ')' AS proproto,
					CASE WHEN p.proretset THEN 'setof ' ELSE '' END || pg_catalog.format_type(p.prorettype, NULL) AS proreturns,
					u.usename AS proowner
				FROM
					pg_catalog.pg_proc p
				INNER JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace
				INNER JOIN pg_catalog.pg_language pl ON pl.oid = p.prolang
				LEFT JOIN pg_catalog.pg_user u ON u.usesysid = p.proowner
				WHERE NOT p.proisagg
				AND {$where}
				ORDER BY p.proname, proresult";
	return $sql;
}

/**
 * Obtenir la liste des types n'appartenant pas aux types syst�me
 * @param string $schema shema utilis� pour le retour des types
 * @return string requ�te sql retournant les types du sch�ma pass� en param�tre
 */
function getTypes($schema = 'public') {
	//d�finition du sh�ma � utiliser
	$where = "n.nspname = '{$schema}'";
	//pas d'affichage des fonctions syst�me
	$where2 = "AND c.relnamespace NOT IN (SELECT oid FROM pg_catalog.pg_namespace WHERE nspname LIKE 'pg\\\\_%')";

	// Create type filter
	$tqry = "'c'";

	//cr�ation de la requ�te
	$sql = "
				SELECT
					t.typname AS basename,
					pg_catalog.format_type(t.oid, NULL) AS typname,
					pu.usename AS typowner,
					t.typtype,
					pg_catalog.obj_description(t.oid, 'pg_type') AS typcomment
				FROM (pg_catalog.pg_type t
					LEFT JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace)
					LEFT JOIN pg_catalog.pg_user pu ON t.typowner = pu.usesysid
				WHERE (t.typrelid = 0 OR (SELECT c.relkind IN ({$tqry}) FROM pg_catalog.pg_class c WHERE c.oid = t.typrelid {$where2}))     
				AND t.typname !~ '^_'
				AND {$where}            
				ORDER BY typname";
	return $sql;
}

/**
 * Creates a new function.
 * @param $funcname The name of the function to create
 * @param $args A comma separated string of types
 * @param $returns The return type
 * @param $definition The definition for the new function
 * @param $language The language the function is written for
 * @param $flags An array of optional flags
 * @param $setof True if it returns a set, false otherwise
 * @param $replace (optional) True if OR REPLACE, false for normal
 * @return 0 success
 */
function createFunction($proto, $returns='returns', $language='pgsql', $volatile = 'v', $isstrict = 'f', $secdef = 'f', $definition='definition', $owner = 'pgsql',$comment, $schema='public', $replace = true) {
//	$sql = "
//
//--
//-- Name : FUNCTION {$schema}.{$proto};
//--";
	$sql .= "
CREATE";
	if ($replace)
		$sql .= " OR REPLACE";
	$sql .= " FUNCTION {$schema}.{$proto}";

	// For some reason, the returns field cannot have quotes...
	$sql .= "
	RETURNS {$returns} AS";
	$sql .= "
\$BODY\$".$definition . "\$BODY\$";

	$sql .= "
	LANGUAGE '{$language}'";
	
	switch ($volatile){
		case "s" :
			$sql .= " STABLE";
			break;
		case "i" :
			$sql .= " IMMUTABLE";
			break;
		default :
			$sql .= " VOLATILE";
	}
	if($isstrict = 't')
		$sql .= "
	RETURNS NULL ON NULL INPUT";
	
	if($secdef = 'v')
		$sql .= "
	SECURITY DEFINER;";
	$sql .= "
ALTER FUNCTION {$schema}.{$proto} OWNER TO $owner;";
	if($comment != '')
	$sql .= "
COMMENT ON FUNCTION {$schema}.{$proto} IS '".clean($comment)."';";
	
	return $sql;
}

/**
 * Creates a new type
 * @param ...
 * @return 0 success
 */
function createType($typname, $typin, $typout, $typlen, $typdef, $typelem, $typdelim, $typbyval, $typalign, $typstorage) {
	$this->fieldClean($typname);
	$this->fieldClean($typin);
	$this->fieldClean($typout);

	$sql = "
		CREATE TYPE \"{$typname}\" (
		INPUT = \"{$typin}\",
		OUTPUT = \"{$typout}\",
		INTERNALLENGTH = {$typlen}";
	if ($typdef != '')
		$sql .= ", DEFAULT = {$typdef}";
	if ($typelem != '')
		$sql .= ", ELEMENT = {$typelem}";
	if ($typdelim != '')
		$sql .= ", DELIMITER = {$typdelim}";
	if ($typbyval)
		$sql .= ", PASSEDBYVALUE, ";
	if ($typalign != '')
		$sql .= ", ALIGNMENT = {$typalign}";
	if ($typstorage != '')
		$sql .= ", STORAGE = {$typstorage}";

	$sql .= ")";

	return $sql;
}

/**
 * Cleans (escapes) a string
 * @param $str The string to clean, by reference
 * @return The cleaned string
 */
function clean(&$str) {
    if ($str === null) return null;
    $str = str_replace("\r\n","\n",$str);
    if (function_exists('pg_escape_string'))
        $str = pg_escape_string($str);
    else
        $str = addslashes($str);
    return $str;
}

/**
	fonction qui retourne la version de postgres (ex 7.1.3)
*/
function version_postgres() {
	$req = "SELECT version() as version";
	$res_version = @ pg_query($req);
	$row_version = @ pg_result($res_version, 0, "version");

	// Split out the version numbers for later use  $ver_num[0] contains the entire version
	ereg("([6-9]).([0-9A-Za-z])[.]?([0-9])?", $row_version, $ver_num);
	// ereg("([6-9]).([0-9]).([0-9])", $row_version, $ver_num);
	$version = $ver_num[0];
	//echo "[$version]";
	return $version;
}


/**
 * Ouvre une connection � une base de donn�es PostgreSQL.
 * 
 * En cas d'erreur de connection, un message est affich� et l'execution des scripts est stopp�e.(Appel de la fonction exit() )
 * 
 * @global string : adresse du serveur PostgreSQL
 * @global string : nom de la base de donn�es
 */ 
function connecteDB(){
	global $server, $nombase;
	$db = pg_connect("$server", "", "", "", "$nombase");
	if(!$db){
		print("$ERROR_98");
		exit();
	}
	return $db;
}

/**
 * Transforme un tableau PHP contenant des entiers en une chaine pour fonction PL/PGSQL.
 * La chaine retourn�e est au format utilisable comme argument d'une fonction PL/PGSQL.
 * Cette fonction est donc tr�s pratique pour passer un tableau d'entier � une fonction.
 * 
 * @param array : un tableau PHP d'entiers
 * @return string : une chaine PHP contenant les �l�ments du tableau au format PL/PGSQL
 */
function int_array_to_plpgsql_array($array){
	if(!is_array($array)){
		die ("La fonction int_array_to_plpgsql_array($array) requiert un tableau en argument");
	}
	//pour r�indexer le tableau
	$array=(array_values($array));
	
	$chaine="_int4 '{";
	$nb=count($array);
	for($i=0; $i<$nb-1; $i++){
		$chaine.="$array[$i],";
	}
	if($nb>0)$chaine.=$array[$nb-1];
	$chaine.="} '";
	return $chaine;
}

/**
 * Transforme un tableau PHP contenant des chaines en une chaine pour fonction PL/PGSQL.
 * La chaine retourn�e est au format utilisable comme argument d'une fonction PL/PGSQL.
 * Cette fonction est donc tr�s pratique pour passer un tableau de chaines � une fonction.
 * 
 * @param array : un tableau PHP de chaines
 * @return string : une chaine PHP contenant les �l�ments du tableau au format PL/PGSQL
 */
function string_array_to_plpgsql_array($array){
	if(!is_array($array)){
		die ("La fonction string_array_to_plpgsql_array($array) requiert un tableau en argument");
	}
	//pour r�indexer le tableau
	$array=(array_values($array));
	
	$chaine="_varchar \$\${";
	$nb=count($array);
	for($i=0; $i<$nb-1; $i++){
		$chaine.=string2Sql($array[$i]).",";
	}
	if($nb>0)$chaine.=string2Sql($array[$nb-1]);
	$chaine.="}\$\$";
	return $chaine;
}

function text_array_to_plpgsql_array($array){
	if(!is_array($array)){
		die ("La fonction text_array_to_plpgsql_array($array) requiert un tableau en argument");
	}
	//pour r�indexer le tableau
	$array=(array_values($array));
	
	$chaine="_text \$\${\"";
	$nb=count($array);
	for($i=0; $i<$nb-1; $i++){
		$chaine.=$array[$i]."\",\"";
	}
	if($nb>0)$chaine.=$array[$nb-1];
	$chaine.="\"}\$\$";
	return $chaine;
}


///**
// * Transforme un tableau PHP contenant des chaines en une chaine pour fonction PL/PGSQL.
// * La chaine retourn�e est au format utilisable comme argument d'une fonction PL/PGSQL.
// * Cette fonction est donc tr�s pratique pour passer un tableau de chaines � une fonction.
// * comparaison de dates avec php
// * @param array : un tableau PHP de chaines
// * @return string : une chaine PHP contenant les �l�ments du tableau au format PL/PGSQL
// */
//function string_array_to_plpgsql_array($array){
//	if(!is_array($array)){
//		die ("La fonction int_array_to_plpgsql_array($array) requiert un tableau en argument");
//	}
//	//pour r�indexer le tableau
//	$array=(array_values($array));
//	
//	$chaine=' _varchar $${';
//	$nb=count($array);
//	for($i=0; $i<$nb-1; $i++){
//		$chaine.="'".addslashes(str_replace ( "'","''", $array[$i]))."',";
//	}
//	if($nb>0)$chaine.="'".addslashes(str_replace ( "'","''", $array[$i]))."'";
//	$chaine.="}\$\$";
//	return $chaine;
//}

/**
 * Transforme une chaine pour fonction PL/PGSQL contenant des chaines en tableau PHP.
 * La chaine retourn�e est au format utilisable .
 * Cette fonction est donc tr�s pratique pour passer un tableau de chaines � une fonction.
 * 
 * @param array : un tableau plpgsql de chaines  (ex : {'un','la'}
 * @return string : un tableau PHP contenant les �l�ments 
 */
function plpgsql_array_to_string_array($array){
	//echo "$array<br>";
	$chaine="$array";
	$chaine=substr($chaine,0,strlen($chaine)-2);
	
	$chaine=substr($chaine,2);
	 
	$tab=explode("','",$chaine);
	
	return $tab;
	
	
}

/**
 * Transforme une chaine pour fonction PL/PGSQL contenant des chaines en tableau PHP.
 * La chaine retourn�e est au format utilisable .
 * Cette fonction est donc tr�s pratique pour passer un tableau de chaines � une fonction.
 * 
 * @param array  un tableau PHP de chaines  
 * @return string une chaine  tableau SQL 
 */
 /*
function text_array_to_plpgsql_text($array){ //pour le set
	// recup la chaine entre accolades
	$tab=pg_array_parse($array,true);
//	$chaine=$array;
//	$chaine=substr($chaine,1,strlen($chaine)-2);
//	$tab=explode(",",$chaine);
//	if(!empty($tab[0])){
		return $tab;
//	}else {
//		return array();
//	}
	
}
*/

/**
 * Transforme un tableau php en une chaine plpgsql
 * ex : array("1","2") ==> {"1","2"}
 * 
 */
 function text_array_to_plpgsql_text($array){
 	$chaine="{";
 	while(list($cle,$val)=each($array)){
 		$chaine.='"'.addslashes($val).'",';
 	}
 	$chaine=substr($chaine,0,-1);
 	$chaine.="}";
// 	echo "\$chaine=$chaine";
 	return $chaine;
 		
 }


function plpgsql_array_to_text_array($array){ //pour le set
	// recup la chaine entre accolades
	$tab=pg_array_parse($array,true);
//	$chaine=$array;
//	$chaine=substr($chaine,1,strlen($chaine)-2);
//	$tab=explode(",",$chaine);
//	if(!empty($tab[0])){
		return $tab;
//	}else {
//		return array();
//	}
	
}
/**
 * Transforme une chaine  en tableau PHP.
 * 
 *
 * 
 * @param string une chaine  tableau SQL   
 * @return array  un tableau PHP de chaines
 */
 /*
function plpgsql_text_to_text_array($text){ //pour le get
	//echo "ici text=$text<br>";
	$separator="},#";
	$tab=explode($separator,$text);
	//if(count($tab)>
	return $tab;
	
}
*/
/**
 * Transforme un text contenant des chaines ams en un tableau php
 * 
 */
function plpgsql_text_ams_to_text_array($text,$langue_trouve=null){ 
//	echo 'A$texte='.$text;
	$texte= get_bo_fo_libelle($text,&$langue_trouve);
//	echo "\$langue_trouve".$langue_trouve;
//	echo 'B$texte='.$texte;
//		echo 'C$texte='.stripslashes($texte);
	$tab=pg_array_parse(stripslashes($texte),true);
//	print_rr($tab);
	
	//if(count($tab)>
	return $tab;
	
}


/**
 * Change a db array into a PHP array
 * 
 * Attention fonctionne UNIQUEMENT avec une string SQL correspondant � un tableau SQL de type {toto,"ti ti"}, 
 * donc pas avec _text {toto,"ti ti"}
 * 
 * @author Chris KL, from http://fr3.php.net/pgsql
 * @param $arr String representing the DB array
 * @return A PHP array
 */
function pg_array_parse($dbarr, $asText = true) {
        // Take off the first and last characters (the braces)
        $arr = substr($dbarr, 1, strlen($dbarr) - 2);

        // Pick out array entries by carefully parsing.  This is necessary in order
        // to cope with double quotes and commas, etc.
        $elements = array();
        $i = $j = 0;       
        $in_quotes = false;
        while ($i < strlen($arr)) {
            // If current char is a double quote and it's not escaped, then
            // enter quoted bit
            $char = substr($arr, $i, 1);
            if ($char == '"' && ($i == 0 || substr($arr, $i - 1, 1) != '\\'))
                $in_quotes = !$in_quotes;
            elseif ($char == ',' && !$in_quotes) {
                // Add text so far to the array
                $elements[] = substr($arr, $j, $i - $j);
                $j = $i + 1;
            }
            $i++;
        }
        // Add final text to the array
        $final_text=substr($arr, $j); //test ajout� par RC pour pouvoir retourner un tableau vide quand il le faut
        if(!empty($final_text))$elements[] =$final_text ;

        // Do one further loop over the elements array to remote double quoting
        // and escaping of double quotes and backslashes
        for ($i = 0; $i < sizeof($elements); $i++) {
            $v = $elements[$i];
            if (strpos($v, '"') === 0) {
                $v = substr($v, 1, strlen($v) - 2);
               // $v = str_replace('\\"', '"', $v);
                $v = str_replace('\\\\', '\\', $v);
                $elements[$i] = $v;
            }
        }
        return $elements;
}

/**
 * Conversion d'un bool�en PHP en bool�en SQL.
 * @param bool  $boolean Le bool�en PHP.
 * @return string Le bool�en SQL
 */
function bool2Sql($boolean){
	if(!is_bool($boolean)){
		die("Erreur bool2Sql($boolean): Le parametre n'est pas de type Bool.($boolean is ".gettype($boolean).")</br>");
	}
	else{
		if($boolean===true){
			return "TRUE";
		}else{
			return "FALSE";
		}	
	}
}

/**
 * Conversion d'un bool�en SQL en bool�en PHP.
 * @param string $sql_boolean Le bool�en SQL.
 * @return bool Le bool�en PHP
 */
function sql2Bool($sql_boolean){
	if($sql_boolean!='t'&&$sql_boolean!='f'&&!empty($sql_boolean)){
		die("Erreur sql2Bool($sql_boolean): Le parametre n'est pas un bool�en SQL ( 't' ou 'f' uniquement).");
	}
	else{
		if($sql_boolean=='t'){
			return true;
		}else{
			return false;
		}	
	}
}

/**
 * Conversion d'un entier PHP en entier SQL.
 * @param bool  $integer L'entier PHP.
 * @return string L'entier SQL
 */
function int2Sql($integer){
	if(is_null($integer)||(empty($integer))&&$integer!='0'){
			return "NULL";
	}
	if(!is_int((int)$integer)){
		die("Erreur int2Sql($integer): Le parametre n'est pas de type Int.(".gettype($integer).")</br>");
	}
	if($integer==0)$integer='0';
	return $integer;
}



/**
 * Conversion d'une chaine PHP en chaine SQL.
 * @param string  $string La chaine PHP.
 * @return string La chaine SQL
 */
function string2Sql($string){
	$string=trim($string);
	if(!is_string($string)&&!is_null($string)){
		die("Erreur string2Sql($string): Le parametre n'est pas de type String.(".gettype($string).")</br>");
	}
	else{
		if(is_null($string)||empty($string)){
			return 'NULL';
		}else{
//			return "'$string'";
			return "'".addslashes($string)."'";
//			return addslashes($string);
		}	
	}
}

function sql2String($sql_string){
	if(empty($sql_string)||$sql_string=='NULL')
		return null;
	else
		return $sql_string;
}

/**
 * Obtenir une representation d'un timestamp sql sous la forme d'une chaine affichable.
 * Le format en entr�e est sous la forme "2007-01-09 14:34:17.201201" et le format
 * de sortie est sous la forme "le 09-01-2007 � 14:34:17".
 * Selon les langues (constante MY_LANG ), ce format de sortie peut-etre diff�rent, car il est adapt� � la repr�sentation du pays.
 * @param SQL_Timestamp $sql_timestamp timetamp SQL
 * @return string la chaine format�e
 */
function sql2StringTimestamp($sql_timestamp){
	global $s_langue;
	$tmp=explode(' ',$sql_timestamp);
	$date=$tmp[0];
	$heure=$tmp[1];
	$tmp=explode('-',$date);
	$a=$tmp[0];
	$mo=$tmp[1];
	$j=$tmp[2];
	$tmp=explode(':',$heure);
	$h=$tmp[0];
	$mi=$tmp[1];
	$s=substr($tmp[2],0,strpos($tmp[2],'.'));
	switch ($s_langue) {
		case "french" :
		case 1 :
			return MOT_11." $j-$mo-$a ".MOT_10." $h:$mi:$s";
		case "english" :
		case 2 :
		default :
			return MOT_10." $h:$mi:$s ".MOT_11." $a-$mo-$j ";
			break;
	}
}

function sql2StringDate($sql_date){
	
	global $s_langue;
//	print_rr($s_langue);
	$tab=explode('-',$sql_date);
	switch ($s_langue) {
		case "french" :
		case 1 :
			$dt = $tab[2]."/".$tab[1]."/".$tab[0];
			break;
		case "english" :
		case 2 :
		default :
			$dt = $tab[0]."/".$tab[1]."/".$tab[2];
			break;
	}
	return $dt;
}
/**
 * Obtenir une representation d'un timestamp sql sous la forme d'une chaine affichable.
 * Le format en entr�e est sous la forme "2007-01-09 14:34:17.201201" et le format
 * de sortie est sous la forme "09-01-2007 14:34:17".
 * Selon les langues (constante MY_LANG ), ce format de sortie peut-etre diff�rent, car il est adapt� � la repr�sentation du pays.comparaison de dates avec php
 * @deprecated utiliser sql2StringTimestamp
 * @param SQL_Timestamp $sql_timestamp timetamp SQL
 * @return string la chaine format�e
 */
function sql_timestamp_to_string($sql_timestamp){
	return sql2StringTimestamp($sql_timestamp);
}

/**
 * Obtenir une representation d'un interval sql sous la forme d'une chaine affichable.
 * Le format en entr�e est sous la forme "14:34:17.201201" et le format
 * de sortie est sous la forme "14 h 34 m 17 s".
 * @param SQL_Timestamp $sql_timestamp timetamp SQL
 * @return string la chaine format�e
 */
function sql_interval_to_string($sql_timestamp){
	global $MSG_263, $MSG_262, $MSG_261;
//echo "\$sql_timestamp=$sql_timestamp";
	$tmp=explode(':',$sql_timestamp);
	
	$dh=$tmp[0];
	$dhtmp=explode(' ',$dh);
	//print_rr($dhtmp);
	if(count($dhtmp)>1){
		for($i=0;$i<count($dhtmp)-1;$i++){
			if($i%2==0){
				if($dhtmp[$i+1]=='day'||$dhtmp[$i+1]=='days'){
					$d=$dhtmp[$i];
					$d.=" ".MSG_138;
				}
				else{
					die("sql_interval_to_string($sql_timestamp): ".$dhtmp[$i+1]."non pris en charge");
				}
			}
		}
		$h=$dhtmp[count($dhtmp)-1];
	}else{
		$h=$tmp[0];
	}
	$mi=$tmp[1];
	
	//bug coorrig�?
	$pos_point=strpos($tmp[2],'.');
	if($pos_point){
		$s=substr($tmp[2],0,$pos_point);
	}else{
		$s=$tmp[2];
	}

	//affichage en fonction des donn�es de temps
    if($h!=0){
            $affichage="$d $h $MSG_263 $mi $MSG_262 $s $MSG_261";
    }
    else{
		if($mi!=0){
			$affichage="$d $mi $MSG_262 $s $MSG_261";
		}
		else{
        	$affichage="$d $s $MSG_261";
		}
    }
	return $affichage;
}


/**
 * Obtenir le nombre de secondes correspondant � un interval sql 
 * Le format en entr�e est sous la forme "14:34:17.201201" 
 * @param SQL_Timestamp $sql_timestamp timetamp SQL
 * @return integer l'intervalle SQL en seconde'
 */
function sql_interval_to_secondes($sql_interval){
	if(empty($sql_interval))return null;	
	$req="SELECT extract(epoch from '$sql_interval'::interval);";
//	echo $req;
	$secondes=pg_fetch_result(pg_query($req),0,0);
	return $secondes;
}

function get_sql_now(){
	$req="SELECT * FROM now()";
	return pg_fetch_result(pg_query($req),0,0);
}

function get_sql_interval_from_now($debut){
	if(empty($debut))	
		die("get_sql_interval_from_now(): parametre manquant");
	$req="SELECT * FROM  age( '$debut',now())";
	 //echo $req;
	return pg_fetch_result(pg_query($req),0,0);
}

function get_seconds_from_now($debut){
	if(empty($debut))	
		die("get_seconds_from_now(): parametre manquant");
	$req="SELECT * FROM extract(epoch from age( '$debut',now()))";
//	 echo $req;
	return pg_fetch_result(pg_query($req),0,0);
}

function get_seconds_from_timestamp($debut,$duree_secondes){
	if(empty($debut)||empty($duree_secondes))	
		die("get_seconds_from_timestamps(): parametre manquant");
	$req="SELECT * FROM extract(epoch from age( TIMESTAMP '$debut'+ '$duree_secondes seconds',now()))";
//	 echo $req;
	return pg_fetch_result(pg_query($req),0,0);
}

function get_sql_timestamp_temporalite($sql_timestamp,$secondes){
	if(empty($sql_timestamp)||empty($secondes))	
		die("get_sql_timestamp_temporalite(): parametre manquant");

	$req="SELECT ('$sql_timestamp', INTERVAL '$secondes seconds') OVERLAPS
       (now(),INTERVAL '$secondes seconds');";
//       echo $req;
	return sql2Bool(pg_fetch_result(pg_query($req),0,0));
}

function get_sql_unix_timestamp(){
	$req="select extract(epoch from now())::bigint;";
	return pg_fetch_result(pg_query($req),0,0);
}

function compare_sql_now_to_sql_date($date){
	$now=get_sql_now();
	$now=explode(" ",$now);
	$now=$now[0];
	return strcmp($date,$now);
}

/**
 * Transforme un intervalle sql en chaine affichable
 * exemple de format en entr�e : 12 years 5 mons 45 days 01:15:52
 * @param sql interval
 * @return string : la chaine format�e
 */
 function sql2Interval($sql_interval){
 	global $MSG_2610,$MSG_2611,$MSG_1111;
 	// chaine de retour
 	$chaine=""; 
 	$tab=explode(" ",$sql_interval);
 	$nb=sizeof($tab);
 	
 	// chaine heure:minute:seconde
 	$hms="";
 	if($nb==1 || $nb==3 || $nb==5 || $nb==7){
 		$hms=sql_interval_to_string($tab[$nb-1]);	
 	}
 	// test si ann�e
 	if($tab[1]=="year" || $tab[1]=="years"){
 		$chaine.=$tab[0]." ".$MSG_2610;
 		if($tab[0]>1)
 			$chaine.="s";
 		// test si mois
 		if($nb>3){
 			if($tab[3]=="mon" || $tab[3]=="mons"){
 				$chaine.=" ".$tab[2]." ".$MSG_2611;
 				if($tab[2]>1)
 					$chaine.="s";	
 				// test si jour
 				if($nb>5){
 					if($tab[5]=="day" || $tab[5]=="days"){
 						$chaine.=" ".$tab[4]." ".$MSG_1111;
 						if($tab[4]>1)	
 							$chaine.="s";	
 					}	
 				}
 			}
 			else{
 				if($tab[3]=="day" || $tab[3]=="days"){
 						$chaine.=" ".$tab[2]." ".$MSG_1111;
 						if($tab[2]>1)	
 							$chaine.="s";	
 				}		
 			}
 		}
 		
 	}
 	else{
 		if($tab[1]=="mon" || $tab[1]=="mons"){
 			$chaine.=" ".$tab[0]." ".$MSG_2611;	
 			if($tab[0]>1)
 				$chaine.="s";
 			// test si jour
 			if($nb>3){
 				if($tab[3]=="day" || $tab[3]=="days"){	
 					$chaine.=" ".$tab[2]." ".$MSG_1111;
 					if($tab[2]>1)	
 						$chaine.="s";
 				}
 			}
 				
 		}
 		else{
 			if($tab[1]=="day" || $tab[1]=="days"){
 				$chaine.=" ".$tab[0]." ".$MSG_1111;
 				if($tab[0]>1)
 					$chaine.="s";		
 			}
 			
 		}	
 	}
 	$chaine.=" ".$hms;
 	return $chaine;
 	
 }
 
 /**
  * Teste si date du jour
  * @param date : date (yyyy-mm-dd) ou (yyyy-mm-dd 17:21:45...)
  * @return integer : 0 date du jour, -1 pass�e, +1 future
  * 
  */
 function is_today($date){
 	// r�cup la partie date
 	$dt=explode(" ",$date);
	$dt=$dt[0]; 
	// m�me op�ration sur la date sql du jour
	$now=get_sql_now();
	$now=explode(" ",$now);
	$now=$now[0];
	// compare les deux dates
	$tab_date=explode("-",$date);
	$tab_now=explode("-",$now);
	// test si les 2 tableaux sont identiques
	if(array_compare($tab_date,$tab_now))
		return 0;
	if(get_seconds_from_now($date)>0)
		return 1;
	return -1;
}


?>