<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
   @package droit
   @modulegroup plpgsql
   @module plpgsql_droit
*/

/**
	Obtenir les infos d'un droit  (OLD)
	@param integer : numero droit
	@return integer : resultat requete
*/
function get_droit_old($droit){
	$sql=" select num_droit,libelle_droit,type_droit ,defaut from DROIT where num_droit=$droit";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir les infos d'un droit 
	@param integer : numero droit
	@return integer : resultat requete
*/
function get_droit($droit){
	if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_get_droit($droit) as (id int4,libelle varchar,type int4,defaut bool)";
		$res=pg_query($sql);
	}
	else
		$res=get_droit_old($droit);
	return $res;
}

/**
	Mettre  jour un droit (OLD)
	@param integer : numero droit
	@param string : libelle
	@param bool : defaut
	@return integer : resultat requete
*/
function maj_droit_old($droit,$libelle,$defaut){
	$sql="update DROIT set libelle_droit='$libelle',  defaut='$defaut' where num_droit=$droit;" ;
	return pg_query($sql);
}
 /**
	Mettre  jour un droit 
	@param integer : numero droit
	@param string : libelle
	@param bool : defaut
	@return integer : resultat requete
*/
function maj_droit($droit,$libelle,$defaut){
	if(VERSION_BASE > VERSION){
		if($defaut==1)
			$defaut='t';
		else
			$defaut='f';
		 $sql="select * from contraintes.af_maj_droit($droit,'$libelle','$defaut')";
		 $res=pg_query($sql);
	}
	else
		$res=maj_droit_old($droit,$libelle,$defaut);
	return $res;
}

function get_droits(){
	$sql="select * from contraintes.fw_get_droits() AS (id integer, libelle varchar, code varchar, defaut boolean)";
	return pg_query($sql);
}
?>