<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoElement.
 * Un DoElement est l'objet de base de tout objet d'avancement.
 * 
 * @package element
 */
class DoElement{
	
	/**
	 * @var integer Identifiant de l'Element concern par l'avancement.
	 */
	var $element;
	
	/**
	 * @var integer Identifiant de l'Individu concern par l'avancement.
	 */
	var $individu;
	
	/**
	 * Constucteur.
	 * Affecte les attributs de la classe  
	 * partir des paramtres.
	 * 
	 * @param integer $element Identifiant de l'Element concern par l'avancement.
	 * @param string $individu Identifiant de l'Individu concern par l'avancement.
	 */
	function DoElement($element, $individu){
		$this->element=$element;
		$this->individu=$individu;
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	
	/**
	 * Vrifie les attributs de la classe.
	 * En cas d'attributs invalide, gnre une erreur.
	 */
	function initDoElement(){
		if(!empty($this->element)&&!empty($this->individu)){
			
		}else{
			die("Erreur initDoElement(): L'objet ne peut etre initialis.(".$this->getElement().",".$this->getIndividu().")");
		}	
	}
	
	/**
	 * Commence le DoElement.
	 * Ne fait rien.
	 */
	function begin(){
		messageDebug("DoElement::begin()");
	}

	/**
	 * Construit le DoElement.
	 * Ne fait rien.
	 */
	function perform(){
		messageDebug("DoElement::perform()");
		return null;
	}

	/**
	 * Termine le Node.
	 * Dsaffecte les attributs de l'objet.
	 *  @return boolean true ou false suivant le succs ou non de la mthode.
	 */
	function end(){
		messageDebug("DoElement::end()");
//		unset($this->element);
//		unset($this->individu);
		return true;
	}
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------	

	function getElement(){
		return $this->element;
	}
	
	function getIndividu(){
		return $this->individu;
	}	
}
?>
