<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * D�finition d'un DoElementEntity.
 * 
 * @package element
 */
class DoElementEntity extends DoElement{
	
	/**
	 * @var integer Identifiant de l'objet variable pour lequel l'avancement s'applique (parcours, ...)
	 */
	var $entity;
	
	/**
	 * @var object DoNode Objet d'avancement du Node courant.
	 */
	var $obj_DoNode;
	
	/**
	 * @var object DoNodeFactory Fabrique d'objet d'avancement de Node.
	 */
	var $obj_DoNodeFactory;
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs h�rit�s.
	 * @param integer $element Identifiant de l'objet constant pour lequel l'avancement s'applique (formation ...)
	 * @param integer $individu l'individu qui effectue l'objet constant pour lequel l'avancement s'applique (la formation)
	 * @param object DoNodeFactory &$obj_DoNodeFactory Fabrique servant � la cr�ation des objets d'avancement de la Formation
	 */
	function DoElementEntity($element, $individu,&$obj_DoNodeFactory){
		messageDebug("DoElementEntity::DoElementEntity($element, $individu)");
		parent::DoElement($element, $individu);
		$this->obj_DoNodeFactory=$obj_DoNodeFactory;
		$this->entity=null;
		$this->current_node=null;
		$this->current_node_type=null;
	}
	
	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * @param integer $entity Identifiant de l'objet variable pour lequel l'avancement s'applique (parcours, serie, ...)
	 * @param integer $current_node Identifiant de l'objet d'avancement du Node courant.
	 * @param integer $current_node_type Identifiant du type de l'objet d'avancement du Node courant.
	 */
	function initDoElementEntity($entity,$current_node, $current_node_type){
		messageDebug("DoElementEntity::initDoElementEntity($entity,$current_node, $current_node_type)");
		parent::initDoElement();
		if(!empty($entity)&&!empty($current_node)&&!empty($current_node_type)&&is_object($this->obj_DoNodeFactory)){
			$this->entity=$entity;
			$this->current_node=$current_node;
			$this->current_node_type=$current_node_type;
		}else{
			die("DoElementEntity::initDoElementEntity($entity,$current_node, $current_node_type,&$obj_DoNodeFactory): L'objet ne peut etre initialis�.");
		}	
	}

	/**
	 * D�but de la gestion de l'avancement.
	 * Initialise le DoNode courant en fonction de l'avancement en base de donn�es.
	 */
	function begin(){
		messageDebug("DoElementEntity::begin()");
		if(!is_object($this->obj_DoNode)){
			$this->nextDoNode();
		}else{
			die("DoElementEntity::begin(): L'objet DoElementEntity ne peut etre commenc�: Il l'a d�j� �t� pr�cedement.<br/>");
		}
	}
	
	/**
	 * Construction de l'objet Node associ� au DoNode courrant de l'avancement.
	 * @return object Node 
	 */
	function &perform(){
		messageDebug("DoElementEntity::perform()");
		if(!is_object($this->obj_DoNode)){
			die("DoElementEntity::perform(): L'objet DoElementEntity ne peut etre effectu�: Il n'a pas �t� commenc�.<br/>");	
		}
		
		if(!is_object($this->obj_DoNode->obj_node)){
			$this->obj_DoNode->obj_node=&$this->obj_DoNodeFactory->obj_NodeFactory->createEtape($this->getCurrentDoEtape());
		}else{
			die("DoElementEntity::perform(): L'objet DoElementEntity ne peut etre effectu�: Il l'a d�j� �t� pr�cedement.<br/>");
		} 
		return $this->obj_DoNode->obj_node;
	}

	/**
	 * Termine la gestion de l'avancement.
	 * R�initialise les attributs de l'objet � null.
	 * @return boolean true ou false selon que le traitement aie �t� bien effectu�e ou non.
	 */
	function end(){
		messageDebug("DoElementEntity::end()");
		if(!is_object($this->obj_DoNode)){
			$this->entity=null;
			$this->current_node=null;
			$this->current_node_type=null;
			$this->obj_DoNodeFactory=null;
			return true;
		}else{
			die("DoElementEntity::end(): L'Entity ne peut etre termin�e: le Node courrant n'est pas null.<br/>");
		}
	}		


//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	
	/**
	 * D�bute le DoNode courant.
	 * @return integer l'identifiant r�sultat 
	 */
	function beginCurrentNode(){
		messageDebug("DoElementEntity::beginCurrentEtape()");
		
		if(is_object($this->obj_DoNode->obj_node)){
			return $this->obj_DoNode->beginCurrentEtape();			
		}else{
			die("DoElementEntity::beginCurrentEtape(): L'�tape courante ne peut �tre commenc�e: La formation doit avoir �t� commenc� et effecu�e avant.<br/>");
			return false;
		}
	}

	/**
	 * Construction de l'objet Node courant.
	 * @return object Node Le Node courant
	 */
	function performCurrentNode(){
		messageDebug("DoElementEntity::performCurrentNode()");
		return $this->obj_DoNode->performCurrentEtape($this->obj_DoNodeFactory->getNodeFactory());
	}
	
	/**
	 * Termine le DoNode courant.
	 * @param object Resultat $obj_resultat : Resultat associ� � l'objet associ� � l'avancement.
	 * @return boolean True ou False selon que le traitement s'est bien d�roul� ou non.
	 */
	function endCurrentNode($obj_resultat=null){
		messageDebug("DoElementEntity::endCurrentNode($obj_resultat)");

		if($this->obj_DoNode->isBegin()){
			messageDebug("DoElementEntity::endCurrentNode l'�tape courante est commenc�e ");

			if($this->obj_DoNode->isEnd()){
				messageDebug("DoElementEntity::endCurrentNode l'�tape courante est termin�e, on passe a la suivante.");
				//on passe a l'�tape suivante'
				unset($this->obj_DoNode);
				$this->nextDoNode();
				
			}else{
				messageDebug("DoElementEntity::endCurrentNode l'�tape courante N'est PAS termin�e, on la termine.");
				//on la termine
				$res_node=$this->obj_DoNode->endCurrentEtape($obj_resultat);
				//si elle a bien �t� termin�e
				if($res_node){
					messageDebug("DoElementEntity::endCurrentNode l'�tape courante � �t� termin�e, on passe a la suivante.");
					//on passe a l'�tape suivante'
					unset($this->obj_DoNode);
					$this->nextDoNode();
				}
			}
			return true;
		}else{
			die("DoElementEntity::endCurrentNode(): L'�tape courante ne peut etre termin�e car elle n'a pas �t� commenc�e.</b><br/>");
			return false;
		}
	}	
	
//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	/**
	 * Obtenir l'avancement dans la formation.
	 * Si la date de d�but est valu�e, l'�tape courante est d�j� commenc�e.
	 * @return Array la ligne resultat de la requete (parcours int4, etape int4,type int4, formation int4,individu int4, date_debut timestamp)
	 */
	function getAvancement(){
		messageDebug("DoElementEntity::getAvancement()");
		$res_avancement=get_resultat_formation($this->element,$this->individu);
		$row_avancement=pg_fetch_row($res_avancement);
//		print_rr($row_avancement);
		return $row_avancement;
	}
	
	/**
	 * Charge le DoNode suivant
	 * Si le DoNode courant n'est pas termin�, le meme DoNode est recharg�.
	 * @return boolean true si il y a bien un noeud suivant, false sinon
	 */
	function &nextDoNode(){
		messageDebug("DoElementEntity::nextDoNode");
		
		$row_avancement=$this->getAvancement();
//		print_rr($row_avancement);
		messageDebugR("DoElementEntity::nextDoNode obj_DoNode",$this->obj_DoNode);
		if(!empty($row_avancement[0])){
			$this->initDoElementEntity($row_avancement[0], $row_avancement[1],$row_avancement[2]);
			$this->obj_DoNode=& $this->obj_DoNodeFactory->createDoEtape($row_avancement[0],$row_avancement[1],$row_avancement[2]);
			
			if(is_subclass_of($this->obj_DoNode,"DoParcoursDynamique")||is_subclass_of($this->obj_DoNode,"DoEtapeDynamique")){
				$this->obj_DoNode->perform(&$this);
			}
			return true;
		}
		else{
			messageDebug("DoElementEntity::nextDoNode : Pas de node suivant pour l'entity(Il n'y a plus d'etape � la formation)");
			$this->obj_DoNode=null;
		}
		return false;
	} 	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir l'identifiant de l'objet variable pour lequel l'avancement s'applique (parcours, serie, ...)
	 * @return  integer Identifiant de l'objet variable pour lequel l'avancement s'applique
	 */
	function &getEntity(){
		return $this->entity;
	}

	/**
	 * Obtenir l'objet d'avancement du Node courant.
	 * @return object DoNode l'objet d'avancement du Node courant.
	 */
	function &getDoNode(){
		return $this->obj_DoNode;
	}

	function setDoNode($obj_DoNode){
		$this->obj_DoNode=$obj_DoNode;
	}
		
	/**
	 * Obtenir la fabrique de DoNodes
	 * @return object DoNodeFactory La fabrique de Nodes.
	 */
	function &getDoNodeFactory(){
		return $this->obj_DoNodeFactory;
	}

	/**
	 * Obtenir l'objet R�sultat associ� � l'avancement actuel.
	 * @return object Resultat Objet � utiliser avec la m�thode endCurrentEtape(). 
	 */	
	function &getCurrentResultat(){
		return $this->obj_DoNode->getCurrentResultat();
	}
	
	/**
	 * Indique si il y a un obj_DoNode courrant.
	 * @return boolean TRUE ou FALSE.
	 */
	function isBegin(){
		if(is_object($this->obj_DoNode)){
			return true;
		}else{
			return false;
		}
	}	
}
?>
